from __future__ import print_function, division

_vmap = "1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ+/"
_rvmap = dict(map(lambda (x,y): (y,x), enumerate(_vmap)))

def val_to_output(x, none):
    return none if x is None else _vmap[x]

def output_to_val(x, none):
    return None if x == none else _rvmap[x]

class Grid(object):
    def __init__(self, game):
	self.game = game
	self.data = [[None for y in range(game.height)] for x in range(game.width)]

    def set_from_terms(self, terms):
	for x in terms:
	    term = x[0]
	    x, y, n = self.game.decomp(term)
	    self.data[x][y] = n
	return self

    def set_from_dot(self, dot):
	game = self.game
	for x in range(game.width):
	    for y in range(game.height):
		self.data[x][y] = output_to_val(dot[x + y * game.width], '.')
	return self

    def as_terms(self):
	res = []
	game = self.game
	for x in range(game.width):
	    for y in range(game.height):
		if self.data[x][y] is not None:
		    res.append([game.term(x, y, self.data[x][y])])
	return res

    def as_dot(self):
	res = []
	for row in map(None, *self.data):
	    for x in row:
		res.append(val_to_output(x, '.'))
	return str.join('', res)

    def as_ascii(self):
	data = self.data
	res = [[val_to_output(data[x][y],' ') for x in range(len(data))] for y in range(len(data[0]))]
	return str.join('\n', map(''.join, res))
