# encoding: utf8
from __future__ import print_function, division
import optparse
import random
import sys
import solver
import dimacs
import shared
import engine

def parse_opts(game, argv):
    parser = optparse.OptionParser()
    parser.add_option("-v", "--verbose", action="store_true", default=False)
    parser.add_option("-w", "--width", type="int")
    parser.set_conflict_handler("resolve")
    parser.add_option("-h", "--height", type="int")
    parser.set_conflict_handler("error")
    parser.add_option("--minimize", action="store_true",
			help="the givens will be minimized after generation/input "
			"default: only if generating")
    parser.add_option("--no-minimize", action="store_false", dest="minimize")
    solvers = solver.solvers.keys()
    parser.add_option("-r", "--solver", choices=solvers, default=game.default_solver,
			help="use SAT solver: " + ', '.join(solvers) +
			    "\t[default: %default]")
    parser.add_option("-t", "--format", choices=game.output_formatter.keys(), action="append")
    parser.add_option("-n", type="int", dest="num", default=1,
			help="generate this many instances [default: %default]")
    parser.add_option("-s", "--seed", type="int",
			help="random seed for game generation [default: python's]")
    parser.add_option("-e", "--strategy", choices=engine.strategies.keys(), default=game.default_strategy,
			help="constraint generation strategy: " + ', '.join(engine.strategies.keys()) +
			    " [default: %default]")
    parser.add_option("--solve", action="store_true", default=False, help="output solution")
    parser.add_option("-k", "--keep", action="store_true", default=False,
			help="don't remove temporary files")
    parser.add_option("-#", type="int", dest="sols")
    parser.add_option("-o", "--timeout", type="float", help="maximum time "
			"SAT solver should spend solving any given instance")
    parser.add_option("--47", action="store_true", dest="fortyseven", default=False)
    (options, args) = parser.parse_args(argv)
    return options

def process_options(game, options):
    if options.format is None:
	options.format = game.output_formatter.keys()
    if options.seed is not None:
	random.seed(options.seed)
    shared.print1 = print if options.verbose else shared.nada
    options.solver = solver.solvers[options.solver]
    if options.minimize is None:
	options.minimize = options.strategy != 'stdin'
	if options.solve and game.dont_minimize_when_solving:
	    options.minimize = False
    options.strategy = engine.strategies[options.strategy]()
    if options.sols is not None:
	options.strategy.solution_count = options.sols
    return options

def main(game_class):
    try:
	import psyco
	psyco.full()
    except ImportError:
	print("No psyco, running slowly.", file=sys.stderr)
	pass
    options = parse_opts(game_class, sys.argv[1:])
    options = process_options(game_class, options)
    game = game_class(options)
    strategy = options.strategy
    with dimacs.cnf(game.name, game.nterms) as rules:
	with options.solver(game.name) as sat:
	    rules.extend(game.rules)
	    rules.keep = options.keep
	    sat.keep = options.keep
	    sat.timeout = options.timeout
	    sat.set_primary_variables(x+1 for x in range(game.baseterms))
	    base_count = len(rules)
	    for i in range(options.num):
		rules.truncate(base_count)
		constraints = strategy.generate(game, rules, sat)
		if options.minimize:
		    constraints = engine.minimize(rules, sat, constraints)
		if not engine.verify(rules, sat, constraints):
		    continue
		if options.solve:
		    constraints += engine.solve(rules, sat, constraints)
		grid = game.grid_class(game).set_from_terms(constraints)
		for format in options.format:
		    print(game.output_formatter[format](grid))
