﻿<?php

    class modifyThesis extends page{
        private $post = Array();
        private $formvars = Array();
        private $error;
		private $id = "";
         
		function __construct( $smarty, $db, $action, $post, $get  )
		{
			parent::__construct( $smarty, $db, $action, $post, $get  );
			if ($this->CheckRights("modifyThesis")) $this->logged = true;
			else
			{
				$this->smarty->assign("accessDenied",true);
				$this->logged = false;
			}
			$this->funct = new functions();
			if ($_SESSION["IPaddress"] != $this->funct->GetRealIpAddr())
			{
				$this->logged = false;
			}
			$this->THESISMATH = true;
			$this->THESISINF = true;
			$this->navigation=new navigation($this->db);
			$this->menu=new menu($this->db);
			$this->menu->GenerateMenu("");
		}
    
		//check validity of retrieved values
		function verifyAdd($formvars, $action)
		{
			$this->formvars = $formvars;
			
			if ($action == "step1")
			{
				if(strlen(trim($this->formvars['NAME'])) == 0)
				{
				$this->SayError('Nezadaný názov práce');
				return false;
				}
			}
			
			if ($action == "step2")
			{
				if(count($this->formvars['OPPONENTS']) < 3)
				{
				$this->SayError('Nebol zadaný dostatočný počet oponentov');
				return false;
				}
				
				if(count($this->formvars['OPPONENTS']) > 3)
				{
					$this->SayError('Nebol zadaný dostatočný počet oponentov');
					return false;
				}
				
				if (!isset($_FILES["file"]))
				{
					$this->SayError("Nebola zadaný súbor s dizertačnou prácou.");
					return false;
				}
				
				$filename = "file_storage/".MD5($this->postParams["DOKTORAND_ID"]).$_FILES["file"]["name"];
				if (file_exists($filename))
				{
					$this->SayError("Súbor s názvom ".$_FILES["file"]["name"]." už existuje.");
					return false;
				}
			}
	
			return true;
		}
            
		function Process()
		{
			//list thesis details
			if ( $this->action === "details" )
			{   
				if ((is_numeric($this->getParams["id"]))  || ($this->id != ""))
				{
					$query = "SELECT * FROM DM_Thesis AS thesis WHERE thesis.ID='".$this->getParams["id"]."';";
					$result = $this->db->QueryToRow($query);
				
					// get all info about thesis from db
					if ( $result != 0 )
					{
						$thesisDetails["ID"] = $result["ID"];
						$thesisDetails["NAME"] = $result["NAME"];
						$thesisDetails["DOKTORAND_ID"] = $result["DOKTORAND_ID"]; 
						$thesisDetails["SECTION_ID"] = $result["SECTION_ID"]; 
						$thesisDetails["LECTOR_ID"] = $result["LECTOR_ID"];  
						$thesisDetails["ADDED"] = $result["ADDED"];
						$thesisDetails["OPPONENTS"] = explode('|',$result["OPPONENTS"]);
						$thesisDetails["COMMITTEE_ID"] = $result["COMMITTEE_ID"]; 
						$thesisDetails["FILENAME"] = $result["FILENAME"];  
						
						//select names
						$sectionquery = "SELECT * FROM DM_Sections WHERE DM_Sections.ID = ".$thesisDetails['SECTION_ID'].";";
						$result = $this->db->QueryToRow($sectionquery);  
						if ( $result != 0 )
						{	 
							 $thesisDetails['SECTION'] = $result["SECTION_NAME"];                        
						}
						unset($result);
						
						$docquery = "SELECT * FROM DM_Users WHERE DM_Users.ID='".$thesisDetails["DOKTORAND_ID"]."';";
						$result = $this->db->QueryToRow($docquery);  
						if ( $result != 0 )
						{
							 $thesisDetails['DOK_EMAIL'] = $result["EMAIL"];
							 $thesisDetails['DOKTORAND'] = $result["NAME"]." ".$result["SURNAME"];   
						}
						unset($result);
						
						$lectquery = "SELECT * FROM DM_Users WHERE DM_Users.ID='".$thesisDetails["LECTOR_ID"]."';";
						$result = $this->db->QueryToRow($lectquery);  
						if ( $result != 0 )
						{
							 $thesisDetails['LECTOR'] = $result["NAME"]." ".$result["SURNAME"];     
						}
						unset($result);
				
						// get opponent names from ids
						foreach ($thesisDetails["OPPONENTS"] as $key => $value) { 
							if (is_null($value) || $value=="")
							{ 
								unset($thesisDetails["OPPONENTS"][$key]); 
							} 
						}
						
						$pos = 0;
						foreach ($thesisDetails["OPPONENTS"] as $key => $value)
						{
							$query = "SELECT DM_Users.ID, DM_Users.NAME, DM_Users.SURNAME FROM DM_Users WHERE ".
							"DM_Users.ID='".$thesisDetails["OPPONENTS"][$key]."';";   
							$result = $this->db->QueryToRow($query); 
							if ($result != 0)
							{
								$thesisDetails["OPPONENT"][$pos]["ID"] = $result["ID"];
								$thesisDetails["OPPONENT"][$pos]["NAME"] = $result["NAME"]." ".$result["SURNAME"];
								unset($result);
								$pos += 1;
							}                       
						}
						
						// get committee informations
						$query = "SELECT * FROM DM_Committee WHERE DM_Committee.ID='".$thesisDetails["COMMITTEE_ID"]."';";
						$result = $this->db->QueryToRow($query);
						if ( $result != 0 )
						{
							$committeeDetails["Chairman"] = $result["CHAIRMAN"]; 
							$committeeDetails["Members"] = explode('|',$result["MEMBERS"]);   
						}
						else
						{
							$this->site->SayError("Komisia priradená k práci neexistuje."); 
						}
						
						$chairmanquery = "SELECT * FROM DM_Users WHERE DM_Users.ID='".$committeeDetails["Chairman"]."';";
						$result = $this->db->QueryToRow($chairmanquery);  
						if ( $result != 0 )
						{
								 $thesisDetails["CHAIRMAN"] = $result["NAME"]." ".$result["SURNAME"];                              
						}
						
						// get committee members names from ids
						foreach ($committeeDetails["Members"] as $key => $value) { 
							if (is_null($value) || $value=="")
							{ 
								unset($committeeDetails["Members"][$key]); 
							} 
						}
						
						$pos = 0;
						foreach ($committeeDetails["Members"] as $key => $value)
						{
							$query2 = "SELECT DM_Users.ID, DM_Users.NAME, DM_Users.SURNAME FROM DM_Users WHERE ".
							"DM_Users.ID='".$committeeDetails["Members"][$key]."';";   
							$result2 = $this->db->QueryToRow($query2); 
							if ($result2 != 0)
							{
								$thesisDetails["MEMBER"][$pos]["ID"] = $result2["ID"];
								$thesisDetails["MEMBER"][$pos]["NAME"] = $result2["NAME"]." ".$result2["SURNAME"];
								unset($result2);
								$pos += 1;
							}                       
						}
						
						$eventsquery = "SELECT * FROM DM_Events WHERE DM_Events.THESIS_ID='".$thesisDetails["ID"]."' ORDER BY DM_Events.ID ASC;";
						$eventsresult = $this->db->QueryToArray($eventsquery);  			
						if ( $eventsresult != 0 )
						{
							for ( $i = 0; $i < count($eventsresult); $i++ )
							{
								$thesisDetails["EVENTS"][$i]["ID"] = $eventsresult[$i]["ID"];
								$thesisDetails["EVENTS"][$i]["TYPE"] = $eventsresult[$i]["EVENT_TYPE"];
								$thesisDetails["EVENTS"][$i]["STATUS"] = $eventsresult[$i]["STATUS"];
								$thesisDetails["EVENTS"][$i]["COMMENT"] = $eventsresult[$i]["COMMENT"];
								$thesisDetails["EVENTS"][$i]["STATUS_CHANGED"] = $eventsresult[$i]["STATUS_CHANGED"];
								$thesisDetails["EVENTS"][$i]["DEADLINE"] = $eventsresult[$i]["DEADLINE"];
								$thesisDetails["EVENTS"][$i]["TERMINFO"] = $eventsresult[$i]["TERMINFO"];
								if ($i == count($eventsresult)-1)
								{
									$ACT_TYPE = $eventsresult[$i]["EVENT_TYPE"];
									$CONFIRMED = explode('|',$eventsresult[$i]["CONFIRMED"]);
								}                         
							}     
						}
						unset($eventsresult);
						
						//if the last event is addressed to members
						if (($ACT_TYPE == 1) || ($ACT_TYPE == 3))
						{ 
							$pos = 0;
							foreach ($committeeDetails["Members"] as $key => $value)
							{
								$query = "SELECT DM_Users.ID FROM DM_Users WHERE DM_Users.ID='".$committeeDetails["Members"][$key]."';";   
								$result = $this->db->QueryToRow($query); 
								if ( $result != 0 )
								{
									if (in_array($result["ID"], $CONFIRMED)) $thesisDetails["MEMBER"][$pos]["CHECKED"] = true;
									unset($result);
									$pos += 1;
								}                       
							}
						}
						
						//if the last event is addressed to opponents
						if ($ACT_TYPE == 2)
						{
							$pos = 0;
							foreach ($thesisDetails["OPPONENTS"] as $key => $value)
							{
								$query = "SELECT DM_Users.ID FROM DM_Users WHERE DM_Users.ID='".$thesisDetails["OPPONENTS"][$key]."';";   
								$result = $this->db->QueryToRow($query); 
								if ( $result != 0 )
								{
									if (in_array($result["ID"], $CONFIRMED)) $thesisDetails["OPPONENT"][$pos]["CHECKED"] = true;
									unset($result);
									$pos += 1;
								}                       
							}
						}
						
						$filename = "file_storage/".$thesisDetails["FILENAME"];
						if (($thesisDetails["FILENAME"] != "")&&(file_exists($filename)))
						{
							$this->smarty->assign("uploadedFile",TRUE);
						}
						else
						{
						  $this->smarty->assign("uploadedFile",FALSE);
						}
						
						if ($_SESSION["dontShowNavig"])
						{
							if ($_SESSION["ChairmanThesis"]) $currPage = "Evidencia práce";
							if ($_SESSION["LectorThesis"]) $currPage = "Informácie o priebehu práce";
						}
						else
						{
							$currPage = "Detaily práce";
						}
						$_SESSION["dontShowNavig"] = false;
						$_SESSION["ChairmanThesis"] = false;
						$_SESSION["LectorThesis"] = false;
						
						$navig = $this->navigation->GenerateNavigation($currPage);
						
						$this->smarty->assign("chairman",$_SESSION["chairman"]); 
						$this->smarty->assign("thesisDetails",$thesisDetails);
								
						$this->smarty->assign("content","thesisDetails.tpl");
					}
					else
					{  
						$this->smarty->assign("error","Údaje o príslušnej práci sa neporarilo získať");
      					$this->smarty->display("error.tpl");
						
						$currPage = "Administrácia prác";
						$navig = $this->navigation->GenerateNavigation($currPage);
						
						$this->smarty->assign("content","modifyThesisMain.tpl"); 
					}
				}
				else
				{
					$this->smarty->assign("error","Parametre práce neboli korektne zadané");
      				$this->smarty->display("error.tpl");
					
					$currPage = "Administrácia prác";
					$navig = $this->navigation->GenerateNavigation($currPage);
					
					$this->smarty->assign("content","modifyThesisMain.tpl");
				} 
			
			}
      
			//get groups and section before showing addThesis form
			elseif ( $this->action === "addThesis" )
			{        
				$sectionquery = "SELECT * FROM DM_Sections ORDER BY DM_Sections.ID ASC;";
				$result = $this->db->QueryToArray($sectionquery);  
			
				if ( $result != 0 )
				{
					for ( $i = 0; $i < count($result); $i++ )
					{
						 $post["sectionID"][$i] = $result[$i]["ID"];
						 $post["sectionName"][$i] = $result[$i]["SECTION_NAME"];                       
					}     
				}
			
				$currPage = "Pridanie práce";
				$navig = $this->navigation->GenerateNavigation($currPage);
			
				$this->smarty->assign("post",$post); 

				$this->smarty->assign("tplAction","step1");         
				$this->smarty->assign("content","addThesis.tpl");
			}
      
			//check if name is ok, add SECTION_ID and NAME to SESSION, display next form
			elseif ( $this->action === "step1" )
			{ 
				if ($this->verifyAdd($_POST, $this->action))
				{
					$_SESSION['thesis']["NAME"] = $this->formvars["NAME"];
					$_SESSION['thesis']["SECTION_ID"] = $this->postParams["SECTION_ID"];
              		
					$doc = 0;
					$query1 = "SELECT DM_Users.ID, DM_Users.NAME, DM_Users.SURNAME FROM DM_Users WHERE SECTION_ID = '".$_SESSION['thesis']["SECTION_ID"]."' AND (DM_Users.GROUPS LIKE '%1%') ORDER BY DM_Users.SURNAME ASC, DM_Users.NAME ASC;";
					$result1 = $this->db->QueryToArray($query1);  
					if ( $result1 != 0 )
					{
						for ( $i = 0; $i < count($result1); $i++ )
						{
							$thquery = "SELECT * FROM DM_Thesis WHERE DOKTORAND_ID = '".$result1[$i]["ID"]."';";
							$thresult = $this->db->QueryToArray($thquery);
							if ( count($thresult) == 0 )
							{
								$post["doktorandID"][$i] = $result1[$i]["ID"];
								$post["doktorandName"][$i] = $result1[$i]["SURNAME"]." ".$result1[$i]["NAME"];
								$doc += 1;
							}                       
						}     
            		}
					if ( $doc == 0 )
					{
						$this->SayError("V tomto odbore nieje k dispozícii žiadny doktorand, ktorý ešte nemá zadanú prácu.");
						$this->smarty->assign("disabled",true);	
					}
					unset($result1);
					
					$query2 = "SELECT DM_Users.ID, DM_Users.NAME, DM_Users.SURNAME FROM DM_Users WHERE SECTION_ID = '".$_SESSION['thesis']["SECTION_ID"]."' AND (DM_Users.GROUPS LIKE '%5%') ORDER BY DM_Users.SURNAME ASC, DM_Users.NAME ASC;";
					$result2 = $this->db->QueryToArray($query2);  
					if ( $result2 != 0 )
					{
						for ( $i = 0; $i < count($result2); $i++ )
						{
							 $post["lectorID"][$i] = $result2[$i]["ID"];
							 $post["lectorName"][$i] = $result2[$i]["SURNAME"]." ".$result2[$i]["NAME"];                       
						}     
            		}
					if ( count($result2) == 0 )
					{
						$this->SayError("V tomto odbore nieje k dispozícii žiadny školiteľ.");
						$this->smarty->assign("disabled",true);
					}
					unset($result2);
					
					$query3 = "SELECT DM_Users.ID, DM_Users.NAME, DM_Users.SURNAME FROM DM_Users WHERE (DM_Users.GROUPS LIKE '%2%') ORDER BY DM_Users.SURNAME ASC, DM_Users.NAME ASC;";
					$result3 = $this->db->QueryToArray($query3);
					if ( $result3 != 0 )
					{
						for ( $i = 0; $i < count($result3); $i++ )
						{
							 $post["opponentID"][$i] = $result3[$i]["ID"];
							 $post["opponentName"][$i] = $result3[$i]["SURNAME"]." ".$result3[$i]["NAME"];                       
						}     
            		}
					if ( count($result3) < 3 )
					{
						$this->SayError("V tomto odbore nieje k dispozícii dostatočný počet oponentov.");
						$this->smarty->assign("disabled",true);
					}
					unset($result);
					
					$query4 = "SELECT * FROM DM_Committee WHERE SECTION_ID = '".$_SESSION['thesis']["SECTION_ID"]."'";
					$result4 = $this->db->QueryToArray($query4);  
					if ( $result4 != 0 )
					{
						for ( $i = 0; $i < count($result4); $i++ )
						{
							$post["committeeID"][$i] = $result4[$i]["ID"];
							$post["committeeNames"][$i] = "";
							 
							$query5 = "SELECT DM_Users.NAME, DM_Users.SURNAME FROM DM_Users WHERE ID=".$result4[$i]["CHAIRMAN"].";";
							$result5 = $this->db->QueryToRow($query5);
							$post["committeeNames"][$i] .= "* ".$result5["SURNAME"]." ".$result5["NAME"]." * :: * ";
							unset($result5);
							
							$MEMBERS = explode('|',$result4[$i]["MEMBERS"]);  
							foreach ($MEMBERS as $key => $value) { 
								if (is_null($value) || $value=="")
								{ 
									unset($MEMBERS[$key]); 
								} 
							}

							foreach ($MEMBERS as $key => $value)
							{
								$query6 = "SELECT DM_Users.NAME, DM_Users.SURNAME FROM DM_Users WHERE ".
								"DM_Users.ID='".$MEMBERS[$key]."';";   
								$result6 = $this->db->QueryToRow($query6); 
								
								$post["committeeNames"][$i] .= $result6["SURNAME"]." ".$result6["NAME"]." * ";
								unset($result6);                       
							}                       
						}     
            		}
					if ( count($result4) == 0 )
					{
						$this->SayError("V tomto odbore nieje k dispozícii žiadna komisia.");
						$this->smarty->assign("disabled",true);
					}
					unset($result);
					
					$currPage = "Pridanie práce";
					$navig = $this->navigation->GenerateNavigation($currPage);
            
					$this->smarty->assign("post",$post);
					
					$this->smarty->assign("tplAction","step2");             
					$this->smarty->assign("content","addThesis.tpl");
        		} 
         		else
				{
					$currPage = "Pridanie práce";
					$navig = $this->navigation->GenerateNavigation($currPage);
					
					$this->smarty->assign("post",$this->formvars); 
 
					$this->smarty->assign("tplAction","step1"); 
					$this->smarty->assign("content","addThesis.tpl");   
					$this->action = "addThesis";     
					$this->Process();
             	}         
      		}
			
			//add thesis to DB and send notifications
			elseif ( $this->action === "step2" )
			{ 
				//data verification
				if ($this->verifyAdd($_POST, $this->action))
				{
            		//if file is set, save file to filesystem
					
						$filename = "file_storage/".MD5($this->postParams["DOKTORAND_ID"]).$_FILES["file"]["name"];
						move_uploaded_file($_FILES["file"]["tmp_name"], $filename);
						$dbQuery["FILENAME"] = MD5($this->postParams["DOKTORAND_ID"]).$_FILES["file"]["name"];
					  
					//get values posted from template  
					$dbQuery["NAME"] = $_SESSION['thesis']["NAME"];
					$dbQuery["SECTION_ID"] = $_SESSION['thesis']["SECTION_ID"]; 
					$dbQuery["DOKTORAND_ID"] = $this->postParams["DOKTORAND_ID"]; 
					$dbQuery["LECTOR_ID"] = $this->postParams["LECTOR_ID"];
					$dbQuery["OPPONENTS"] = "|".implode('|', $this->postParams["OPPONENTS"])."|"; 
					$dbQuery["COMMITTEE_ID"] = $this->postParams["COMMITTEE_ID"];    
            
          			$query = "INSERT INTO DM_Thesis (".implode(",", array_keys($dbQuery)).") VALUES ('".implode("','", array_values($dbQuery))."')"; 
        			$result = $this->db->Query($query);
					
					$paramsOpponents = $this->postParams["OPPONENTS"];
					$paramsCommittee = $this->postParams["COMMITTEE_ID"];
					$paramsDoktorand = $this->postParams["DOKTORAND_ID"];
					$paramsThesis = $_SESSION['thesis']["NAME"];
					
        
					//add event about adding thesis and notify chairman
					$event = new event($this->smarty, $this->db, $this->action, $_POST, $_GET);
					$init = $event->makeInitEvent($paramsOpponents, $paramsCommittee, $paramsDoktorand, $paramsThesis);
					
					if ($init)
					{
						$this->SayReport("Údaje o práci boli zaznamenané a mail pre schválenie oponentov bol pripravený na odoslanie");
					}
					else
					{
						$this->SayReport("Údaje o práci boli zaznamenané.");
						$this->SayError("Mail pre schválenie oponentov sa nepodarilo pripraviť na odoslanie.");
					}
					
					$sendmail = new sendEmail($this->smarty, $this->db, $this->action, $_POST, $_GET); 
					$mailparams = Array();
					
					$query = "SELECT users.NAME, users.SURNAME FROM DM_Users AS users WHERE users.ID='".$paramsDoktorand."';";
					$result = $this->db->QueryToRow($query);
					$mailparams["%DOKTORAND%"] = $result["NAME"]." ".$result["SURNAME"];
					unset($result);
					
					$query = "SELECT DM_Committee.CHAIRMAN FROM DM_Committee WHERE DM_Committee.ID='".$paramsCommittee."';";
					$result = $this->db->QueryToRow($query);
					$chairman = $result["CHAIRMAN"];
					unset($result);
					
					$query = "SELECT * FROM DM_Users AS users WHERE users.ID='".$chairman."';";
					$result = $this->db->QueryToRow($query);
					$mailparams["%NAME%"] = $result["NAME"]." ".$result["SURNAME"];
					$email = $result["EMAIL"];
					unset($result);
					
					$mailparams["%ADDRESS%"] = $_SESSION["address"];       
					$mailparams["%THESIS%"] = $_SESSION['thesis']["NAME"];
					
					$sentOK = $sendmail->simpleSend($email,"", "2", $mailparams,"");	
			
					if ($sentOK)
					{
						$this->SayReport("Mailová notifikácia bola úspešne odoslaná.");
					}
					else
					{
						$this->SayError("Nepodarilo sa odoslať mailovú notifikáciu.");
					}
					
					$currPage = "Administrácia prác";
					$navig = $this->navigation->GenerateNavigation($currPage);
					   
					$this->smarty->assign("content","modifyThesisMain.tpl");       
        		} 
         		else
				{
					$currPage = "Pridanie práce";
					$navig = $this->navigation->GenerateNavigation($currPage);
				
					$this->smarty->assign("post",$this->formvars); 
 
					$this->smarty->assign("tplAction","step2"); 
					$this->smarty->assign("content","addThesis.tpl");   
					$this->action = "addThesis";   
					$this->Process();
             	}         
      		}
      
      
			// list thesis
			else if ( $this->action === "listThesis" )
			{
				
				if ($this->getParams["select"] == "yes")
				{
					$this->THESISMATH = $this->postParams["THESISMATH"];
					$this->THESISINF = $this->postParams["THESISINF"];
				}
				
				$cond = "WHERE ( ";
				if ($this->THESISMATH) $cond .= "DM_Thesis.SECTION_ID=1 OR ";
				if ($this->THESISINF) $cond .= "DM_Thesis.SECTION_ID=2 OR ";
				$cond .= "1=0 )";
				
				if (substr($this->getParams["order"],-4) === "DESC")
				{
					$keyword = substr($this->getParams['order'], 0, -4);
					$orders = array("NAME", "DOKTORAND_ID", "LECTOR_ID", "SECTION_ID", "ADDED");
					if (isset($keyword) && in_array($keyword, $orders))
					{
						$query = "SELECT * FROM DM_Thesis ".$cond." ORDER BY DM_Thesis.".$keyword." DESC;";
						$this->smarty->assign("order","");
					}
				}
				else
				{
					$keyword = $this->getParams['order'];
					$orders = array("NAME", "DOKTORAND_ID", "LECTOR_ID", "SECTION_ID", "ADDED");
					if (isset($keyword) && in_array($keyword, $orders))
					{
						$query = "SELECT * FROM DM_Thesis ".$cond." ORDER BY DM_Thesis.".$keyword." ASC;";
						$this->smarty->assign("order",$keyword);
					}
					else
					{
						$query = "SELECT * FROM DM_Thesis;";
					}
				}
				            
        		$result = $this->db->QueryToArray($query);
        
				if ( $result != 0 )
				{
					for ( $i = 0; $i < count($result); $i++ )
					{
						$userquery = "SELECT * FROM DM_Users WHERE ID=".$result[$i]['DOKTORAND_ID'].";";
						$users = $this->db->QueryToRow($userquery);
						$lectorquery = "SELECT * FROM DM_Users WHERE ID=".$result[$i]['LECTOR_ID'].";";
						$lectors = $this->db->QueryToRow($lectorquery);						
						$sectionquery = "SELECT * FROM DM_Sections WHERE ID=".$result[$i]["SECTION_ID"].";";
						$sections = $this->db->QueryToRow($sectionquery);
					
						 $thesisList[$i]["ID"] = $result[$i]["ID"];
						 $thesisList[$i]["NAME"] = $result[$i]["NAME"];
						 $thesisList[$i]["DOKTORAND"] = $users["NAME"]." ".$users["SURNAME"];
						 $thesisList[$i]["SECTION"] = $sections["SECTION_NAME"]; 
						 $thesisList[$i]["LECTOR"] = $lectors["NAME"]." ".$lectors["SURNAME"]; 
						 $thesisList[$i]["ADDED"] = $result[$i]["ADDED"];
						 
						$eventquery = "SELECT * FROM DM_Events WHERE DM_Events.THESIS_ID=".$thesisList[$i]['ID']." AND DM_Events.STATUS=0;";
						$eventresult = $this->db->QueryToArray($eventquery);
						if (count($eventresult) > 0)
						{	
							$thesisList[$i]["ACTION"] = "mail";
							unset($eventresult);
						}
						
						$eventquery = "SELECT * FROM DM_Events WHERE DM_Events.THESIS_ID=".$thesisList[$i]['ID']." AND DM_Events.STATUS=1;";
						$eventresult = $this->db->QueryToArray($eventquery);
						if (count($eventresult) > 0)
						{	
							$thesisList[$i]["ACTION"] = "wait";
							unset($eventresult);
						}
						
						$eventquery = "SELECT * FROM DM_Events WHERE DM_Events.THESIS_ID=".$thesisList[$i]['ID']." AND DM_Events.STATUS=2;";
						$eventresult = $this->db->QueryToArray($eventquery);
						if (count($eventresult) > 0)
						{	
							$thesisList[$i]["ACTION"] = "urge";
							unset($eventresult);
						}
						
						$eventquery = "SELECT * FROM DM_Events WHERE DM_Events.THESIS_ID=".$thesisList[$i]['ID']." AND DM_Events.STATUS=3;";
						$eventresult = $this->db->QueryToArray($eventquery);
						if (count($eventresult) == 3)
						{	
							$thesisList[$i]["ACTION"] = "done";
							unset($eventresult);
						}
					 
          			}
					$this->smarty->assign("order",$this->getParams["order"]);
				}
				else
				{
					$this->smarty->assign("empty",true);
				}
				
				if ($this->getParams["select"] == "yes")
				{
					$this->smarty->assign("THESISMATH",$this->postParams["THESISMATH"]);
					$this->smarty->assign("THESISINF",$this->postParams["THESISINF"]);
					
					$this->THESISMATH = $this->postParams["THESISMATH"];
					$this->THESISINF = $this->postParams["THESISINF"]; 	 
				}
				else
				{
					$this->smarty->assign("THESISMATH",true);
					$this->smarty->assign("THESISINF",true);
					
					$this->THESISMATH = true;
					$this->THESISINF = true;
				}
		
				$currPage = "Zoznam prác";
				$navig = $this->navigation->GenerateNavigation($currPage);
				
				$this->smarty->assign("admin",$_SESSION["admin"]);
				$this->smarty->assign("chairman",$_SESSION["chairman"]);  
				$this->smarty->assign("showSelect",true);
				$this->smarty->assign("thesisList",$thesisList);
				
				$this->smarty->assign("content","listThesis.tpl"); 
			}
      
	  		else if ( $this->action === "listChairmanThesis" )
			{
				$query = "SELECT * FROM DM_Committee WHERE DM_Committee.CHAIRMAN=".$_SESSION["userID"].";";
				$result = $this->db->QueryToArray($query);
				if ($result != 0)
				{
					$committee = "(".$result[0]["ID"];

					for ( $i = 1; $i < count($result); $i++ )
					{
						$committee .= ",".$result[$i]["ID"];
					}
					$committee .= ")";	
				}
				
				$query = "SELECT * FROM DM_Thesis WHERE DM_Thesis.COMMITTEE_ID IN ".$committee." ORDER BY DM_Thesis.ID ASC;";          
        		$result = $this->db->QueryToArray($query);
				
				if ( $result != 0 )
				{
					for ( $i = 0; $i < count($result); $i++ )
					{
						$userquery = "SELECT * FROM DM_Users WHERE ID=".$result[$i]['DOKTORAND_ID'].";";
						$users = $this->db->QueryToRow($userquery);
						$lectorquery = "SELECT * FROM DM_Users WHERE ID=".$result[$i]['LECTOR_ID'].";";
						$lectors = $this->db->QueryToRow($lectorquery);						
						$sectionquery = "SELECT * FROM DM_Sections WHERE ID=".$result[$i]["SECTION_ID"].";";
						$sections = $this->db->QueryToRow($sectionquery);
					
						 $thesisList[$i]["ID"] = $result[$i]["ID"];
						 $thesisList[$i]["NAME"] = $result[$i]["NAME"];
						 $thesisList[$i]["DOKTORAND"] = $users["NAME"]." ".$users["SURNAME"];
						 $thesisList[$i]["SECTION"] = $sections["SECTION_NAME"]; 
						 $thesisList[$i]["LECTOR"] = $lectors["NAME"]." ".$lectors["SURNAME"]; 
						 $thesisList[$i]["ADDED"] = $result[$i]["ADDED"];
						 
						$eventquery = "SELECT * FROM DM_Events WHERE DM_Events.THESIS_ID=".$thesisList[$i]['ID']." AND DM_Events.STATUS=0;";
						$eventresult = $this->db->QueryToArray($eventquery);
						if (count($eventresult) > 0)
						{	
							$thesisList[$i]["ACTION"] = "mail";
							unset($eventresult);
						}
						
						$eventquery = "SELECT * FROM DM_Events WHERE DM_Events.THESIS_ID=".$thesisList[$i]['ID']." AND DM_Events.STATUS=1;";
						$eventresult = $this->db->QueryToArray($eventquery);
						if (count($eventresult) > 0)
						{	
							$thesisList[$i]["ACTION"] = "wait";
							unset($eventresult);
						}
						
						$eventquery = "SELECT * FROM DM_Events WHERE DM_Events.THESIS_ID=".$thesisList[$i]['ID']." AND DM_Events.STATUS=2;";
						$eventresult = $this->db->QueryToArray($eventquery);
						if (count($eventresult) > 0)
						{	
							$thesisList[$i]["ACTION"] = "urge";
							unset($eventresult);
						}
						
						$eventquery = "SELECT * FROM DM_Events WHERE DM_Events.THESIS_ID=".$thesisList[$i]['ID']." AND DM_Events.STATUS=3;";
						$eventresult = $this->db->QueryToArray($eventquery);
						if (count($eventresult) == 3)
						{	
							$thesisList[$i]["ACTION"] = "done";
							unset($eventresult);
						}
						   
          			}
				}
				else
				{
					$this->smarty->assign("empty",true);
				}
				
				$_SESSION["dontShowNavig"] = true;
				$_SESSION["ChairmanThesis"] = true;
				
				$currPage = "Práce doktorandov";
				$navig = $this->navigation->GenerateNavigation($currPage);
				
				$this->smarty->assign("chairman",$_SESSION["chairman"]);  
				$this->smarty->assign("thesisList",$thesisList);
				
				$this->smarty->assign("content","listThesis.tpl");
			}
			
			//list lector thesis
			else if ( $this->action === "listLectorThesis" )
			{	
				$query = "SELECT * FROM DM_Thesis WHERE DM_Thesis.LECTOR_ID=".$_SESSION["userID"]." ORDER BY DM_Thesis.ID ASC;";          
        		$result = $this->db->QueryToArray($query);
				if ( $result != 0 )
				{
					for ( $i = 0; $i < count($result); $i++ )
					{
						$userquery = "SELECT * FROM DM_Users WHERE ID=".$result[$i]['DOKTORAND_ID'].";";
						$users = $this->db->QueryToRow($userquery);
						$lectorquery = "SELECT * FROM DM_Users WHERE ID=".$result[$i]['LECTOR_ID'].";";
						$lectors = $this->db->QueryToRow($lectorquery);						
						$sectionquery = "SELECT * FROM DM_Sections WHERE ID=".$result[$i]["SECTION_ID"].";";
						$sections = $this->db->QueryToRow($sectionquery);
					
						 $thesisList[$i]["ID"] = $result[$i]["ID"];
						 $thesisList[$i]["NAME"] = $result[$i]["NAME"];
						 $thesisList[$i]["DOKTORAND"] = $users["NAME"]." ".$users["SURNAME"];
						 $thesisList[$i]["SECTION"] = $sections["SECTION_NAME"]; 
						 $thesisList[$i]["LECTOR"] = $lectors["NAME"]." ".$lectors["SURNAME"]; 
						 $thesisList[$i]["ADDED"] = $result[$i]["ADDED"];
						   
          			}
				}
				else
				{
					$this->smarty->assign("empty",true);
				}
				
				$_SESSION["dontShowNavig"] = true;
				$_SESSION["LectorThesis"] = true;
				$lector = in_array('5', $_SESSION["userGroup"]);
				
				$currPage = "Vedené práce";
				$navig = $this->navigation->GenerateNavigation($currPage);
  
				$this->smarty->assign("thesisList",$thesisList);
				
				$this->smarty->assign("content","listThesis.tpl");
			}
			
			//delete thesis
			else if ( $this->action === "delete" )
			{
				$deletedID = $this->getParams["id"];
				
				if (is_numeric($deletedID))
				{
					$checkquery = "SELECT * FROM DM_Thesis WHERE DM_Thesis.ID='".$deletedID."';"; 	 
					$checkresult = $this->db->QueryToRow($checkquery);
					if ($checkresult != 0)
					{
						$eventquery = "SELECT * FROM DM_Events WHERE DM_Events.THESIS_ID=".$deletedID." AND DM_Events.STATUS=3;";
						$eventresult = $this->db->QueryToArray($eventquery);
						if (count($eventresult) == 3)
						{	
							$mayDelete = true;
							unset($eventresult);
						}
						else
						{
							$mayDelete = false;
						}
						
						if ($mayDelete)
						{
							$query = "DELETE FROM DM_Thesis WHERE DM_Thesis.ID='".$deletedID."' LIMIT 1;"; 		 
							$result = $this->db->Query($query);
							
							$query = "DELETE FROM DM_Events WHERE DM_Events.THESIS_ID='".$deletedID."';"; 		 
							$result = $this->db->Query($query);
						
							$this->SayReport("Práca bola zmazaná");
						}
						else
						{
							$this->smarty->assign("error","Prácu zadanú na zmazanie nieje povolené zmazať, lebo na nej prebieha prípravný proces pre obhajoby");
							$this->smarty->display("error.tpl");
						}
					}
					else
					{
						$this->smarty->assign("error","Práca zadaná na zmazanie neexistuje");
						$this->smarty->display("error.tpl");
					}
				}
				else
				{
					$this->smarty->assign("error","Parametre práce na vymazanie neboli korektne zadané");
      				$this->smarty->display("error.tpl");
				}
						
				$currPage = "Zoznam prác";
				$navig = $this->navigation->GenerateNavigation($currPage);
				  
				$this->smarty->assign("content","listThesis.tpl");
				$this->action = "listThesis";     
				$this->Process();
				 
			}
			
			//if chairman do a request about thesis
			else if ( $this->action === "request" )	
			{
				$eventID = $this->getParams["event"];
				if (is_numeric($eventID))
				{
					$query = "SELECT * FROM DM_Events WHERE DM_Events.ID=".$eventID.";";
					$result = $this->db->QueryToRow($query);
					if ( $result != 0 )
					{
						$thesisID = $result["THESIS_ID"];
						$eventType = $result["EVENT_TYPE"];
						unset($result);
						
						//if the request is addressed(by type) to committee members
						if (($eventType == 1) || ($eventType == 3))
						{
							$query = "SELECT * FROM DM_Thesis WHERE DM_Thesis.ID=".$thesisID.";";
							$result = $this->db->QueryToRow($query);
							$committee = $result["COMMITTEE_ID"];
							unset($result);
			
							$query = "SELECT * FROM DM_Committee WHERE DM_Committee.ID=".$committee.";";
							$result = $this->db->QueryToRow($query);
							$members = explode('|',$result["MEMBERS"]);
							unset($result);
							
							foreach ($members as $key => $value)
							{ 
								if (is_null($value) || $value=="")
								{ 
									unset($members[$key]); 
								} 
							}
						
							$pos = 0;
							$cond = true;
							foreach ($members as $key => $value)
							{
								$cond = ($cond && ($this->postParams["member$value"]));
								if ($this->postParams["member$value"])
								{
									$memberConf[$pos] = $value;
									$pos += 1;
								}
							}
						
							$confirmed = "|".implode('|', $memberConf)."|";
						}
						//if the event type is addressed to opponents
						else if ($eventType == 2)
						{
							$query = "SELECT * FROM DM_Thesis WHERE DM_Thesis.ID=".$thesisID.";";
							$result = $this->db->QueryToRow($query);
							$opponents = explode('|',$result["OPPONENTS"]);
							unset($result);
							
							foreach ($opponents as $key => $value)
							{ 
								if (is_null($value) || $value=="")
								{ 
									unset($opponents[$key]); 
								} 
							}
						
							$pos = 0;
							$cond = true;
							foreach ($opponents as $key => $value)
							{
								$cond = ($cond && ($this->postParams["opponent$value"]));
								if ($this->postParams["opponent$value"])
								{
									$oppConf[$pos] = $value;
									$pos += 1;
								}
							}
						
							$confirmed = "|".implode('|', $oppConf)."|";
						}
						
						$event = new event($this->smarty, $this->db, $this->action, $_POST, $_GET);
						$notif = $event->request($eventID, $eventType, $cond, $confirmed);
						
						$currPage = "Práce doktorandov";
						$navig = $this->navigation->GenerateNavigation($currPage);
						  
						$this->action = "listChairmanThesis";     
						$this->Process();
					}
					else
					{
						$this->smarty->assign("error","Úloha zadaná na vykonanie neexistuje");
						$this->smarty->display("error.tpl");
						
						$currPage = "Administrácia prác";
						$navig = $this->navigation->GenerateNavigation($currPage);
						
						$this->smarty->assign("content","modifyThesisMain.tpl");
					}
				}
				else
				{
					$this->smarty->assign("error","Parametre úlohy neboli korektne zadané");
      				$this->smarty->display("error.tpl");
					
					$currPage = "Administrácia prác";
					$navig = $this->navigation->GenerateNavigation($currPage);
					
					$this->smarty->assign("content","modifyThesisMain.tpl");
				} 
      		}
			else 
			{
				$currPage = "Administrácia prác";
				$navig = $this->navigation->GenerateNavigation($currPage);
				$this->smarty->assign("content","modifyThesisMain.tpl"); 
			}
	  
			$this->smarty->assign("navigation",$navig);
			$this->smarty->assign("currPage",$currPage);
		  
			return true;
		}
    
		function Draw()
		{
			parent::Draw();
		}
    }
?>