<?php

	class modifyUser extends page{
		private $userList = Array();
		private $groupID = Array();
		private $groupName = Array();
		private $formvars = Array();
		private $error;
		private $id = "";
         
		function __construct( $smarty, $db, $action, $post, $get  )
		{
			parent::__construct( $smarty, $db, $action, $post, $get  );
			if ($this->CheckRights("modifyUser")) $this->logged = true;
			else
			{
			$this->smarty->assign("accessDenied",true);
			$this->logged = false;
			}
			$this->funct = new functions();
			if ($_SESSION["IPaddress"] != $this->funct->GetRealIpAddr())
			{
				$this->logged = false;
			}
			$this->sentOK = false;
			$this->SHOWADMIN = true;
			$this->SHOWDOKTORAND = true;
			$this->SHOWLECTOR = true;
			$this->SHOWOPONENT = true;
			$this->SHOWCHAIRMAN = true;
			$this->SHOWCOMMITTEE = true;
			$this->SHOWMATHEMATICS = true;
			$this->SHOWINFORMATICS = true;
			$this->navigation=new navigation($this->db);
			$this->menu=new menu($this->db);
			$this->menu->GenerateMenu("");
		}
    
		//check validity of retrieved values
		function verify($formvars, $action)
		{
			$this->formvars = $formvars;
			
			if ($action == "addUserToDB")
			{
				if(strlen(trim($this->formvars['NAME'])) == 0) {
					$this->SayError('Nesprávne zadané meno');
					return false; 
				}
				if(strlen(trim($this->formvars['SURNAME'])) == 0) {
					$this->SayError('Nesprávne zadané priezvisko');
					return false; 
				}
				if(count($this->formvars['GROUPS']) < 1)
				{
					$this->SayError('Používateľ nebol zaradený do žiadnej zo skupín');
					return false;
				}
				if(strlen(trim($this->formvars['EMAIL'])) == 0) {
					$this->SayError('Nesprávne zadaný email');
					return false; 
				}
				else
				{
					if ($this->is_valid_email($this->formvars['EMAIL']))
					{
						$mailquery = "SELECT * FROM DM_Users WHERE DM_Users.EMAIL='".$this->formvars['EMAIL']."';";
						$mailresult = $this->db->QueryToArray($mailquery);
						if ( count($mailresult) > 0 ){
							$this->SayError('Zadaný email je už pridelený inému používateľovi');
							return false;
						}
					}
					else
					{
						$this->SayError('Zadaný email nieje platný');
						return false;
					}
				}    
				if(trim($this->formvars['MAKELOGIN']) === "true") {
					if(strlen(trim($this->formvars['LOGIN'])) < 6 ) {
						$this->SayError('Nesprávne zadaný login, minimálne 6 znakov');
						return false;
					}
					$query = "SELECT DM_Users.LOGIN FROM DM_Users WHERE DM_Users.LOGIN='".$this->formvars['LOGIN']."';";
					$result = $this->db->QueryToArray($query);
					if ( count($result) > 0 ){
						$this->SayError('Zadaný login je už pridelený inému používateľovi');
						return false;
					} 
					if(strlen(trim($this->formvars['PASSWORD'])) < 6){
						$this->SayError('Nesprávne zadané heslo, minimálne 6 znakov');
						return false;               
					}
					if(trim($this->formvars['PASSWORD']) != trim($this->formvars['PASSCHECK'])){
						$this->SayError('Zadané heslá sa nezhodujú');
						return false;
					}    
				}
			}
			
			if ($action == "update")
			{
				if(strlen(trim($this->formvars['EMAIL'])) == 0) {
					$this->SayError('Nebol zadaný email');
					return false;
				}
				else 
				{
					if ($this->is_valid_email($this->formvars['EMAIL']))
					{
						$mailquery = "SELECT * FROM DM_Users WHERE (DM_Users.EMAIL='".$this->formvars['EMAIL']."') AND (DM_Users.ID!=".$this->getParams["ID"].");";
						$mailresult = $this->db->QueryToArray($mailquery);
						if ( count($mailresult) > 0 ){
							$this->SayError('Zadaný email je už pridelený inému používateľovi');
							return false;
						}
					}
					else
					{
						$this->SayError('Zadaný email nieje platný');
						return false;
					}
				}
				if(trim($this->formvars['GROUPCHECK']) === "true") {
					if(count($this->formvars['GROUPS']) < 1 ) {
						$this->SayError('Používateľ nebol zaradený do žiadnej zo skupín');
						return false; 
					}
				}
				if(trim($this->formvars['LOGINCHECK']) === "true") {
					if(strlen(trim($this->formvars['LOGIN'])) < 6 ) {
						$this->SayError('Nesprávne zadaný login, minimálne 6 znakov');
						return false;
					}
					$logquery = "SELECT * FROM DM_Users WHERE DM_Users.LOGIN='".$this->formvars['LOGIN']."'";
					$logresult = $this->db->QueryToArray($logquery);
					if ( count($logresult) > 0 ){
						$this->SayError('Zadaný login je už pridelený niektorému z používateľov');
						return false;
					}
				}    
				if(trim($this->formvars['PASSCHECK']) === "true") { 
					if(strlen(trim($this->formvars['PASSWORD'])) < 6){
						$this->SayError('Nesprávne zadané heslo, minimálne 6 znakov');
						return false;               
					}    
				}
			}
			return true;
		}
		
		function is_valid_email($email) {
			$result = TRUE;
			if(!eregi("^[_a-z0-9-]+(\.[_a-z0-9-]+)*@[a-z0-9-]+(\.[a-z0-9-]+)*(\.[a-z]{2,4})$", $email))
			{
				$result = FALSE;
			}
			return $result;
		}
            
		function Process()
		{
			//list user details
			if ( $this->action === "details" )
			{   
				if ((is_numeric($this->getParams["id"]))  || ($this->id != ""))
				{
					$query = "SELECT * FROM DM_Users AS Users WHERE (Users.ID='".$this->getParams["id"]."') OR (Users.ID='".$this->id."');";
					$result = $this->db->QueryToRow($query);
					if ( $result != 0 )
					{
						$usersDetails["ID"] = $result["ID"];
						$usersDetails["Login"] = $result["LOGIN"];
						$usersDetails["Name"] = $result["NAME"];
						$usersDetails["SurName"] = $result["SURNAME"];  
						$usersDetails["Email"] = $result["EMAIL"];
						$usersDetails["Location"] = $result["LOCATION"];
						$usersDetails["Groups"] = explode('|',$result["GROUPS"]);
						$usersDetails["SectionID"] = $result["SECTION_ID"];  
						
						foreach ($usersDetails["Groups"] as $key => $value) { 
							if (is_null($value) || $value=="")
							{ 
								unset($usersDetails["Groups"][$key]); 
							} 
						}
						
						$pos = 0;
						foreach ($usersDetails["Groups"] as $key => $value)
						{
							$query2 = "SELECT DM_Groups.ID, DM_Groups.GROUP_NAME FROM DM_Groups WHERE ".
							"DM_Groups.ID='".$usersDetails["Groups"][$key]."';";   
							$result2 = $this->db->QueryToRow($query2); 
							if ($result2 != 0)
							{
								$usersDetails["GROUP"][$pos]["ID"] = $result2["ID"];
								$usersDetails["GROUP"][$pos]["NAME"] = $result2["GROUP_NAME"];
								unset($result2);
								$pos += 1;
							}                       
						}
						
						$groupquery = "SELECT DM_Groups.ID, DM_Groups.GROUP_NAME FROM DM_Groups;";   
						$groupresult = $this->db->QueryToArray($groupquery); 
						if ($groupresult != 0)
						{
							for ( $i = 0; $i < count($groupresult); $i++ )
							{
								$groupID[$i] = $groupresult[$i]["ID"];
								$groupName[$i] = $groupresult[$i]["GROUP_NAME"];
							}
						}
						unset($groupresult);
					
						$sectionquery = "SELECT Sections.SECTION_NAME FROM DM_Sections AS Sections ".
										"WHERE Sections.ID=".$usersDetails["SectionID"].";";
						$result3 = $this->db->QueryToRow($sectionquery);  
						if ( $result3 != 0 )
						{	 
							 $usersDetails["Section"] = $result3["SECTION_NAME"];                           
						}
						unset($result3);
						
						$currPage = "Úprava detailov užívateľa";
						$navig = $this->navigation->GenerateNavigation($currPage);
		
						$this->smarty->assign("groupID",$groupID);
						$this->smarty->assign("groupName",$groupName);
						$this->smarty->assign("usersDetails",$usersDetails);
								
						$this->smarty->assign("content","userDetails.tpl");
					
					}
					else
					{     
						$this->smarty->assign("error","Údaje o príslušnom užívateľovi sa nepodarilo získať.");
      					$this->smarty->display("error.tpl");
						
						$currPage = "Správa užívateľov";
						$navig = $this->navigation->GenerateNavigation($currPage);
						
						$this->smarty->assign("content","modifyUserMain.tpl");  
					}
				}
				else
				{
					$this->smarty->assign("error","Parametre užívateľa neboli korektne zadané");
      				$this->smarty->display("error.tpl");
					
					$currPage = "Správa užívateľov";
					$navig = $this->navigation->GenerateNavigation($currPage);
					
					$this->smarty->assign("content","modifyUserMain.tpl");
				}
			}
      
			//get groups and section before showing addUser form
			elseif ( $this->action === "addUser" )
			{         
				$groupquery = "SELECT Groups.ID, Groups.GROUP_NAME FROM DM_Groups AS Groups ORDER BY Groups.ID ASC;";
				$result = $this->db->QueryToArray($groupquery);  
				if ( $result != 0 )
				{
					for ( $i = 0; $i < count($result); $i++ )
					{
						 $groupID[$i] = $result[$i]["ID"];
						 $groupName[$i] = $result[$i]["GROUP_NAME"];                       
					}     
				}
				unset($result);
				
				$sectionquery = "SELECT Sections.ID, Sections.SECTION_NAME FROM DM_Sections AS Sections ORDER BY Sections.ID ASC;";
				$result = $this->db->QueryToArray($sectionquery);  
				if ( $result != 0 )
				{
					for ( $i = 0; $i < count($result); $i++ )
					{
						 $sectionID[$i] = $result[$i]["ID"];
						 $sectionName[$i] = $result[$i]["SECTION_NAME"];                       
					}     
				}
				unset($result);
		
				$currPage = "Pridanie používateľa";
				$navig = $this->navigation->GenerateNavigation($currPage);
				
				$this->smarty->assign("groupID",$groupID);
				$this->smarty->assign("groupName",$groupName);
				$this->smarty->assign("sectionID",$sectionID);
				$this->smarty->assign("sectionName",$sectionName);
				        
				$this->smarty->assign("content","addUser.tpl");
			}
      
			// list users
			else if ( $this->action === "listUsers" )
			{	
				if ($this->getParams["select"] == "yes")
				{
					$this->SHOWADMIN = $this->postParams["SHOWADMIN"];
					$this->SHOWDOKTORAND = $this->postParams["SHOWDOKTORAND"];
					$this->SHOWLECTOR = $this->postParams["SHOWLECTOR"];
					$this->SHOWOPONENT = $this->postParams["SHOWOPONENT"];
					$this->SHOWCHAIRMAN = $this->postParams["SHOWCHAIRMAN"];
					$this->SHOWCOMMITTEE = $this->postParams["SHOWCOMMITTEE"];
					$this->SHOWMATHEMATICS = $this->postParams["SHOWMATHEMATICS"];
					$this->SHOWINFORMATICS = $this->postParams["SHOWINFORMATICS"];
				}
				
				$cond1 = "WHERE ( ";
				if ($this->SHOWADMIN) $cond1 .= "(Users.GROUPS LIKE '%|0|%') OR ";
				if ($this->SHOWDOKTORAND) $cond1 .= "(Users.GROUPS LIKE '%|1|%') OR ";
				if ($this->SHOWLECTOR) $cond1 .= "(Users.GROUPS LIKE '%|5|%') OR ";
				if ($this->SHOWOPONENT) $cond1 .= "(Users.GROUPS LIKE '%|2|%') OR ";
				if ($this->SHOWCHAIRMAN) $cond1 .= "(Users.GROUPS LIKE '%|3|%') OR ";
				if ($this->SHOWCOMMITTEE) $cond1 .= "(Users.GROUPS LIKE '%|4|%') OR ";
				$cond1 .= "1=0 )";
				
				$cond2 = " AND ( ";
				if ($this->SHOWMATHEMATICS) $cond2 .= "Users.SECTION_ID=1 OR ";
				if ($this->SHOWINFORMATICS) $cond2 .= "Users.SECTION_ID=2 OR ";
				$cond2 .= "1=0 )";
					  
				if (substr($this->getParams["order"],-4) === "DESC")
				{
						$keyword = substr($this->getParams['order'], 0, -4);
						$orders = array("SURNAME", "NAME", "LOGIN", "GROUPS", "SECTION_ID");
						if (isset($keyword) && in_array($keyword, $orders))
						{
							$query = "SELECT * FROM DM_Users AS Users ".$cond1.$cond2." ORDER BY Users.".$keyword." DESC;";
							$this->smarty->assign("order","");
						}
				}
				else
				{
					$keyword = $this->getParams['order'];
					$orders = array("SURNAME", "NAME", "LOGIN", "GROUPS", "SECTION_ID");
					if (isset($keyword) && in_array($keyword, $orders))
					{
						$query = "SELECT * FROM DM_Users AS Users ".$cond1.$cond2." ORDER BY Users.".$keyword." ASC;";
						$this->smarty->assign("order",$keyword);
					}
					else
					{
						$query = "SELECT * FROM DM_Users;";
					}
				}		 
				$result = $this->db->QueryToArray($query);
				if ( $result != 0 )
				{
					for ( $i = 0; $i < count($result); $i++ )
					{
						$userList[$i]["ID"] = $result[$i]["ID"];
						$userList[$i]["Surname"] = $result[$i]["SURNAME"];
						$userList[$i]["Name"] = $result[$i]["NAME"];
						$userList[$i]["Login"] = $result[$i]["LOGIN"]; 
						$userList[$i]["Groups"] = explode('|',$result[$i]["GROUPS"]); 
						$userList[$i]["SectionID"] = $result[$i]["SECTION_ID"];  
						
						foreach ($userList[$i]["Groups"] as $key => $value)
						{ 
							if (is_null($value) || $value=="")
							{ 
								unset($userList[$i]["Groups"][$key]); 
							} 
						}
						
						if (count($userList[$i]["Groups"]) == 1)
						{
						$groupquery = "SELECT Groups.GROUP_NAME FROM DM_Groups AS Groups WHERE Groups.ID=".$userList[$i]["Groups"][1].";";
						$groups = $this->db->QueryToRow($groupquery);
						if ( $groups != 0 )
						{		
							$userList[$i]["Group"] = $groups["GROUP_NAME"];
						}
						unset($groups);
						}
						else
						{
							$userList[$i]["Group"] = "*viacnásobná*";
						} 
 
						$sectionquery = "SELECT * FROM DM_Sections AS Sections WHERE Sections.ID=".$userList[$i]["SectionID"].";";
						$sections = $this->db->QueryToRow($sectionquery);
						if ( $sections != 0 )
						{
							   $userList[$i]["Section"] = $sections["SECTION_NAME"];            
						}
						unset($sections);
					}   
				}
				unset($result);
				
				if ($this->getParams["select"] == "yes")
				{
					$this->smarty->assign("SHOWADMIN",$this->postParams["SHOWADMIN"]);
					$this->smarty->assign("SHOWDOKTORAND",$this->postParams["SHOWDOKTORAND"]);
					$this->smarty->assign("SHOWLECTOR",$this->postParams["SHOWLECTOR"]);
					$this->smarty->assign("SHOWOPONENT",$this->postParams["SHOWOPONENT"]);
					$this->smarty->assign("SHOWCHAIRMAN",$this->postParams["SHOWCHAIRMAN"]);
					$this->smarty->assign("SHOWCOMMITTEE",$this->postParams["SHOWCOMMITTEE"]);
					$this->smarty->assign("SHOWMATHEMATICS",$this->postParams["SHOWMATHEMATICS"]);
					$this->smarty->assign("SHOWINFORMATICS",$this->postParams["SHOWINFORMATICS"]);
					
					$this->SHOWADMIN = $this->postParams["SHOWADMIN"];
					$this->SHOWDOKTORAND = $this->postParams["SHOWDOKTORAND"];
					$this->SHOWLECTOR = $this->postParams["SHOWLECTOR"];
					$this->SHOWOPONENT = $this->postParams["SHOWOPONENT"];
					$this->SHOWCHAIRMAN = $this->postParams["SHOWCHAIRMAN"];
					$this->SHOWCOMMITTEE = $this->postParams["SHOWCOMMITTEE"];
					$this->SHOWMATHEMATICS = $this->postParams["SHOWMATHEMATICS"];
					$this->SHOWINFORMATICS = $this->postParams["SHOWINFORMATICS"]; 	 
				}
				else
				{
					$this->smarty->assign("SHOWADMIN",true);
					$this->smarty->assign("SHOWDOKTORAND",true);
					$this->smarty->assign("SHOWLECTOR",true);
					$this->smarty->assign("SHOWOPONENT",true);
					$this->smarty->assign("SHOWCHAIRMAN",true);
					$this->smarty->assign("SHOWCOMMITTEE",true);
					$this->smarty->assign("SHOWMATHEMATICS",true);
					$this->smarty->assign("SHOWINFORMATICS",true);
					
					$this->SHOWADMIN = true;
					$this->SHOWDOKTORAND = true;
					$this->SHOWLECTOR = true;
					$this->SHOWOPONENT = true;
					$this->SHOWCHAIRMAN = true;
					$this->SHOWCOMMITTEE = true;
					$this->SHOWMATHEMATICS = true;
					$this->SHOWINFORMATICS = true;
				}
				
				
				$currPage = "Zoznam užívateľov";
				$navig = $this->navigation->GenerateNavigation($currPage);
				
				$this->smarty->assign("userList",$userList);
				
				$this->smarty->assign("content","listUsers.tpl"); 
			}
	  
      
			//delete user
			else if ( $this->action === "delete" )
			{
				$message = "";
				$deletedID = $this->getParams["id"];
				
				if (is_numeric($deletedID))
				{
					//check whether user may be deleted
					$query = "SELECT Users.GROUPS FROM DM_Users AS Users WHERE Users.ID=".$deletedID.";"; 	 
					$result = $this->db->QueryToRow($query);
					if ($result != 0)
					{
						$groups = explode('|',$result["GROUPS"]);
						
						if (in_array('0', $groups))
						{
							if ($deletedID == $_SESSION["userID"])
							{
								$message = "Nie je povolené zmazať seba samého.<br />";
							}
						}
						if (in_array('1', $groups))
						{
							$query2 = "SELECT Thesis.ID FROM DM_Thesis AS Thesis WHERE Thesis.DOKTORAND_ID=".$deletedID.";"; 	 
							$result2 = $this->db->QueryToArray($query2);
							if (count($result2) != 0)
							{
								$message = "Nie je povolené zmazať doktoranda so zadanou prácou.";
							}
						}
						if (in_array('2', $groups))
						{
							$query3 = "SELECT Thesis.OPPONENTS FROM DM_Thesis AS Thesis;"; 	 
							$result3 = $this->db->QueryToArray($query3);
							if ( $result3 != 0 )
							{
								for ( $i = 0; $i < count($result3); $i++ )
								{
									$opp = explode('|',$result3[$i]["OPPONENTS"]);
									if (in_array($deletedID, $opp))
									{
										$message = "Nie je povolené zmazať oponenta prideleného k niektorej práci.<br />";
									}
								}
							}
						}
						if (in_array('3', $groups))
						{
							$query4 = "SELECT Committee.ID FROM DM_Committee AS Committee WHERE Committee.CHAIRMAN=".$deletedID.";"; 	 
							$result4 = $this->db->QueryToArray($query4);
							if (count($result4) != 0)
							{
								$message = "Nie je povolené zmazať predsedu komisie, ktorý je priradený niektorej z komisií.<br />";
							}
						}
						if (in_array('4', $groups))
						{
							$query5 = "SELECT Committee.MEMBERS FROM DM_Committee AS Committee;"; 	 
							$result5 = $this->db->QueryToArray($query5);
							if ( $result5 != 0 )
							{
								for ( $i = 0; $i < count($result5); $i++ )
								{
									$mem = explode('|',$result5[$i]["MEMBERS"]);
									if (in_array($deletedID, $mem))
									{
										$message = "Nie je povolené zmazať člena komisie, ktorý je pridelený k niektorej z komisií.<br />";
									}
								}
							}
						}
						if (in_array('5', $groups))
						{
							$query6 = "SELECT Thesis.ID FROM DM_Thesis AS Thesis WHERE Thesis.LECTOR_ID=".$deletedID.";"; 	 
							$result6 = $this->db->QueryToArray($query6);
							if (count($result6) != 0)
							{
								$message = "Nie je povolené zmazať školiteľa, ktorý má na starosti niektorého doktoranda.<br />";
							}
						}
						
						if ($message == "")
						{
							$query = "DELETE FROM DM_Users WHERE DM_Users.ID=".$this->getParams["id"]." LIMIT 1;"; 	 
							$result = $this->db->Query($query);
							
							$this->SayReport("Užívateľ bol úspešne odstránený zo systému");
						}
						else
						{
							$this->SayError($message);
						}
					}
					else
					{
						$this->smarty->assign("error","Užívateľ zadaný na zmazanie neexistuje");
						$this->smarty->display("error.tpl");
					}
				}
				else
				{
					$this->smarty->assign("error","Parametre užívateľa na vymazanie neboli korektne zadané");
      				$this->smarty->display("error.tpl");
				}
				
				$currPage = "Zoznam užívateľov";
				$navig = $this->navigation->GenerateNavigation($currPage);
				  
				$this->smarty->assign("content","listUsers.tpl");
				$this->action = "listUsers";     
				$this->Process(); 
			}
      
			//update user details
			else if ( $this->action === "update" )
			{ 
				$updatedID = $this->getParams["ID"];
				
				if (is_numeric($updatedID))
				{
					$checkquery = "SELECT * FROM DM_Users WHERE DM_Users.ID='".$updatedID."';"; 	 
					$checkresult = $this->db->QueryToRow($checkquery);
					if ($checkresult != 0)
					{	
						if ($this->verify($_POST, $this->action))
						{				
							$query = "UPDATE DM_Users ".					   
							"SET DM_Users.EMAIL = '".$this->postParams["EMAIL"]."'"; 
							if ($this->postParams["LOCATION"] != "")
							{
								$query .= ", DM_Users.LOCATION = '".$this->postParams["LOCATION"]."'";
							}
							if ($this->postParams["LOGINCHECK"] === "true")
							{
								$query .= ", DM_Users.LOGIN = '".$this->postParams["LOGIN"]."'"; 
							}
							if ($this->postParams["GROUPCHECK"] === "true")
							{
								$groups = "|".implode('|', $this->postParams["GROUPS"])."|";
								$query .= ", DM_Users.GROUPS = '".$groups."'";
								
								if ($this->getParams["ID"] == $_SESSION["userID"])
								{
									$_SESSION["userGroup"] = $this->postParams["GROUPS"];
									$_SESSION["admin"] = in_array('0', $_SESSION["userGroup"]);
									$_SESSION["chairman"] = in_array('3', $_SESSION["userGroup"]);
									
									$this->menu=new menu($this->db);
									$this->menu->GenerateMenu("");
								} 
							}
							if ($this->postParams["PASSCHECK"] === "true")
							{
								$query .= ", DM_Users.PASSWORD = MD5('".$this->postParams["PASSWORD"]."') "; 
							}   
							$query .= "WHERE DM_Users.ID='".$this->getParams["ID"]."';"; 		 
							$result = $this->db->Query($query);
							if ($result != 0)
							{
								$this->SayReport("Užívateľove údaje boli zmenené");
							}
							else
							{
								$this->SayError($this->error);
							}
							unset($result);
							
							$currPage = "Správa užívateľov";
							$navig = $this->navigation->GenerateNavigation($currPage);
					  
							$this->smarty->assign("content","modifyUserMain.tpl");
						}
						else
						{
							$this->id = $updatedID;
							$this->action = "details";
							$this->Process();
						}
					}
					else
					{
						$this->smarty->assign("error","Novinka v ktorej sa vyžaduje zmena údajov neexistuje");
						$this->smarty->display("error.tpl");
						
						$currPage = "Správa noviniek";
						$navig = $this->navigation->GenerateNavigation($currPage);
					
						$this->smarty->assign("content","modifyNewsMain.tpl");
					}
				}
				else
				{
					$this->smarty->assign("error","Parametre užívateľa odoslaného na zmenu neboli korektne zadané");
					$this->smarty->display("error.tpl");
					
					$currPage = "Správa užívateľov";
					$navig = $this->navigation->GenerateNavigation($currPage);
	
					$this->smarty->assign("content","modifyUserMain.tpl");
				 }
 
			}
		
			//add user to DB and send notification email
			else if ( $this->action === "addUserToDB" )
			{
				if ($this->verify($_POST, $this->action))
				{
					$dbQuery["NAME"] = $this->postParams["NAME"];
					$dbQuery["SURNAME"] = $this->postParams["SURNAME"];
					$dbQuery["GROUPS"] = "|".implode('|', $this->postParams["GROUPS"])."|";
					$dbQuery["EMAIL"] = $this->postParams["EMAIL"];   
					if ($this->postParams["LOCATION"] != "") $dbQuery["LOCATION"] = $this->postParams["LOCATION"];
					$dbQuery["SECTION_ID"] = $this->postParams["SECTION_ID"];      
			  
					if ($this->postParams["MAKELOGIN"] === "true")
					{  
							$dbQuery["LOGIN"] = $this->postParams["LOGIN"];
							$query = "INSERT INTO DM_Users (".implode(",", array_keys($dbQuery)).",PASSWORD) VALUES ('".implode("','", array_values($dbQuery))."',MD5('".$this->postParams["PASSWORD"]."'))";
						
						if ($this->postParams["SENDMAIL"] === "true")
						{
							$sendmail = new sendEmail($this->smarty, $this->db, $this->action, $_POST, $_GET); 
							$mailparams = Array();
							switch ($dbQuery["GROUPS"][1]) {
							case 0:
								$mailparams["%GROUP%"] = "administrátor";
								break;
							case 1:
								$mailparams["%GROUP%"] = "doktorand";
								break;
							case 2:
								$mailparams["%GROUP%"] = "oponent dizertačnej práce";
								break;
							case 3:
								$mailparams["%GROUP%"] = "predseda komisie";
								break;
							case 4:
								$mailparams["%GROUP%"] = "člen komisie";
								break;
							case 5:
								$mailparams["%GROUP%"] = "školiteľ";
								break;
							}
							$mailparams["%NAME%"] = $dbQuery["NAME"]." ".$dbQuery["SURNAME"];
							$mailparams["%LOGIN%"] = $dbQuery["LOGIN"];
							$mailparams["%PASSWORD%"] = $this->postParams["PASSWORD"];
							$mailparams["%ADDRESS%"] = $_SESSION["address"];
							$this->sentOK = $sendmail->simpleSend($dbQuery["EMAIL"],"", "1", $mailparams,"");	
					
							if ($this->sentOK)
							{
								$this->SayReport("Mailová notifikácia bola odoslaná v poriadku.");
							}
							else
							{
								$this->SayError("Mailová notifikácia nebola úspešne odoslaná.");
							}
							
						}
					}
					else
					{
					$query = "INSERT INTO DM_Users (".implode(",", array_keys($dbQuery)).") VALUES ('".implode("','", array_values($dbQuery))."')";
					}	 
					$result = $this->db->Query($query);
					if ($result != 0)
					{
						$this->SayReport("Užívateľove údaje boli zaznamenané.");
					}
					else
					{
						$this->SayError($this->error);
					}
					unset($result);
											
					$currPage = "Správa užívateľov";
					$navig = $this->navigation->GenerateNavigation($currPage);
					  
					$this->smarty->assign("content","modifyUserMain.tpl");
					 
				}
				else
				{
					$currPage = "Pridanie používateľa";
					$navig = $this->navigation->GenerateNavigation($currPage);
				
					$this->smarty->assign("post",$this->formvars);
					 
					$this->smarty->assign("content","addUser.tpl");   
					$this->action = "addUser";     
					$this->Process();
				}   
			}
			else
			{
				$currPage = "Správa užívateľov";
				$navig = $this->navigation->GenerateNavigation($currPage);
				$this->smarty->assign("content","modifyUserMain.tpl");
			}
			
			$this->smarty->assign("navigation",$navig);
			$this->smarty->assign("currPage",$currPage);
			 
			return true;
		}
    
		function Draw()
		{
		  parent::Draw();
		}
    }
?>