﻿<?php

	class sendEmail extends page{
		var $to         = "";
		var $cc         = "";  
		var $subject    = "";
		var $body    	= "";
		var $fromName   = "Admin";
		var $fromEmail  = "docmonitor@cvika.dcs.fmph.uniba.sk";
		var $replyEmail = "docmonitor@cvika.dcs.fmph.uniba.sk";
		var $header     = "";
		var $type       = "text/plain";
		var $characterSet = "UTF-8";
		var $attachment = "";
		var $eventType;
    
		function __construct( $smarty, $db, $action, $post, $get  )
		{
			parent::__construct( $smarty, $db, $action, $post, $get  );
			if ($this->CheckRights("sendEmail")) $this->logged = true;
			else
			{
				$this->smarty->assign("accessDenied",true);
				$this->logged = false;
			}
			$this->funct = new functions();
			if ($_SESSION["IPaddress"] != $this->funct->GetRealIpAddr())
			{
				$this->logged = false;
			}
			$this->navigation=new navigation($this->db);
			$this->menu=new menu($this->db);
			$this->menu->GenerateMenu("");
		}
    
		function send()
		{
			$this->createHeader();
			if (mail($this->to,$this->subject,$this->body,$this->header)) return true;
			else return false;
		}
    	
		
		function simpleSend($to,$cc,$template, $mailparams, $attachment)
		{
			$this->to = $to;
			$this->cc = $cc;
			$this->attachment = $attachment;
			
			$query = "SELECT * FROM DM_Email_Templates AS email WHERE email.ID='".$template."';";
			$result = $this->db->QueryToRow($query);   
			if ( $result != 0 )
			{
				$this->subject = $result["SUBJECT"];
				$this->body = $result["BODY"];
				$this->body = $this->replaceBodyVariables($this->body, $mailparams);
				//echo $this->body;
				if ($this->send()) return true;
				else return false;       
			}
			else
			{
				$this->site->SayError("Zadaná mailová predloha neexistuje."); 
			}      
		}
    
		function createHeader()
		{
			$from   = "From: $this->fromName <$this->fromEmail>\r\n";
			$replay = "Reply-To: $this->replyEmail\r\n";    
			$params = "MIME-Version: 1.0\r\n";
			$params .= "Content-type: $this->type; charset=$this->characterSet\r\n";
			
			if ($this->attachment != "")
			{
				$params.="Content-Type: application/pdf; name='".$this->attachment["attName"]."'\r\nContent-Transfer-Encoding: base64\r\nContent-Disposition: attachment\r\n".
				"<?php echo $this->attachment; ?>"; 
			}
			
			
			$this->header = $from.$replay.$params;
			return $this->header;
		}
    
		function replaceBodyVariables($body,$values)
		{
			$this->body = $body;  
			foreach ($values as $key => $value)
			{
				$this->body = str_replace($key, $value, $this->body);
			}
			return $this->body;
		}
		
		// check if the date has correct format
		function checkDate($day, $month, $year)
		{
			if (is_numeric($day) && is_numeric($month) && is_numeric($year))
			{
				return (checkdate($month, $day, $year));
    		}
			else
			{
				return false;
			}
		}
		
		// check whether date is in the future
		function checkFuture($day, $month, $year)
		{	
			$date1 = $year."-".$month."-".$day;
			$date2 = date('Y-m-d');
			
			$suggestDate = strtotime($date1);
			$nowDate = strtotime($date2);
			
			if ($suggestDate > $nowDate)
			{
				 return true;
			}
			else
			{
				 return false;
			}
    		
		}
		
		// check if term is at least after 6 weeks
		function checkFutureTerm($day, $month, $year)
		{ 
			$date1 = $year."-".$month."-".$day;
			$day = mktime(0,0,0,date('m'),date('d')+(7*6),date('Y'));
			$date2 = date('Y-m-d',$day);
			
			$suggestDate = strtotime($date1);
			$compareDate = strtotime($date2);
			
			if ($suggestDate > $compareDate)
			{
				 return true;
			}
			else
			{
				 return false;
			}
		}
		
		// time format is correct
		function checkTime($hour, $minute)
		{
			if (is_numeric($hour)&&is_numeric($minute))
			{
				return (($hour < 24)&&($hour >= 0)) && (($minute < 60)&&($minute >= 0));
    		}
			else
			{
				return false;
			}
		}
		
		// place is set
		function checkPlace($place)
		{
			return (isset($place) && ($place != ""));
		}

		// date is before term
		function checkStepByStep($day, $month, $year, $termday, $termmonth, $termyear )
		{	
			$date1 = $year."-".$month."-".$day;
			$date2 = $termyear."-".$termmonth."-".$termday;
			
			$deadlineDate = strtotime($date1);
			$termDate = strtotime($date2);
			
			if ($termDate > $deadlineDate)
			{
				 return true;
			}
			else
			{
				 return false;
			}
		}
		
		
		function Process()
		{
			// display email for editing and send confirmation
			if ( $this->action === "sendRequest" )
			{	  
				$_SESSION["eventID"] = $this->getParams['event'];
				if ($_SESSION["eventID"] != "" && is_numeric($_SESSION["eventID"])) 
				{
					$query = "SELECT * FROM DM_Events WHERE DM_Events.ID=".$_SESSION["eventID"];
					$result = $this->db->QueryToRow($query);
					if ($result != 0)
					{
						$eventDetails["TYPE"] = $result["EVENT_TYPE"];
						$eventDetails["MAIL_TO"] = $result["MAIL_TO"];
						$eventDetails["MAIL_CC"] = $result["MAIL_CC"];
						$eventDetails["MAIL_SUBJECT"] = $result["MAIL_SUBJECT"];
						$eventDetails["MAIL_BODY"] = $result["MAIL_BODY"];

					}
					
					$eventDetails["CHAIRMAN_NAME"] = $_SESSION["userName"];
					
					$message = "";
					
					$day = $this->postParams["day"];
					$month = $this->postParams["month"];
					$year = $this->postParams["year"];
					
					$timeCond = true;
					$placeCond = true;
					$termCond = true;
					$futureTermCond = true;
					$stepCond = true;
					
					// if we are sending term and place
					if ($eventDetails["TYPE"] == 3)
					{
						$termday = $this->postParams["termday"];
						$termmonth = $this->postParams["termmonth"];
						$termyear = $this->postParams["termyear"];
						$termhour = $this->postParams["termhour"];
						$termminute = $this->postParams["termminute"];
						$place = $this->postParams["place"];
						
						$termCond = $this->checkDate($termday, $termmonth, $termyear);
						$timeCond = $this->checkTime($termhour, $termminute);
						$placeCond = $this->checkPlace($place);
						
						$futureTermCond = $this->checkFutureTerm($termday, $termmonth, $termyear);
						$stepCond = $this->checkStepByStep($day, $month, $year, $termday, $termmonth, $termyear);
					}
					
					if (!$this->checkDate($day, $month, $year))
					{
						$message .= "Zadaná lehota nezodpovedá platnému dátumu.<br />";
					}
					
					if (!$termCond)
					{
						$message .= "Dátum termínu obhajoby nie je platný.<br />";
					}
					
					if (!$timeCond) 
					{
						$message .= "Zadaný čas obhajoby nie je platný.<br />";
					}
					
					if (!$this->checkFuture($day, $month, $year))
					{
						$message .= "Zadaná lehota musí byť dátum v budúcnosti.<br />";
					}
					
					if (!$futureTermCond)
					{
						$message .= "Termín obhajoby musí byť aspoň 6 týždňov odo dňa zadania.<br />";
					}
					
					if (!$stepCond) 
					{
						$message .= "Lehota na schválenie musí byť pred dátumom obhajoby.<br />";
					}
					
					if ($message == "")
					{
						$eventDetails["DATE"] = $day.".".$month.".".$year;
						$eventDetails["MAIL_BODY"] = str_replace("%DATE%", $eventDetails["DATE"], $eventDetails["MAIL_BODY"]);
						
						$_SESSION["DEADLINE"] = $year."-".$month."-".$day;
						
						if ($eventDetails["TYPE"] == 3)
						{
							$eventDetails["TERM"] = $termday.".".$termmonth.".".$termyear;
							$eventDetails["TIME"] = $termhour.":".$termminute;
							$eventDetails["MAIL_BODY"] = str_replace("%TERM%", $eventDetails["TERM"], $eventDetails["MAIL_BODY"]);
							$eventDetails["MAIL_BODY"] = str_replace("%TIME%", $eventDetails["TIME"], $eventDetails["MAIL_BODY"]);
							$eventDetails["MAIL_BODY"] = str_replace("%PLACE%", $place, $eventDetails["MAIL_BODY"]);
							
							$_SESSION["TERMINFO"] = $eventDetails["TERM"]." ".$eventDetails["TIME"].", ".$place;
						}

						$this->smarty->assign("eventDetails", $eventDetails);
						
						$this->smarty->assign("event", "yes");
					}
					else
					{
						$this->SayError($message);
					}						
				}
				else
				{
					$this->smarty->assign("event", "no");
				}
				
				$_SESSION["REQUEST"] = true;
				$this->smarty->assign("tplAction", "edit");   
			}
			
			//urge about request that is over time
			else if ( $this->action === "urge" )
			{
				$_SESSION["eventID"] = $this->getParams['event'];
				if ($_SESSION["eventID"] != "" && is_numeric($_SESSION["eventID"])) 
				{
					$query = "SELECT * FROM DM_Events WHERE DM_Events.ID=".$_SESSION["eventID"];
					$result = $this->db->QueryToRow($query);
					if ($result != 0)
					{
						$eventDetails["TYPE"] = $result["EVENT_TYPE"];
						$eventDetails["MAIL_SUBJECT"] = $result["MAIL_SUBJECT"];
						$eventDetails["MAIL_BODY"] = $result["MAIL_BODY"];
						
						$thesisID = $result["THESIS_ID"];
						$confirmed = explode('|',$result["CONFIRMED"]);
						
						foreach ($confirmed as $key => $value)
						{ 
							if (is_null($value) || $value=="")
							{ 
								unset($confirmed[$key]); 
							} 
						}
					}
					
					$query = "SELECT * FROM DM_Users WHERE DM_Users.ID=".$_SESSION["userID"];
					$result = $this->db->QueryToRow($query);
					if ($result != 0)
					{
						$eventDetails["CHAIRMAN_NAME"] = $result["NAME"]." ".$result["SURNAME"];
						$eventDetails["MAIL_CC"] = $result["EMAIL"];
					}
					 
					// if the mail is send to committee members
					if (($eventDetails["TYPE"] == 1) || ($eventDetails["TYPE"] == 3))
					{
						$thesisquery = "SELECT * FROM DM_Thesis WHERE DM_Thesis.ID=".$thesisID.";";
						$thesisresult = $this->db->QueryToRow($thesisquery);
						$committeeID = $thesisresult["COMMITTEE_ID"];
						
						$thesisquery = "SELECT * FROM DM_Committee WHERE DM_Committee.ID=".$committeeID.";";
						$thesisresult = $this->db->QueryToRow($thesisquery);
						$members = explode('|',$thesisresult["MEMBERS"]);
						
						foreach ($members as $key => $value)
						{ 
							if (is_null($value) || $value=="")
							{ 
								unset($members[$key]); 
							} 
						}
						
						$notify = array_diff($members, $confirmed);
						
						$pos = 0;
						foreach ($notify as $key => $value)
						{ 
							$mailquery = "SELECT * FROM DM_Users WHERE DM_Users.ID=".$notify[$key].";";
							$mailresult = $this->db->QueryToRow($mailquery);
	
							$notifyMembers[$pos] = $mailresult["EMAIL"];
							$pos += 1; 
						}
 
						$eventDetails["MAIL_TO"] = implode(', ', $notifyMembers);
						
						$eventDetails["MAIL_BODY"] = str_replace('%MAIL%', $eventDetails["MAIL_CC"], $eventDetails["MAIL_BODY"]); 
					}
					
					// if the mail is send to opponents
					if ($eventDetails["TYPE"] == 2)
					{
						$thesisquery = "SELECT * FROM DM_Thesis WHERE DM_Thesis.ID=".$thesisID.";";
						$thesisresult = $this->db->QueryToRow($thesisquery);
						$opponents = explode('|',$thesisresult["OPPONENTS"]);
						
						foreach ($opponents as $key => $value)
						{ 
							if (is_null($value) || $value=="")
							{ 
								unset($opponents[$key]); 
							} 
						}
						
						$notify = array_diff($opponents, $confirmed);
						
						$pos = 0;
						foreach ($notify as $key => $value)
						{ 
							$mailquery = "SELECT * FROM DM_Users WHERE DM_Users.ID=".$notify[$key].";";
							$mailresult = $this->db->QueryToRow($mailquery);
	
							$notifyOpponents[$pos] = $mailresult["EMAIL"];
							$pos += 1; 
						}
 
						$eventDetails["MAIL_TO"] = implode(', ', $notifyOpponents);
					}
							
				$this->smarty->assign("eventDetails", $eventDetails);
				$this->smarty->assign("event", "yes");
				
				$this->smarty->assign("tplAction", "edit");
				} 
			}
			
			// send email with added data
			else if ( $this->action === "sendApproved" )
			{
				$this->source = isset($_GET['source']) ? $_GET['source'] : ""; 
				
				if ( $this->source === "post" )
				{
					$this->to         = isset($_POST['to']) ? $_POST['to'] : "";
					$this->fromName   = isset($_POST['fromname']) ? $_POST['fromname'] : "";
					$this->fromEmail  = isset($_POST['fromemail']) ? $_POST['fromemail'] : "";
					$this->replyEmail = isset($_POST['replyemail']) ? $_POST['replyemail'] : "";
					$this->subject    = isset($_POST['subject']) ? $_POST['subject'] : "";
					$this->body    = isset($_POST['message']) ? $_POST['message'] : "";
					
					if ($this->send()) 
					{	
						// if sent mail is notification about task
						if ($_SESSION["REQUEST"])
						{
							
						}
						$this->SayReport("Email bol úspešne odoslaný"); 
					}
					else
					{
						$this->SayError("Email sa nepodarilo poslať.");
					}
					  $query = "UPDATE DM_Events SET DM_Events.STATUS=1, DM_Events.DEADLINE='".$_SESSION["DEADLINE"]."', DM_Events.TERMINFO='".$_SESSION["TERMINFO"]."' WHERE DM_Events.ID=".$_SESSION["eventID"].";";
							$result = $this->db->Query($query);                   
				}
						
				$this->smarty->assign("tplAction", "edit");
			}
			
			$currPage = "Posielanie emailu";
			$navig = $this->navigation->GenerateNavigation($currPage);
		  
			$this->smarty->assign("navigation",$navig);
			$this->smarty->assign("currPage",$currPage);
			$this->smarty->assign("content","sendEmail.tpl");
		  
			return true;
    	}
    
		function Draw()
		{
			parent::Draw();
		}
	}
	
?>