<?php

class Admin extends Top
{
	private $sErrorMsg;
	private $sMsg;
	private $bFormSaved = false;

	private $iId;
	private $sLogin;
	private $sPassword1;
	private $sPassword2;
	private $aPermissions;
	private $iPermissions;
	private $iIsSuperadmin;
	private $iPasswd;


	public function __construct($db_object, $template_object, $lang_array, $used_lang_array, $id=null, $is_admin=false)
	{
		parent::__construct($db_object, $template_object, $lang_array, $used_lang_array, $is_admin);
		$this->iId = is_numeric($id) ? $id : null;
	}

	public function Show($is_passwd)
	{
		if($this->bIsAdmin==true){

			if($this->bFormSaved){
				$this->sMsg=$this->aLng['admin_saved'];
			}

			if ($this->sErrorMsg){
				$params = array("msg"=>$this->sErrorMsg);
				$status_error = $this->roTemplate->ParseRow("status_error.tpl", $params);
			} else {
				$status_error = "";
			}

			if ($this->sMsg){
				$params = array("msg"=>$this->sMsg);
				$status_ok = $this->roTemplate->ParseRow("status_ok.tpl", $params);
			} else {
				$status_ok = "";
			}

			$change_code = "";
			$permissions_code = "";
			$passwd_code = "";

			if($this->iId){

				if($is_passwd){
					$passwd_code = $this->roTemplate->ParseRow("admin_form_passwd.tpl");
				} else {
					$params = array(
					'checked_superadmin'=>$this->iIsSuperadmin ? "checked" : "",
					'checked_categories'=>($this->iPermissions & PERM_CATEGORIES) ? "checked" : "",
					'checked_products'=>($this->iPermissions & PERM_PRODUCTS) ? "checked" : "",
					'checked_producers'=>($this->iPermissions & PERM_PRODUCERS) ? "checked" : "",
					'checked_orders'=>($this->iPermissions & PERM_ORDERS) ? "checked" : "",
					'checked_admins'=>($this->iPermissions & PERM_ADMINS) ? "checked" : "",
					'checked_users_view'=>($this->iPermissions & PERM_USERS_VIEW) ? "checked" : "",
					'checked_users_edit'=>($this->iPermissions & PERM_USERS_EDIT) ? "checked" : "",
					);
					$permissions_code = $this->roTemplate->ParseRow("admin_form_permissions.tpl", $params);

					$params = array('id'=>$this->iId);
					$change_code = $this->roTemplate->ParseRow("admin_form_change.tpl", $params);
				}

			} else {

				$params = array('name'=>$this->sLogin);
				$passwd_code = $this->roTemplate->ParseRow("admin_form_new.tpl", $params);

				$params = array(
				'checked_superadmin'=>$this->iIsSuperadmin ? "checked" : "",
				'checked_categories'=>($this->iPermissions & PERM_CATEGORIES) ? "checked" : "",
				'checked_products'=>($this->iPermissions & PERM_PRODUCTS) ? "checked" : "",
				'checked_producers'=>($this->iPermissions & PERM_PRODUCERS) ? "checked" : "",
				'checked_orders'=>($this->iPermissions & PERM_ORDERS) ? "checked" : "",
				'checked_admins'=>($this->iPermissions & PERM_ADMINS) ? "checked" : "",
				'checked_users_view'=>($this->iPermissions & PERM_USERS_VIEW) ? "checked" : "",
				'checked_users_edit'=>($this->iPermissions & PERM_USERS_EDIT) ? "checked" : "",
				);
				$permissions_code = $this->roTemplate->ParseRow("admin_form_permissions.tpl", $params);
			}

			$params = array(
			"status_error"=>$status_error,
			"status_ok"=>$status_ok,
			"passwd"=>$passwd_code,
			"permissions"=>$permissions_code,
			"change_password"=>$change_code,
			'id'=>$this->iId,
			);

			$this->roTemplate->AddContent("admin_form.tpl", $params);

		} else {

			if (!$this->iId){
				return false;
			}

			$this->LoadData();


			$params = array(
			'id'=>$this->iId,
			'login'=>$this->sLogin,
			);

			$this->roTemplate->AddContent("admin.tpl", $params);

		}

		return true;
	}

	public function LoadData()
	{
		if($this->iId){
			if(!$this->LoadDB()){
				$this->sErrorMsg = $this->aLng['error_loading_admin_db'];
				return false;
			}
		}

		return true;
	}


	public function LoadDB()
	{
		$query = "SELECT login,permissions,is_superadmin FROM ".TBL_ADMINS." WHERE id=$this->iId";
		$row = $this->roDB->GetRow($query);
		if ($this->roDB->GetLastErrorMsg())
		{
			$this->sErrorMsg = $this->aLng['error_loading_admin_db'];
			return false;
		}

		list(
		$this->sLogin,
		$this->iPermissions,
		$this->iIsSuperadmin
		) = $row;

		return true;
	}


	public function ProcessForm($post)
	{
		if(isset($post['passwd'])){
			$this->iPasswd = $post['passwd'];
		}
		$this->iId = $post['id'];

		$form_errors = 0;

		if($this->iId){

			if($this->iPasswd){

				$this->sPassword1   = $post['password1'];
				$this->sPassword2   = $post['password2'];


				if (empty($this->sPassword1)){
					$this->sErrorMsg .= "<li>" . $this->aLng['empty_password'] . "</li>";
					$form_errors++;
				} elseif (isAlphaNum($this->sPassword1) == false) {
					$this->sErrorMsg .= "<li>" . $this->aLng['login_and_password_alphanum'] . "</li>";
					$form_errors++;
				} elseif ($this->sPassword1 != $this->sPassword2) {
					$this->sErrorMsg .= "<li>" . $this->aLng['password_missmatch'] . "</li>";
					$form_errors++;
				} elseif (false == isPassword($this->sPassword1)) {
					$this->sErrorMsg .= "<li>" . $this->aLng['password_invalid'] . "</li>";
					$form_errors++;
				}

			} else {

				$this->iIsSuperadmin   = isset($post['is_superadmin']) ? 1 : 0;
				$this->aPermissions   = isset($post['permissions']) ? $post['permissions'] : null;

				$this->iPermissions = 0;
				if(is_array($this->aPermissions)){
					foreach ($this->aPermissions as $value){
						$this->iPermissions += $value;
					}
				}
			}

		} else {

			$this->sLogin   = $post['name'];

			$this->iIsSuperadmin   = isset($post['is_superadmin']) ? 1 : 0;
			$this->aPermissions   = isset($post['permissions']) ? $post['permissions'] : null;


			$this->iPermissions = 0;
			if(is_array($this->aPermissions)){
				foreach ($this->aPermissions as $value){
					$this->iPermissions += $value;
				}
			}

			if (empty($this->sLogin)){
				$this->sErrorMsg .= "<li>" . $this->aLng['empty_login'] . "</li>";
				$form_errors++;
			} elseif (isAlphaNum($this->sLogin) == false) {
				$this->sErrorMsg .= "<li>" . $this->aLng['login_and_password_alphanum'] . "</li>";
				$form_errors++;
			} elseif ($this->LoginExists($this->sLogin) == true) {
				$this->sErrorMsg .= "<li>" . $this->aLng['login_exists'] . "</li>";
				$form_errors++;
			}

			$this->sPassword1   = $post['password1'];
			$this->sPassword2   = $post['password2'];


			if (empty($this->sPassword1)){
				$this->sErrorMsg .= "<li>" . $this->aLng['empty_password'] . "</li>";
				$form_errors++;
			} elseif (isAlphaNum($this->sPassword1) == false) {
				$this->sErrorMsg .= "<li>" . $this->aLng['login_and_password_alphanum'] . "</li>";
				$form_errors++;
			} elseif ($this->sPassword1 != $this->sPassword2) {
				$this->sErrorMsg .= "<li>" . $this->aLng['password_missmatch'] . "</li>";
				$form_errors++;
			} elseif (false == isPassword($this->sPassword1)) {
				$this->sErrorMsg .= "<li>" . $this->aLng['password_invalid'] . "</li>";
				$form_errors++;
			}
		}


		if ($form_errors > 0){
			$this->sErrorMsg = "<ul>" . $this->sErrorMsg . "</ul>";
			return false;
		}

		if(!$this->SaveData()){
			return false;
		} else {
			$this->bFormSaved = true;
			return true;
		}

		return true;
	}

	private function SaveData()
	{
		if ($this->iId){
			if($this->iPasswd){
				if(!$this->UpdatePassDB())
				{
					$this->sErrorMsg = $this->aLng['error_updating_admin_db'];
					return false;
				}
			} else {
				if(!$this->UpdateDB())
				{
					$this->sErrorMsg = $this->aLng['error_updating_admin_db'];
					return false;
				}
			}
		} else {
			if (!$this->InsertDB())
			{
				$this->sErrorMsg = $this->aLng['error_inserting_admin_db'];
				return false;
			}
		}

		return true;
	}


	private function LoginExists($login)
	{
		$query = "SELECT id,login FROM " . TBL_ADMINS . " WHERE LOWER(login) = '" . $this->roDB->MakeSecureString(strtolower($login)) . "'";
		$result = $this->roDB->GetRow($query);
		if ( ($this->roDB->GetLastErrorMsg()) || (!is_array($result)) ){
			return false;
		}else {
			return true;
		}
	}


	public function DeleteData()
	{
		if (!$this->iId){
			return false;
		}

		if(!$this->DeleteDB()){
			$this->sErrorMsg = $this->aLng['error_deleting_admin_db'];
			return false;
		}

		return true;
	}


	private function DeleteDB()
	{
		$query = "DELETE FROM ".TBL_ADMINS." WHERE id=$this->iId";
		$this->roDB->Delete($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}


	private function InsertDB()
	{
		$login = $this->roDB->MakeSecureString($this->sLogin);
		$password = $this->roDB->MakeSecureString($this->sPassword1);

		$query = "INSERT INTO ".TBL_ADMINS." (login,password,permissions,is_superadmin) VALUES ('$login','$password','$this->iPermissions','$this->iIsSuperadmin')";
		$this->roDB->Insert($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}
		
		$query = "SELECT id FROM ".TBL_ADMINS." ORDER BY id DESC LIMIT 1";
		$this->iId = $this->roDB->GetOne($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}		
	}


	private function UpdateDB()
	{
		if($this->iId==$_SESSION['admin_id']){
			$_SESSION['permissions'] = $this->iPermissions;
			$_SESSION['is_superadmin'] = $this->iIsSuperadmin;
		}

		$query = "UPDATE ".TBL_ADMINS." SET permissions='$this->iPermissions',is_superadmin='$this->iIsSuperadmin' WHERE id=$this->iId";
		$this->roDB->Update($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}

	private function UpdatePassDB()
	{
		$password = $this->roDB->MakeSecureString($this->sPassword1);

		$query = "UPDATE ".TBL_ADMINS." SET password='$password' WHERE id=$this->iId";
		$this->roDB->Update($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}

}

?>