<?php


class AdminList extends Top
{
	private $aData = array();
	private $sAdminListHTMLcode;
	private $sAdminPageHTMLcode;
	private $iActualPage = 1;
	private $iRowsPerPage = 50;
	private $iRowCount;
	private $sOrderBy = "login ASC";
	private $sWhere = "";


	public function Show()
	{
		$this->Build();

		if($this->bIsAdmin==true){

			$params = array(
			'rows'=>$this->sAdminListHTMLcode,
			'pages'=>$this->sAdminPageHTMLcode,
			);

		} else {

		}

		$this->roTemplate->AddContent("admin_list.tpl", $params);

		return true;
	}

	public function SetPage($actual_page)
	{
		$this->iActualPage = $actual_page;
	}


	public function DeleteAdmin($id)
	{
		$admin = new Admin($this->roDB, $this->roTemplate, $this->aLng, $this->aUsedLng,$id);
		$admin->DeleteData();
	}


	public function Load()
	{
		$from = $this->iActualPage * $this->iRowsPerPage - $this->iRowsPerPage;

		$query = "SELECT count(id) FROM ".TBL_ADMINS." $this->sWhere";
		$this->iRowCount = $this->roDB->GetOne($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}



		$query = "SELECT id,login FROM ".TBL_ADMINS." $this->sWhere ORDER BY $this->sOrderBy LIMIT $from , $this->iRowsPerPage";


		$this->aData = $this->roDB->GetArray($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}



	private function Build()
	{
		if (!$this->Load()){
			$params = array('err_message'=>$this->aLng['error_loading_list']);
			$this->sAdminListHTMLcode = $this->roTemplate->parseRow("error.tpl",$params);
			return false;
		}

		if (!is_array($this->aData)){
			return false;
		}

		$time = time();
		$counter = 1;

		foreach($this->aData as $row){

			list($id, $name) = $row;

			if($this->bIsAdmin==true){

				$params = array(
				'id'=>$id,
				'admin_name'=>$name
				);

				$this->sAdminListHTMLcode .= $this->roTemplate->parseRow("admin_list_row.tpl",$params);

			} else {

			}
		}

		$this->Paging();

		return true;
	}

	private function Paging(){
		$page_count = $this->iRowCount / $this->iRowsPerPage;

		if($this->iActualPage>1){
			$params = array('source'=>"admin_list", 'page_number'=>$this->iActualPage-1, 'page_name'=>$this->aLng['previous']);
			$this->sAdminPageHTMLcode .= $this->roTemplate->parseRow("paging.tpl",$params);
		}

		if($page_count>1){
			for($i=1; $i<$page_count+1;$i++ ){
				$params = array('source'=>"admin_list", 'page_number'=>$i, 'page_name'=>$i);
				if($this->iActualPage==$i){
					$params['class']="active_page";
				}
				$this->sAdminPageHTMLcode .= $this->roTemplate->parseRow("paging.tpl",$params);
			}
		}

		if($this->iActualPage<$page_count){
			$params = array('source'=>"admin_list", 'page_number'=>$this->iActualPage+1, 'page_name'=>$this->aLng['next']);
			$this->sAdminPageHTMLcode .= $this->roTemplate->parseRow("paging.tpl",$params);
		}
	}

	public function GetData(){
		return $this->aData;
	}

}
?>