<?php

class CartList extends Top
{
	private $aData = array();
	private $sCartListHTMLcode = "";

	private $iActualPage = 1;
	private $iRowsPerPage = 50;
	private $iRowCount = 0;

	private $bChange = false;
	private $bOrder = false;
	private $bIsListEmpty = false;

	public function __construct($db_object,$template_object,$lang,$used_lang, $is_admin = false)
	{
		parent::__construct($db_object,$template_object,$lang,$used_lang,$is_admin);
		$this->bIsPrivate = (isset($_SESSION['user_id']) && is_numeric($_SESSION['user_id'])) ? true : false;
	}

	public function Show()
	{
		$this->Build();

		if($this->bOrder){

			$this->roTemplate->AddContent("cart_ok.tpl");

		} else {

			$query = "SELECT id FROM ".TBL_PRODUCTS;
			$ids = $this->roDB->GetColumn($query);
			if ($this->roDB->GetLastErrorMsg()){
				return false;
			}

			$total_sum = 0;
			$items_count = 0;
			foreach ($ids as $id)
			{
				if(isset($_SESSION['product_'.$id])){
					$query = "SELECT price,discount FROM ".TBL_PRODUCTS." WHERE id=$id";
					$row = $this->roDB->GetRow($query);
					if ($this->roDB->GetLastErrorMsg()){
						return false;
					}

					list($price,$discount)=$row;

					if($discount>0){
						$price = $price * ((100-($discount/100))/100);
					}
					$total_sum += $price * $_SESSION['product_'.$id];
					$items_count += $_SESSION['product_'.$id];
				}
			}

			if($_SESSION['currency'] != DEFAULT_CURRENCY){
				$total_sum = round($total_sum / kurzNBS($_SESSION['currency']), 2);
			}

			$params = array(
			'rows'=>$this->sCartListHTMLcode,
			'pages'=>$this->Paging(),
			'result_from'=>$this->GetResultFrom(),
			'result_to'=>$this->GetResultTo(),
			'result'=>$this->GetRowCount(),
			'total_sum'=>$total_sum,
			);

			if($this->bIsListEmpty){
				$this->roTemplate->AddContent("cart_list_empty.tpl");
			} elseif($this->bChange){
				$this->roTemplate->AddContent("cart_list_change.tpl", $params);
			} else {
				$this->roTemplate->AddContent("cart_list.tpl", $params);
			}

		}

		return true;
	}

	public function SetPage($actual_page)
	{
		$this->iActualPage = $actual_page;
	}

	public function SetChange()
	{
		$this->bChange = true;
	}

	public function Order()
	{
		$this->SaveDataDB();

		$query = "SELECT id FROM ".TBL_PRODUCTS;
		$ids = $this->roDB->GetColumn($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}

		foreach ($ids as $id){
			if(isset($_SESSION['product_'.$id])){
				unset($_SESSION['product_'.$id]);
			}
		}

		echo "
        <script type=\"text/javascript\">
			self.location='cart.php?ok';
		</script>";

		exit();

		return true;
	}

	public function SetOk()
	{
		$this->bOrder = true;
		return true;
	}

	private function SaveDataDB()
	{
		$query = "SELECT id FROM ".TBL_PRODUCTS;
		$ids = $this->roDB->GetColumn($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}

		$total_sum = 0;
		foreach ($ids as $id){
			if(isset($_SESSION['product_'.$id])){
				$query = "SELECT price FROM ".TBL_PRODUCTS." WHERE id=$id";
				$price = $this->roDB->GetOne($query);
				if ($this->roDB->GetLastErrorMsg()){
					return false;
				}
				$total_sum += $price * $_SESSION['product_'.$id];
			}
		}

		$query = "INSERT INTO ".TBL_ORDERS." (users_id, time, total_sum) VALUES(
				'".$_SESSION['user_id']."',
				'".time()."',
				'$total_sum'
				)";
		$this->roDB->Insert($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}

		$new_id = $this->roDB->GetInsertId();

		foreach ($ids as $id)
		{
			if(isset($_SESSION['product_'.$id]))
			{
				$query = "SELECT name,price,discount FROM ".TBL_PRODUCTS." WHERE id=$id";
				$row = $this->roDB->GetRow($query);
				if ($this->roDB->GetLastErrorMsg()){
					return false;
				}

				list($name,$price,$discount)=$row;

				if($discount>0){
					$price = $price * ((100-($discount/100))/100);
				}

				$query = "INSERT INTO ".TBL_ITEMS." VALUES(
				'$new_id',
				'$id',
				'$name',
				'$price',
				'".$_SESSION['product_'.$id]."'
				)";
				$this->roDB->Insert($query);
				if ($this->roDB->GetLastErrorMsg()){
					return false;
				}

				$query = "SELECT stock_count FROM ".TBL_PRODUCTS." WHERE id=$id";
				$current_stock_count= $this->roDB->GetOne($query);
				if ($this->roDB->GetLastErrorMsg()){
					return false;
				}

				$current_stock_count -= $_SESSION['product_'.$id];

				$query = "UPDATE ".TBL_PRODUCTS." SET stock_count='$current_stock_count' WHERE id=$id";
				$this->roDB->Update($query);
				if ($this->roDB->GetLastErrorMsg()){
					return false;
				}
			}
		}
	}



	public function Build()
	{
		$query = "SELECT id FROM ".TBL_PRODUCTS;
		$ids = $this->roDB->GetColumn($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}

		foreach ($ids as $id)
		{
			if(isset($_SESSION['product_'.$id]))
			{
				$query = "SELECT name,price,discount FROM ".TBL_PRODUCTS." WHERE id=$id";
				$row = $this->roDB->GetRow($query);
				if ($this->roDB->GetLastErrorMsg()){
					return false;
				}

				list($name,$price,$discount)=$row;

				if($discount>0){
					$price = $price * ((100-($discount/100))/100);
				}

				if($_SESSION['currency'] != DEFAULT_CURRENCY){
					$price = round($price / kurzNBS($_SESSION['currency']), 2);
				}

				$params = array(
				'name'=>$name,
				'count'=>$_SESSION['product_'.$id],
				'price'=>$price,
				'product_id'=>$id,
				);

				if($this->bChange){
					$this->sCartListHTMLcode .= $this->roTemplate->parseRow("cart_list_row_change.tpl",$params);
				} else {
					$this->sCartListHTMLcode .= $this->roTemplate->parseRow("cart_list_row.tpl",$params);
				}

				$this->iRowCount++;
			}
		}

		if($this->iRowCount==0){
			$this->bIsListEmpty = true;
		}

		return $this->sCartListHTMLcode;
	}


	public function Paging($source="cart_list")
	{
		$paging = "";
		$page_count = ceil($this->iRowCount / $this->iRowsPerPage);

		if($this->iActualPage>1){
			$params = array('source'=>$source, 'page_number'=>$this->iActualPage-1, 'page_name'=>$this->aLng['previous'], 'amp'=>$amp);
			$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
		}

		if($page_count>1)
		{
			$_paging_count_pages_half = floor(PAGING_COUNT_PAGES / 2);

			$_page_start = max(1, min($this->iActualPage, $page_count - $_paging_count_pages_half) - $_paging_count_pages_half);
			$_page_stop = min(max($this->iActualPage, $_paging_count_pages_half) + $_paging_count_pages_half, $page_count);

			for($i=$_page_start; $i<=$_page_stop; $i++)
			{
				if($this->iActualPage==$i) {
					$params = array(
					'page_number'=>$i,
					);
					$paging .= $this->roTemplate->parseRow("paging_actual.tpl",$params);
				} else {
					$params = array(
					'source'=>$source,
					'page_number'=>$i,
					'page_name'=>$i,
					'amp'=>$amp
					);
					$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
				}
			}
		}

		if($this->iActualPage<$page_count){
			$params = array('source'=>$source, 'page_number'=>$this->iActualPage+1, 'page_name'=>$this->aLng['next'], 'amp'=>$amp);
			$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
		}

		return $paging;
	}

	public function GetData(){
		return $this->aData;
	}

	public function GetRowCount(){
		return ($this->bIsListEmpty==true) ? 0 : $this->iRowCount;
	}

	public function GetResultFrom(){
		return ($this->bIsListEmpty==true) ? 0 : $this->iActualPage * $this->iRowsPerPage - $this->iRowsPerPage + 1;
	}

	public function GetResultTo(){
		return ($this->bIsListEmpty==true) ? 0 :
		($this->iActualPage * $this->iRowsPerPage < $this->iRowCount) ?
		$this->iActualPage * $this->iRowsPerPage :
		$this->iRowCount ;
	}

}
?>
