<?php

class Category extends Top
{
	private $sErrorMsg;
	private $sMsg;
	private $bFormSaved = false;

	private $iId;
	private $iParentId;
	private $iHasImg;
	private $iDiscount = 0;
	private $aName = array();

	private $sFileTmpPath;
	private $sFileName;
	private $iActualPage = 1;
	private $sOrderBy;

	public function __construct($db_object, $template_object, $lang_array, $used_lang_array, $id=null, $is_admin=false)
	{
		parent::__construct($db_object, $template_object, $lang_array, $used_lang_array, $is_admin);
		$this->iId = is_numeric($id) ? $id : null;
	}

	public function Show()
	{
		if($this->bIsAdmin==true){

			if($this->bFormSaved){
				$this->sMsg=$this->aLng['category_saved'];
			}

			if(($this->iId) && (is_file(IMG_CATEGORIES_DIR."/".$this->iId.".jpg"))){
				$params = array("path"=>IMG_CATEGORIES_URL."/".$this->iId.".jpg");
			} else {
				$params = array("path"=>IMG_CATEGORIES_URL."/blank.gif");
			}
			$icon = $this->roTemplate->ParseRow("img.tpl", $params);

			$query = "SELECT id FROM ".TBL_CATEGORIES." ORDER BY id ASC";
			$ids = $this->roDB->GetColumn($query);
			if($this->roDB->GetLastErrorMsg()){
				$this->sError = $this->aLng['error_loading_category_db'];
				return false;
			}
			$parents = "";
			foreach($ids as $id){
				$params = array(
				'id'=>$id,
				'name'=>$this->aLng['category_'.$id],
				'selected'=>($this->iParentId==$id)?"selected=\"selected\"":"",
				);
				$parents .= $this->roTemplate->ParseRow("category_parent_option.tpl", $params);
			}

			$names = "";
			foreach ($this->aName as $index=>$value){
				$params = array(
				'lang'=>$index,
				'name'=>$value
				);
				$names .= $this->roTemplate->ParseRow("category_form_name.tpl", $params);
			}

			if ($this->sErrorMsg){
				$params = array("msg"=>$this->sErrorMsg);
				$status_error = $this->roTemplate->ParseRow("status_error.tpl", $params);
			} else {
				$status_error = "";
			}

			if ($this->sMsg){
				$params = array("msg"=>$this->sMsg);
				$status_ok = $this->roTemplate->ParseRow("status_ok.tpl", $params);
			} else {
				$status_ok = "";
			}

			$params = array(
			"status_error"=>$status_error,
			"status_ok"=>$status_ok,
			'id'=>$this->iId,
			'parent_id'=>$this->iParentId,
			'names'=>$names,
			'discount'=>$this->iDiscount,
			'icon'=>$icon,
			'parents'=>$parents,
			'file_tmp_name'=>$this->sFileTmpPath,
			'file_name'=>$this->sFileName,
			);

			$this->roTemplate->AddContent("category_form.tpl", $params);

		} else {

			$this->LoadData();

			// category's products
			$product_list = new ProductList($this->roDB, $this->roTemplate, $this->aLng, $this->aUsedLng);
			$product_list->SetCriteria("CATEGORY", $this->iId);
			$product_list->SetPage($this->iActualPage);
			if($this->sOrderBy){
				$product_list->SetOrder($this->sOrderBy);
			}


			$params = array(
			'id'=>$this->iId,
			'category_name'=>$this->aLng['category_'.$this->iId],
			'rows'=>$product_list->Build(),
			'pages'=>$product_list->Paging("category", $this->iId, $this->sOrderBy),
			'result_from'=>$product_list->GetResultFrom(),
			'result_to'=>$product_list->GetResultTo(),
			'result'=>$product_list->GetRowCount(),
			);

			$this->roTemplate->AddContent("category.tpl", $params);

		}

		return true;
	}

	public function SetPage($actual_page)
	{
		$this->iActualPage = $actual_page;
	}

	public function SetOrder($order_by)
	{
		$this->sOrderBy = $order_by;
	}

	public function LoadData()
	{
		if($this->iId){
			if(!$this->LoadDB()){
				$this->sErrorMsg = $this->aLng['error_loading_category_db'];
				return false;
			}
			$this->aName = $this->LoadLNGFiles();
		} else {
			$this->aName = $this->LoadLNGFiles(true);
		}

		return true;
	}

	public function ProcessForm($post, $files)
	{
		$form_errors = 0;

		$this->iId = $post['id'];

		if(isset($post['del_pic'])){
			if(!$this->iId){
				$this->LoadData();
				return false;
			}
			$this->DeletePicture();
			$this->LoadData();
			return true;
		}

		$this->aName = $post['name'];
		$this->iParentId = $post['parent_id'];
		$this->iDiscount = $post['discount'];
		$this->sFileName = $post['file_name'];
		$this->sFileTmpPath = $post['file_tmp_name'];

		foreach ($this->aName as $lang=>$name){
			if(empty($name)){
				$this->sErrorMsg .= "<li>" . $this->aLng['error_missing_category_name'] . " (".$lang.")</li>";
				$form_errors++;
			}
		}

		if((!is_numeric($this->iDiscount)) || (strlen($this->iDiscount)>4)){
			$this->sErrorMsg .= "<li>" . $this->aLng['error_incorrect_discount'] . "</li>";
			$form_errors++;
		}

		if ($form_errors > 0){
			$this->sErrorMsg = "<ul>" . $this->sErrorMsg . "</ul>";
			$this->InputFile($files);
			return false;
		}

		if(!$this->SaveData()){
			return false;
		} else {
			$this->bFormSaved = true;
		}

		if ($files["picture"]["error"]  == UPLOAD_ERR_OK)
		{
			$mime = $files["picture"]["type"];
			if( !(($mime=="image/jpeg") || ($mime=="image/pjpeg")) ) {
				$this->sErrorMsg= $this->aLng['incorrect_image_type'];
				return false;
			}
			$tmp_file = $files["picture"]["tmp_name"];
			$this->AddPicture($tmp_file);

		} elseif(isset($post['file_tmp_name'])){
			$this->AddPicture($post['file_tmp_name']);
		}

		return true;
	}

	private function SaveData()
	{
		if ($this->iId){
			if(!$this->UpdateDB()){
				$this->sErrorMsg = $this->aLng['error_updating_category_db'];
				return false;
			}
		} else {
			if(!$this->InsertDB()){
				$this->sErrorMsg = $this->aLng['error_inserting_category_db'];
				return false;
			}
		}
		return $this->UpdateLNGFiles();
	}


	private function InputFile($files)
	{
		if ($files["picture"]["error"] == UPLOAD_ERR_OK)
		{
			$mime = $files["picture"]["type"];
			if( (($mime=="image/jpeg") || ($mime=="image/pjpeg")) ) {
				$this->sFileTmpPath = $files['picture']['tmp_name'];
				$this->sFileName = $files['picture']['name'];
			}
		}

		return true;
	}


	private function DeletePicture()
	{
		$file = IMG_CATEGORIES_DIR . "/". $this->iId . ".jpg";
		if (is_file($file) && !@unlink($file)){
			return false;
		}

		$file = IMG_CATEGORIES_DIR . "/". $this->iId . "_orig.jpg";
		if (is_file($file) && !@unlink($file)){
			return false;
		}

		$this->UpdateHasImgDB(0);

		return true;
	}

	private function AddPicture($file)
	{
		$upload_dir = IMG_CATEGORIES_DIR;

		if(!makeDir($upload_dir))
		{
			$this->sErrorMsg= $this->aLng['no_rights_to_upload_dir'];
			return false;
		}

		$upload_file = $upload_dir ."/".$this->iId."_orig.jpg";

		if(!move_uploaded_file($file, $upload_file)){
			return false;
		}

		chmod($upload_file, IMAGE_CHMOD);

		$this->ImageHandle($upload_dir, $upload_file);

		if($this->iHasImg!=1){
			$this->UpdateHasImgDB(1);
		}

		return true;
	}


	private function UpdateHasImgDB($value)
	{
		$query = "UPDATE ".TBL_CATEGORIES." SET has_img=$value WHERE id=$this->iId";
		$this->roDB->Update($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}

	private function ImageHandle($upload_dir, $upload_file){

		$image = new MmImagick();
		$image->SetDebug(true);
		if (false == $image->OpenImage($upload_file)){
			return false;
		}

		$new_thumb = $upload_dir . '/' . $this->iId. '.jpg';
		if (!$image->GenerateThumbnail(MAX_CATEGORIES_WIDTH, MAX_CATEGORIES_HEIGHT, $new_thumb)){
			return false;
		}
		chmod($new_thumb, IMAGE_CHMOD);

		return true;
	}


	public function DeleteData()
	{
		if (!$this->iId){
			return false;
		}

		//delete subcategories
		$this->LoadDB();
		if($this->iHasImg==1){
			$this->DeletePicture();
		}
		$this->UpdateLNGFiles(true);
		if(!$this->DeleteDB()){
			$this->sErrorMsg = $this->aLng['error_deleting_category_db'];
			return false;
		}

		return true;
	}

	private function LoadDB()
	{
		$query = "SELECT parent_id, has_img, discount FROM ".TBL_CATEGORIES." WHERE id=$this->iId";
		$row = $this->roDB->GetRow($query);
		if($this->roDB->GetLastErrorMsg()){
			return false;
		}

		list(
		$this->iParentId,
		$this->iHasImg,
		$this->iDiscount,
		) = $row;

		return true;
	}

	private function DeleteDB()
	{
		$query = "DELETE FROM ".TBL_CATEGORIES_HAS_PRODUCTS." WHERE categories_id=$this->iId";
		$this->roDB->Delete($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}

		$query = "DELETE FROM ".TBL_CATEGORIES." WHERE id=$this->iId";
		$this->roDB->Delete($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}


	private function InsertDB()
	{
		$query = "INSERT INTO ".TBL_CATEGORIES." (parent_id, discount) VALUES ('$this->iParentId','$this->iDiscount')";
		$this->roDB->Insert($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}

		$query = "SELECT id FROM ".TBL_CATEGORIES." ORDER BY id DESC LIMIT 1";
		$this->iId = $this->roDB->GetOne($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}


	private function UpdateDB()
	{
		$query = "UPDATE ".TBL_CATEGORIES." SET parent_id='$this->iParentId', discount='$this->iDiscount' WHERE id=$this->iId";
		$this->roDB->Update($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}


	private function LoadLNGFiles($empty=false)
	{
		$result = array();
		foreach ($this->aUsedLng as $lng)
		{
			if($empty==true){
				$result[$lng] = "";
			} else {
				include(LNG_DIR."/$lng/categories.php");
				$index = "category_".$this->iId;
				$result[$lng] = $_LNG[$index];
			}
		}
		return $result;
	}


	private function UpdateLNGFiles($delete=false)
	{
		$index = "category_".$this->iId;

		foreach ($this->aUsedLng as $lng)
		{
			$content = "";
			include(LNG_DIR."/$lng/categories.php");

			if($delete==true){
				unset($_LNG[$index]);
			} else {
				$_LNG[$index] = $this->aName[$lng];
			}

			$content .="<?php \n";
			foreach ($_LNG as $key=>$value){
				$content .='$_LNG[\''.$key.'\'] = "'.$value.'";'."\n";
			}
			$content .= "?>";

			file_put_contents(LNG_DIR."/$lng/categories.php", $content);
		}

		return true;
	}

}
?>
