<?php


class Cols extends Top
{
	private $aData = array();
	private $sCategoriesHTMLcode = "";
	private $sProducersHTMLcode = "";

	public function ShowLeftCol()
	{

		if(isset($_SESSION['user_id']) && is_numeric($_SESSION['user_id']))
		{
			$params = array('nick_name'=>$_SESSION['user_login']);
			$form = $this->roTemplate->ParseRow("logout_form.tpl", $params);

			$query = "SELECT id FROM ".TBL_PRODUCTS;
			$ids = $this->roDB->GetColumn($query);
			if ($this->roDB->GetLastErrorMsg()){
				return false;
			}

			$total_sum = 0;
			$items_count = 0;
			foreach ($ids as $id){
				if(isset($_SESSION['product_'.$id])){
					$query = "SELECT price,discount FROM ".TBL_PRODUCTS." WHERE id=$id";
					$row = $this->roDB->GetRow($query);
					if ($this->roDB->GetLastErrorMsg()){
						return false;
					}

					list($price,$discount)=$row;

					if($discount>0){
						$price = $price * ((100-($discount/100))/100);
					}
					
					$total_sum += $price * $_SESSION['product_'.$id];
					$items_count += $_SESSION['product_'.$id];
				}
			}

			if($_SESSION['currency'] != DEFAULT_CURRENCY){
				$total_sum = round($total_sum / kurzNBS($_SESSION['currency']), 2);
			}

			$params = array('total_sum'=>$total_sum,'items_count'=>$items_count);
			$cart = $this->roTemplate->ParseRow("cart_form.tpl", $params);
		} else {
			$params = array();
			$form = $this->roTemplate->ParseRow("login_form.tpl", $params);
			$cart = "";
		}

		$params = array(
		'categories'=> $this->sCategoriesHTMLcode,
		'producers'=> $this->sProducersHTMLcode,
		'form'=>$form,
		'cart'=>$cart,
		'currencies'=>kurzyNbs("eur,usd,czk","mnozstvo,iso,kurz,datum",false,0),
		);

		return $this->roTemplate->ParseRow("cols_left.tpl", $params);
	}

	public function ShowRightCol()
	{

		// generate DVD of the day
		$time = time();
		$dvd_of_day_id = 0;
		$query = "  SELECT  v.id,
                            v.name
                    FROM ".TBL_COMMON." AS c
                    LEFT JOIN ".TBL_VIDEOS." AS v ON v.id=c.value
                    WHERE c.name='".TBLCOMMON_DVDOFDAY."'
                ";
		if ($video = $this->roDB->GetRow($query))
		{
			$dvd_of_day_id = $video[0];
			$dvd_of_day_name = $video[1];
		}


		// generate 3 random scenes
		$query = "SELECT s.id, v.id, v.name
                    FROM ".TBL_VIDEOS." AS v
                    LEFT JOIN ".TBL_SCENES." AS s ON s.videos_id=v.id
                    WHERE v.released_date<$time AND v.active=1
                    ORDER BY s.id ASC
                ";
		$scenes = $this->roDB->GetArray($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}
		$scenes_count = count($scenes);
		$first_divider = $scenes_count / 3;
		$second_divider = $first_divider * 2;

		$first_random = rand(0,$first_divider);
		$second_random = rand($first_divider+1,$second_divider);
		$third_random = rand($second_divider+1,$scenes_count-1);

		// first
		$first_random_scene_id = $scenes[$first_random][0];
		$first_random_videos_id = $scenes[$first_random][1];
		$first_video_name = $scenes[$first_random][2];

		$query = "SELECT id FROM ".TBL_SCENES." WHERE videos_id=$first_random_videos_id ORDER BY id ASC";
		$scenes_ids = $this->roDB->GetColumn($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}
		for($i=0;$i<count($scenes_ids);$i++){
			if(strcmp($scenes_ids[$i],$first_random_scene_id)==0){
				$scene_1_number = $i+1;
				break;
			}
		}

		// second
		$second_random_scene_id = $scenes[$second_random][0];
		$second_random_videos_id = $scenes[$second_random][1];
		$second_video_name = $scenes[$second_random][2];

		$query = "SELECT id FROM ".TBL_SCENES." WHERE videos_id=$second_random_videos_id ORDER BY id ASC";
		$scenes_ids = $this->roDB->GetColumn($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}
		for($i=0;$i<count($scenes_ids);$i++){
			if(strcmp($scenes_ids[$i],$second_random_scene_id)==0){
				$scene_2_number = $i+1;
				break;
			}
		}

		// third
		$third_random_scene_id = $scenes[$third_random][0];
		$third_random_videos_id = $scenes[$third_random][1];
		$third_video_name = $scenes[$third_random][2];

		$query = "SELECT id FROM ".TBL_SCENES." WHERE videos_id=$third_random_videos_id ORDER BY id ASC";
		$scenes_ids = $this->roDB->GetColumn($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}
		for($i=0;$i<count($scenes_ids);$i++){
			if(strcmp($scenes_ids[$i],$third_random_scene_id)==0){
				$scene_3_number = $i+1;
				break;
			}
		}

		$params = array(
		'img_path'=>$this->sImgPath,
		'path'=>$this->sPath,
		'bestsellers'=> $this->sBestsellersHTMLcode,
		'actors'=> $this->sActorsHTMLcode,

		'scene_1_link'=>SERVER_URL."/video.php?id=".$first_random_videos_id."#scene_".$first_random_scene_id,
		'scene_1_img_path'=>IMG_VIDEOS_URL."/".$first_random_videos_id."/".$first_random_scene_id."/0_thumb.jpg",
		'scene_1_video_name'=>$first_video_name,
		'scene_1_number'=>$scene_1_number,

		'scene_2_link'=>SERVER_URL."/video.php?id=".$second_random_videos_id."#scene_".$second_random_scene_id,
		'scene_2_img_path'=>IMG_VIDEOS_URL."/".$second_random_videos_id."/".$second_random_scene_id."/0_thumb.jpg",
		'scene_2_video_name'=>$second_video_name,
		'scene_2_number'=>$scene_2_number,

		'scene_3_link'=>SERVER_URL."/video.php?id=".$third_random_videos_id."#scene_".$third_random_scene_id,
		'scene_3_img_path'=>IMG_VIDEOS_URL."/".$third_random_videos_id."/".$third_random_scene_id."/0_thumb.jpg",
		'scene_3_video_name'=>$third_video_name,
		'scene_3_number'=>$scene_3_number
		);

		if ($dvd_of_day_id > 0)
		{
			$params['dvd_of_the_day_link'] = SERVER_URL."/video.php?id=".$dvd_of_day_id;
			$params['dvd_of_the_day_img_path'] = is_file(IMG_VIDEOS_DIR."/".$dvd_of_day_id."_thumb.jpg") ? IMG_VIDEOS_URL."/".$dvd_of_day_id."_thumb.jpg" : IMG_VIDEOS_URL."/no-cover.jpg";
			$params['dvd_of_the_day_name'] = $dvd_of_day_name;
		}

		return $this->roTemplate->ParseRow("cols_right.tpl", $params);
	}




	public function Load(){

		// 5 categories
		$category_list = new CategoryList($this->roDB, $this->roTemplate, $this->aLng, $this->aUsedLng);
		$category_list->SetCriteria("HOME");
		$category_list->Load();
		$this->aData = $category_list->GetData();
		foreach ($this->aData as $row){

			list($id, $parent_id, $has_img, $discount) = $row;

			$params = array(
			'path' => SERVER_URL."/category.php?id=".$id,
			'name' => $this->aLng['category_'.$id]
			);
			$this->sCategoriesHTMLcode .= $this->roTemplate->parseRow("cols_list.tpl",$params);
		}


		// 5 producers
		$producer_list = new ProducerList($this->roDB, $this->roTemplate, $this->aLng,$this->aUsedLng);
		$producer_list->SetCriteria("HOME");
		$producer_list->Load();
		$this->aData = $producer_list->GetData();

		foreach($this->aData as $row){

			list($id, $name, $has_logo) = $row;

			$params = array(
			'path' => SERVER_URL."/producer.php?id=".$id,
			'name' => $name
			);
			$this->sProducersHTMLcode .= $this->roTemplate->parseRow("cols_list.tpl",$params);
		}


	}


}
?>
