<?php
/*
 * Database abstraction class, implementing the Factory design pattern
 */

class Db
{
   /**
    * Database factory method
    *
    * @param string $type driver name
    * @param array $params parameters in associative array
    * 
    * $params can have the following indexes:
    *
    * CONN_STRING
    * HOST
    * PORT
    * LOGIN
    * PASSWORD
    * SCHEME
    * PERSISTENT
    * ENCODING
    *
    * @return class instance
    */
   public static function GetClass($type, $params)
   {
       if (include_once 'db_drivers/DB_' . $type . '.class.php') {
           $classname = 'DB_' . $type;
           return new $classname($params);
       } else {
           throw new Exception ("Database driver $type not found");
       }
   }
}
?>