<?php

class Login extends Top
{
	private $sRedirectPath;
	private $mSiteUrl;
	private $sLogin;
	private $sPassword;
	private $sErrorMsg = "";
	private $aUserData = array();



	public function ProcessForm($post)
	{
		$this->sLogin = $post['login'];
		$this->sPassword = $post['password'];

		if($this->bIsAdmin==true){

			if ($this->Verify($this->sLogin, $this->sPassword)==true)
			{
				$_SESSION['admin_id'] = $this->aUserData['id'];
				$_SESSION['permissions'] = $this->aUserData['permissions'];
				$_SESSION['is_superadmin'] = $this->aUserData['is_superadmin'];
				
				header("Location:" . $this->mSiteUrl . $this->sRedirectPath);
                exit();
			}

		} else {

			$form_errors = 0;

			// check
			if (empty($this->sLogin))
			{
				$this->sErrorMsg .= "<li>" . $this->aLng['empty_login'] . "</li>";
				$form_errors++;
			}
			if (empty($this->sPassword))
			{
				$this->sErrorMsg .= "<li>" . $this->aLng['empty_password'] . "</li>";
				$form_errors++;
			}


			if ($form_errors == 0)
			{
				if ($this->Verify($this->sLogin, $this->sPassword)==false)
				{
					$this->sErrorMsg .= "<li>" . $this->aLng['wrong_login_or_password'] . "</li>";
					$form_errors++;
				}
			}

			if ($form_errors > 0){
				$this->sErrorMsg = "<ul>" . $this->sErrorMsg . "</ul>";
				$params = array("error_list"=>$this->sErrorMsg);
				$this->sErrorMsg = $this->roTemplate->ParseRow("errors.tpl", $params);
				return false;
			}


			// set session
			$_SESSION['user_id'] = $this->aUserData['id'];
			$_SESSION['user_login'] = $this->aUserData['login'];
			
			self::UpdateUserStatDB($this->aUserData['id']);

			header("Location:" . $this->mSiteUrl . $this->sRedirectPath);
			exit();
		}

		return true;
	}
	

	public function SetTargetPath($url, $target_path)
	{
		$this->mSiteUrl = $url;
		$this->sRedirectPath = $target_path;
	}


    private function Verify($login, $password)
    {
        if ($this->bIsAdmin)
        {
            $query = "  SELECT  id,
                                permissions,
                                is_superadmin
                        FROM " . TBL_ADMINS . "
                        WHERE
                            login = '" . $this->roDB->MakeSecureString(strtolower($login)) . "'
                            AND password = '" . $this->roDB->MakeSecureString($password) . "'";
            $row = $this->roDB->GetRow($query);
            if ( ($this->roDB->GetLastErrorMsg()) || (!is_array($row)) )
                return false;
            $this->aUserData['id'] = $row[0];
            $this->aUserData['permissions'] = $row[1];
            $this->aUserData['is_superadmin'] = $row[2];
        }
        else
        {
            $query = "  SELECT
            				      pass_string
                        FROM
                        	" . TBL_USERS . "
                        WHERE
                            login = '" . $this->roDB->MakeSecureString(strtolower($login)) . "'
                            ";
            $pass_string = $this->roDB->GetOne($query);
    
            $query = "  SELECT
            				id, login
                        FROM
                        	" . TBL_USERS . "
                        WHERE
                            login = '" . $this->roDB->MakeSecureString(strtolower($login)) . "'
                            AND password = '" . md5($this->roDB->MakeSecureString($password) . $pass_string) . "'";
            $row = $this->roDB->GetRow($query);
            if ( ($this->roDB->GetLastErrorMsg()) || (!is_array($row)) )
                return false;
            $this->aUserData['id'] = $row[0];
            $this->aUserData['login'] = $row[1];                
        }

        return true;
    }

	public static function UpdateUserStatDB($user_id)
	{
		global $_DB;
		$IP_adress = $_SERVER[IP_VARIABLE];
		$query = "UPDATE ".TBL_USERS." SET last_connect='".time()."',last_ip='$IP_adress' WHERE id=$user_id";
		$_DB->Update($query);
		if ($_DB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}

    private function ClearSession()
    {
    	$temp_lng = $_SESSION['lang'];
    	$temp_currency = $_SESSION['currency'];
        $_SESSION = array();
        $_SESSION['lang'] = $temp_lng;
        $_SESSION['currency'] = $temp_currency;
    }

	public function Show()
	{

		$params = array("login"=>$this->sLogin);
		
		if($this->bIsAdmin==false){
			$params["errors"]=$this->sErrorMsg;
		} else {
			$params["errors"]="";
		}

		$this->roTemplate->AddContent("login.tpl", $params);

		return true;
	}
	
    public function Logout()
    {
    	$this->ClearSession();
    }

}
?>
