<?php

define('PERM_CATEGORIES',   	1);     // 0000000000000001
define('PERM_PRODUCTS',       	2);     // 0000000000000010
define('PERM_PRODUCERS',    	4);     // 0000000000000100
define('PERM_ORDERS',      		8);     // 0000000000001000
define('PERM_USERS',       		16);    // 0000000000010000
define('PERM_CURRENCIES',       32);    // 0000000000100000
define('PERM_DISCOUNTS',       	64);    // 0000000001000000
define('PERM_ADMINS',   		128);   // 0000000010000000
define('PERM_USERS_VIEW',		256);   // 0000000100000000
define('PERM_USERS_EDIT',   	512);   // 0000001000000000

/*
define('PERM_CREDIT_CARDS',      1024);  // 0000010000000000
define('PERM_PAYMENT_LOGS',      2048);  // 0000100000000000
define('PERM_ORDERS',               4096);  // 0001000000000000
define('PERM_PREMIUM_SPOTS',        8192);  // 0010000000000000
define('PERM_PAYMENTS',             16384); // 0100000000000000
define('PERM_SMS',                  32768); // 1000000000000000
*/

class Menu extends Top
{

	public static function CheckPermissions($permission)
	{
        if (isset($_SESSION['is_superadmin']) && ($_SESSION['is_superadmin']==1)) {
            return true;
        }

		if (isset($_SESSION['permissions']) && ($_SESSION['permissions'] & $permission)) {
			return true;
		}

		return false;
	}

	public function Show()
	{
		$params = array(
		"categories"	=>	$this->CheckPermissions(PERM_CATEGORIES)	?"&gt;<a href=\"category_list.php\">Categories</a>&nbsp;&nbsp;&nbsp;&nbsp;"		:"&nbsp;",
		"products"		=>	$this->CheckPermissions(PERM_PRODUCTS)		?"&gt;<a href=\"product_list.php\">Products</a>&nbsp;&nbsp;&nbsp;&nbsp;"	:"",
		"producers"		=>	$this->CheckPermissions(PERM_PRODUCERS)		?"&gt;<a href=\"producer_list.php\">Producers</a>&nbsp;&nbsp;&nbsp;&nbsp;"	:"",
		"editors"		=>	$this->CheckPermissions(PERM_PRODUCERS)		?"&gt;<a href=\"product_list.php?editors\">Editors</a>&nbsp;&nbsp;&nbsp;&nbsp;"	:"",
		"orders"		=>	$this->CheckPermissions(PERM_ORDERS)		?"&gt;<a href=\"order_list.php\">Orders</a>&nbsp;&nbsp;&nbsp;&nbsp;"		:"",
		"users"			=>	$this->CheckPermissions(PERM_USERS)			?"&gt;<a href=\"user_list.php\">Users</a>&nbsp;&nbsp;&nbsp;&nbsp;"			:"",
		//"currencies"	=>	$this->CheckPermissions(PERM_CURRENCIES)	?"&gt;<a href=\"currency_list.php\">Currencies</a>&nbsp;&nbsp;&nbsp;&nbsp;"	:"",
		//"discounts"		=>	$this->CheckPermissions(PERM_DISCOUNTS)		?"&gt;<a href=\"discount_list.php\">Discounts</a>&nbsp;&nbsp;&nbsp;&nbsp;"	:"",
		"admins"		=>	$this->CheckPermissions(PERM_ADMINS)		?"&gt;<a href=\"admin_list.php\">Admins</a>&nbsp;&nbsp;&nbsp;&nbsp;"		:"",
		"logout_link"	=>	((isset($_SESSION['admin_id']) && is_numeric($_SESSION['admin_id']))) ? $this->roTemplate->ParseRow("logout_link.tpl") : "",
		);

		return $this->roTemplate->ParseRow("menu.tpl", $params);
	}
}

?>
