<?php
class Order extends Top
{
	private $iId;
	private $aData;


	public function __construct($db_object, $template_object, $lang_array, $used_lang_array, $id=null, $is_admin=false)
	{
		parent::__construct($db_object, $template_object, $lang_array, $used_lang_array, $is_admin);
		$this->iId = is_numeric($id) ? $id : null;
	}


	public function Show()
	{
		$this->LoadDB();

		$rows = "";
		$pages = "";
		$sum = 0;
		
		foreach ($this->aData as $row)
		{
			list($name,$price,$count)=$row;
			
			$sum += $count * $price;
			
			$rows .= "<tr>
			<td>$name</td>
			<td>$count</td>
			<td>x</td>
			<td>$price</td>
			</tr>";
			
		}
		
		$query = "
			SELECT
				u.login
			FROM
				".TBL_USERS." AS u,
				".TBL_ORDERS." AS o
			WHERE
				u.id=o.users_id
				AND o.id=$this->iId
				";
		$name = $this->roDB->GetOne($query);
		if($this->roDB->GetLastErrorMsg()){
			return false;
		} 		
		
		$params = array(
		'pages'=>$pages,
		'rows'=>$rows,
		'name'=>$name,
		'sum'=>$sum,
		);		

		$this->roTemplate->AddContent("order.tpl", $params);

		return true;
	}




	public function LoadDB()
	{
		$query = "
			SELECT
				name,
				price,
				count
			FROM
				".TBL_ITEMS."
			WHERE
				orders_id=$this->iId
				";
		$this->aData = $this->roDB->GetArray($query);
		if($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}


	public function UpdateExecutedDB($value)
	{
		if (!$this->iId){
			return false;
		}
		$query = "UPDATE ".TBL_ORDERS." SET executed=$value WHERE id=$this->iId";
		$this->roDB->Update($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}

}
?>
