<?php


class OrderList extends Top
{
	private $aData = array();
	private $sOrderListHTMLcode = "";

	private $iActualPage = 1;
	private $iRowsPerPage = 50;
	private $iRowCount;

	private $sOrderBy = "time DESC";

	public function Show()
	{
		$this->Build();

		if($this->bIsAdmin==true)
		{
			$params = array(
			'rows'=>$this->sOrderListHTMLcode,
			'pages'=>$this->Paging(),
			);
		} else {

		}

		$this->roTemplate->AddContent("order_list.tpl", $params);

		return true;
	}

	public function SetPage($actual_page)
	{
		$this->iActualPage = $actual_page;
	}

	public function UpdateExecution($id,$add=true)
	{
		$order = new Order($this->roDB, $this->roTemplate, $this->aLng, $this->aUsedLng, $id, true);
		$value = ($add==true) ? 1 : 0;
		$order->UpdateExecutedDB($value);
	}

	public function Load()
	{
		$from = $this->iActualPage * $this->iRowsPerPage - $this->iRowsPerPage;

		$query = "SELECT COUNT(id) FROM ".TBL_ORDERS;
		$this->iRowCount = $this->roDB->GetOne($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}

		$query = "  SELECT
						id,
                        users_id,
                        time,
                        total_sum,                        
                        executed
                    FROM
                        ".TBL_ORDERS."
                    ORDER BY
                        $this->sOrderBy
                    LIMIT
                        $from , $this->iRowsPerPage
                ";
		$this->aData = $this->roDB->GetArray($query);
		return !$this->roDB->GetLastErrorMsg();
	}



	public function Build()
	{
		//error loading list
		if (!$this->Load()){
			$params = array('err_message'=>$this->aLng['error_loading_list']);
			$this->sOrderListHTMLcode = $this->roTemplate->parseRow("error.tpl",$params);
			return $this->sOrderListHTMLcode;
		}

		// empty list
		if (!is_array($this->aData) || empty($this->aData)){
			$this->bIsListEmpty = true;
			return false;
		}



		foreach($this->aData as $row){

			list($id,$users_id,$time,$total_sum,$executed) = $row;

			$query = "SELECT login FROM ".TBL_USERS." WHERE id=$users_id";
			$user_name = $this->roDB->GetOne($query);
			if ($this->roDB->GetLastErrorMsg()){
				return false;
			}


			if($this->bIsAdmin){

				if($executed==0){
					$params = array(
					'id'=>$id,
					'page'=>($this->iActualPage>1) ? "&page=".$this->iActualPage : "",
					);
					$executed = $this->roTemplate->parseRow("order_list_row_executed_link.tpl",$params);

				} else {
					$executed = "&nbsp;";
				}

				$params = array(
				'id'=>$id,
				'users_id'=>$users_id,
				'user_name'=>$user_name,
				'time'=>date("d.m.Y h:m:i", $time),
				'total_sum'=>$total_sum,
				'executed'=>$executed,
				);

				$this->sOrderListHTMLcode .= $this->roTemplate->parseRow("order_list_row.tpl",$params);

			} else {

			}
		}

		return $this->sOrderListHTMLcode;
	}


	public function Paging($source="order_list", $id=null, $order=null, $criteria=null)
	{
		$paging = "";
		$amp = "";
		$page_count = ceil($this->iRowCount / $this->iRowsPerPage);

		if($this->iActualPage>1){
			$params = array('source'=>$source, 'page_number'=>$this->iActualPage-1, 'page_name'=>$this->aLng['previous'], 'amp'=>$amp);
			$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
		}

		if($page_count>1)
		{
			$_paging_count_pages_half = floor(PAGING_COUNT_PAGES / 2);

			$_page_start = max(1, min($this->iActualPage, $page_count - $_paging_count_pages_half) - $_paging_count_pages_half);
			$_page_stop = min(max($this->iActualPage, $_paging_count_pages_half) + $_paging_count_pages_half, $page_count);

			for($i=$_page_start; $i<=$_page_stop; $i++)
			{
				if($this->iActualPage==$i) {
					$params = array(
					'page_number'=>$i,
					);
					$paging .= $this->roTemplate->parseRow("paging_actual.tpl",$params);
				} else {
					$params = array(
					'source'=>$source,
					'page_number'=>$i,
					'page_name'=>$i,
					'amp'=>$amp
					);
					$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
				}
			}
		}

		if($this->iActualPage<$page_count){
			$params = array('source'=>$source, 'page_number'=>$this->iActualPage+1, 'page_name'=>$this->aLng['next'], 'amp'=>$amp);
			$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
		}

		return $paging;
	}

	public function GetData(){
		return $this->aData;
	}

}
?>
