<?php

class Producer extends Top
{
	private $sErrorMsg;
	private $sMsg;
	private $bFormSaved = false;

	private $iId;
	private $sName;
	private $iHasLogo;

	private $sFileTmpPath;
	private $sFileName;
	private $iActualPage = 1;
	private $sOrderBy;



	public function __construct($db_object, $template_object, $lang_array, $used_lang_array, $id=null, $is_admin=false)
	{
		parent::__construct($db_object, $template_object, $lang_array, $used_lang_array, $is_admin);
		$this->iId = is_numeric($id) ? $id : null;
	}

	public function SetPage($actual_page)
	{
		$this->iActualPage = $actual_page;
	}

	public function SetOrder($order_by)
	{
		$this->sOrderBy = $order_by;
	}

	public function LoadData()
	{
		if($this->iId){
			if(!$this->LoadDB()){
				$this->sErrorMsg = $this->aLng['error_loading_producer_db'];
				return false;
			}
		}

		return true;
	}



	private function LoadDB()
	{
		$query = "SELECT name, has_logo FROM ".TBL_PRODUCERS." WHERE id=$this->iId";
		$data = $this->roDB->GetRow($query);
		if($this->roDB->GetLastErrorMsg()){
			return false;
		}

		list(
		$this->sName,
		$this->iHasLogo
		) = $data;


		return true;
	}


	public function ProcessForm($post, $files)
	{
		$form_errors = 0;

		$this->iId = $post['id'];

		if(isset($post['del_pic'])){
			if(!$this->iId){
				return false;
			}
			$this->DeletePicture();
			$this->LoadData();
			return true;
		}

		$this->sName = $post['name'];
		$this->sFileName = $post['file_name'];
		$this->sFileTmpPath = $post['file_tmp_name'];

		if (!$this->sName){
			$this->sErrorMsg .= "<li>" . $this->aLng['error_missing_producer_name'] . "</li>";
			$form_errors++;
		}

		if ($form_errors > 0){
			$this->sErrorMsg = "<ul>" . $this->sErrorMsg . "</ul>";
			$this->InputFile($files);
			return false;
		}

		if(!$this->SaveData()){
			return false;
		} else {
			$this->bFormSaved = true;
		}

		if ($files["picture"]["error"]  == UPLOAD_ERR_OK)
		{
			$mime = $files["picture"]["type"];
			if( !(($mime=="image/jpeg") || ($mime=="image/pjpeg")) ) {
				$this->sErrorMsg= $this->aLng['incorrect_image_type'];
				return false;
			}
			$tmp_file = $files["picture"]["tmp_name"];
			$this->AddPicture($tmp_file);

		} elseif(isset($post['file_tmp_name'])){
			$this->AddPicture($post['file_tmp_name']);
		}

		return true;
	}


	private function InputFile($files)
	{
		if ($files["picture"]["error"] == UPLOAD_ERR_OK)
		{
			$mime = $files["picture"]["type"];
			if( (($mime=="image/jpeg") || ($mime=="image/pjpeg")) ) {
				$this->sFileTmpPath = $files['picture']['tmp_name'];
				$this->sFileName = $files['picture']['name'];
			}
		}

		return true;
	}

	private function DeletePicture()
	{
		$file = IMG_PRODUCERS_DIR . "/". $this->iId . ".jpg";
		if (is_file($file) && !@unlink($file)){
			return false;
		}

		$file = IMG_PRODUCERS_DIR . "/". $this->iId . "_orig.jpg";
		if (is_file($file) && !@unlink($file)){
			return false;
		}

		$this->UpdateHasLogoDB(0);

		return true;
	}

	private function AddPicture($file)
	{
		$upload_dir = IMG_PRODUCERS_DIR;

		if(!makeDir($upload_dir))
		{
			$this->sErrorMsg= $this->aLng['no_rights_to_upload_dir'];
			return false;
		}

		$upload_file = $upload_dir ."/".$this->iId."_orig.jpg";

		if(!move_uploaded_file($file, $upload_file)){
			return false;
		}

		chmod($upload_file, IMAGE_CHMOD);

		$this->ImageHandle($upload_dir, $upload_file);

		if($this->iHasLogo!=1){
			$this->UpdateHasLogoDB(1);
		}

		return true;
	}


	private function UpdateHasLogoDB($value)
	{
		$query = "UPDATE ".TBL_PRODUCERS." SET has_logo=$value WHERE id=$this->iId";
		$this->roDB->Update($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}

	private function ImageHandle($upload_dir, $upload_file){

		$image = new MmImagick();
		$image->SetDebug(true);
		if (false == $image->OpenImage($upload_file)){
			return false;
		}

		$new_thumb = $upload_dir . '/' . $this->iId. '.jpg';
		if (!$image->GenerateThumbnail(MAX_PRODUCERS_WIDTH, MAX_PRODUCERS_HEIGHT, $new_thumb)){
			return false;
		}
		chmod($new_thumb, IMAGE_CHMOD);

		return true;
	}

	private function SaveData()
	{
		if ($this->iId){
			if(!$this->UpdateDB()){
				$this->sErrorMsg = $this->aLng['error_updating_producer_db'];
				return false;
			}
		} else {
			if(!$this->InsertDB()){
				$this->sErrorMsg = $this->aLng['error_inserting_producer_db'];
				return false;
			}
		}

		return true;
	}


	public function Show()
	{
		if($this->bIsAdmin==true){

			if($this->bFormSaved){
				$this->sMsg=$this->aLng['producer_saved'];
			}

			if(($this->iId) && (is_file(IMG_PRODUCERS_DIR."/".$this->iId.".jpg"))){
				$params = array("path"=>IMG_PRODUCERS_URL."/".$this->iId.".jpg");
			} else {
				$params = array("path"=>IMG_PRODUCERS_URL."/blank.gif");
			}
			$logo = $this->roTemplate->ParseRow("img.tpl", $params);

			if ($this->sErrorMsg){
				$params = array("msg"=>$this->sErrorMsg);
				$status_error = $this->roTemplate->ParseRow("status_error.tpl", $params);
			} else {
				$status_error = "";
			}

			if ($this->sMsg){
				$params = array("msg"=>$this->sMsg);
				$status_ok = $this->roTemplate->ParseRow("status_ok.tpl", $params);
			} else {
				$status_ok = "";
			}

			$params = array(
			"status_error"=>$status_error,
			"status_ok"=>$status_ok,
			'id'=>$this->iId,
			'name'=>$this->sName,
			'logo'=>$logo,
			'file_tmp_name'=>$this->sFileTmpPath,
			'file_name'=>$this->sFileName,
			);


			$this->roTemplate->AddContent("producer_form.tpl", $params);

		} else {

			$this->LoadData();

			// producer's products
			$product_list = new ProductList($this->roDB, $this->roTemplate, $this->aLng, $this->aUsedLng);
			$product_list->SetCriteria("PRODUCER", $this->iId);
			$product_list->SetPage($this->iActualPage);
			if($this->sOrderBy){
				$product_list->SetOrder($this->sOrderBy);
			}


			$params = array(
			'id'=>$this->iId,
			'producer_name'=>$this->sName,
			'rows'=>$product_list->Build(),
			'pages'=>$product_list->Paging("producer", $this->iId, $this->sOrderBy),
			'result_from'=>$product_list->GetResultFrom(),
			'result_to'=>$product_list->GetResultTo(),
			'result'=>$product_list->GetRowCount(),
			);

			$this->roTemplate->AddContent("producer.tpl", $params);
		}


		return true;
	}


	public function DeleteData()
	{
		if (!$this->iId){
			return false;
		}

		if(!$this->DeleteDB()){
			$this->sErrorMsg = $this->aLng['error_deleting_producer_db'];
			return false;
		}

		return true;
	}


	private function DeleteDB()
	{
		$query = "DELETE FROM ".TBL_PRODUCERS." WHERE id=$this->iId";
		$this->roDB->Delete($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}


	private function InsertDB()
	{
		$name = $this->roDB->MakeSecureString($this->sName);
		$query = "INSERT INTO ".TBL_PRODUCERS." (name) VALUES ('$name')";
		$this->roDB->Insert($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}


	private function UpdateDB()
	{
		$name = $this->roDB->MakeSecureString($this->sName);
		$query = "UPDATE ".TBL_PRODUCERS." SET name='$name' WHERE id=$this->iId";
		$this->roDB->Update($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}


}
?>