<?php


class ProducerList extends Top
{
	private $aData = array();
	private $sProductListHTMLcode = "";
	private $sProductListLeftHTMLcode = "";
	private $sProductListRightHTMLcode = "";

	private $iActualPage = 1;
	private $iRowsPerPage = 50;
	private $iRowCount;

	private $sOrderBy = "p.id ASC";
	private $sWhere = "";
	private $sCriteria = "";


	public function Show()
	{
		$this->Build();

		if($this->bIsAdmin==true)
		{
			$params = array('source'=>"producer_list");
			$search = $this->roTemplate->ParseRow("search.tpl", $params);

			$params = array(
			'rows'=>$this->sProductListHTMLcode,
			'pages'=>$this->Paging(),
			'search'=>$search,
			);
		} else {

			$params = array(
			'rows_left'=>$this->sProductListLeftHTMLcode,
			'rows_right'=>$this->sProductListRightHTMLcode,
			'pages'=>$this->Paging(),
			//'search'=>$search,
			);
		}


		$this->roTemplate->AddContent("producer_list.tpl", $params);

		return true;
	}

	public function SetPage($actual_page)
	{
		$this->iActualPage = $actual_page;
	}


	public function SetCriteria($const, $letter=null){

		$this->sCriteria = $const;

		switch ($const){
			case "HOME":
				$this->sOrderBy = "p.name ASC";
				$this->iRowsPerPage = 5;
				break;
			case "LETTER":
				$this->sWhere = "AND p.name like '$letter%'";
				break;
		}

	}

	public function DeleteProducer($id)
	{
		$producer = new Producer($this->roDB, $this->roTemplate, $this->aLng, $this->aUsedLng, $id);
		$producer->DeleteData();
	}


	public function Load()
	{
		$from = $this->iActualPage * $this->iRowsPerPage - $this->iRowsPerPage;

		$sql_from = "";
		$sql_where = "";
		$time = time();

		if($this->bIsAdmin==true){
			$sql_from .= TBL_PRODUCERS." AS p";
		} else {
			$sql_from .= TBL_PRODUCERS." AS p, ".TBL_PRODUCTS." AS pt";
			$sql_where = "AND p.id=pt.producers_id AND pt.released_date<$time AND pt.active=1";
		}

		$query = "  SELECT count(DISTINCT p.id)
                    FROM $sql_from
                    WHERE 1=1
                    $sql_where
                    $this->sWhere
                ";
		$this->iRowCount = $this->roDB->GetOne($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}

		$query = "  SELECT DISTINCT p.id, p.name, p.has_logo
                    FROM $sql_from
                    WHERE 1=1
                    $sql_where
                    $this->sWhere
                    ORDER BY $this->sOrderBy
                    LIMIT $from , $this->iRowsPerPage
                ";
		$this->aData = $this->roDB->GetArray($query);
		if ($this->roDB->GetLastErrorMsg() || (!is_array($this->aData))){
			return false;
		} else {
			return true;
		}
	}



	private function Build()
	{
		if (!$this->Load()){
			$params = array('err_message'=>$this->aLng['error_loading_list']);
			$this->sProductListHTMLcode = $this->roTemplate->parseRow("error.tpl",$params);
			return false;
		}


		$time = time();
		$counter = 1;
		$half = ceil($this->iRowCount/2);		

		foreach($this->aData as $row){

			list($id, $name, $has_logo) = $row;

			$query = "SELECT count(id) FROM ".TBL_PRODUCTS." WHERE producers_id=$id AND released_date<$time AND active=1";
			$product_count = $this->roDB->GetOne($query);
			if ($this->roDB->GetLastErrorMsg()){
				return false;
			}

			if($this->bIsAdmin==true){

				$params = array(
				'id'=>$id,
				'producer_name'=>$name
				);

				$this->sProductListHTMLcode .= $this->roTemplate->parseRow("producer_list_row.tpl",$params);

			} else {

				$params = array(
				'producer_name'=>$name,
				'product_count'=>$product_count,
				);

				$producer_list_row =  $this->roTemplate->parseRow("producer_list_row.tpl",$params);

				if($product_count>0){

					$params = array(
					'path'=>"producer.php?id=".$id,
					'name'=>$producer_list_row,
					);

					if($counter>$half){
						$this->sProductListRightHTMLcode .= $this->roTemplate->parseRow("cols_list.tpl",$params);
					} else {
						$this->sProductListLeftHTMLcode .= $this->roTemplate->parseRow("cols_list.tpl",$params);
					}
				}

				$counter++;
			}
		}

		return true;
	}


	private function Paging($source="producer_list")
	{
		$paging = "";
		$amp = "";
		$page_count = ceil($this->iRowCount / $this->iRowsPerPage);

		if($this->iActualPage>1){
			$params = array('source'=>$source, 'page_number'=>$this->iActualPage-1, 'page_name'=>$this->aLng['previous'], 'amp'=>$amp);
			$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
		}

		if($page_count>1)
		{
			$_paging_count_pages_half = floor(PAGING_COUNT_PAGES / 2);

			$_page_start = max(1, min($this->iActualPage, $page_count - $_paging_count_pages_half) - $_paging_count_pages_half);
			$_page_stop = min(max($this->iActualPage, $_paging_count_pages_half) + $_paging_count_pages_half, $page_count);

			for($i=$_page_start; $i<=$_page_stop; $i++)
			{
				if($this->iActualPage==$i) {
					$params = array(
					'page_number'=>$i,
					);
					$paging .= $this->roTemplate->parseRow("paging_actual.tpl",$params);
				} else {
					$params = array(
					'source'=>$source,
					'page_number'=>$i,
					'page_name'=>$i,
					'amp'=>$amp
					);
					$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
				}
				$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
			}
		}

		if($this->iActualPage<$page_count){
			$params = array('source'=>$source, 'page_number'=>$this->iActualPage+1, 'page_name'=>$this->aLng['next'], 'amp'=>$amp);
			$paging .= $this->roTemplate->parseRow("paging.tpl",$params);
		}

		return $paging;
	}

	public function GetData(){
		return $this->aData;
	}

}
?>
