<?php
class Product extends Top
{
	private $sErrorMsg;
	private $sMsg;
	private $bFormSaved = false;

	private $iId;
	private $sName;
	private $iProducerId;
	private $iAddedDate;
	private $iReleasedDate;
	private $iPrice;
	private $iAvailability = 0;
	private $iStockCount = 0;
	private $iActive = 1;
	private $iIsEditorsPick;
	private $iHasImg;
	private $iDiscount = 0;


	private $aDescription = array();
	private $aCategories = array();
	private $sFrontIconHTMLcode;
	private $sBackIconHTMLcode;
	private $bIsPrivate;

	private $sTitle;
	private $sFileTmpPathFront;
	private $sFileTmpPathBack;
	private $sFileNameFront;
	private $sFileNameBack;

	public function __construct($db_object, $template_object, $lang_array, $used_lang_array, $id=null, $is_admin=false)
	{
		parent::__construct($db_object, $template_object, $lang_array, $used_lang_array, $is_admin);
		$this->iId = is_numeric($id) ? $id : null;
		$this->bIsPrivate = (isset($_SESSION['user_id']) && is_numeric($_SESSION['user_id'])) ? true : false;
	}

	public function SetPage($actual_page)
	{
		$this->iActualPage = $actual_page;
	}

	public function SetOrder($order_by)
	{
		$this->sOrderBy = $order_by;
	}

	public function LoadData()
	{
		if($this->iId){
			if(!$this->LoadDB()){
				$this->sErrorMsg = $this->aLng['error_loading_product_db'];
				return false;
			}
			$this->aDescription = $this->LoadLNGFiles();
		} else {
			$this->aDescription = $this->LoadLNGFiles(true);
		}

		return true;
	}


	public function SetTitle($title){
		$this->sTitle = $title;
	}


	public function Show()
	{

		if($this->bIsAdmin==true){

			if($this->bFormSaved){
				$this->sMsg=$this->aLng['product_saved'];
			}

			if(!$this->iId){
				$paramsA = array("path"=>IMG_PRODUCTS_URL."/blank.gif");
				$paramsB = array("path"=>IMG_PRODUCTS_URL."/blank.gif");
			} else {

				$edit_scenes = "scene_list.php?id=$this->iId";

				if(is_file(IMG_PRODUCTS_DIR."/".$this->iId."_preview.jpg")){
					$paramsA = array("path"=>IMG_PRODUCTS_URL."/".$this->iId."_preview.jpg");
				} else {
					$paramsA = array("path"=>IMG_PRODUCTS_URL."/blank.gif");
				}

				if(is_file(IMG_PRODUCTS_DIR."/".$this->iId."_back_thumb.jpg")){
					$paramsB = array("path"=>IMG_PRODUCTS_URL."/".$this->iId."_back_thumb.jpg");
				} else {
					$paramsB = array("path"=>IMG_PRODUCTS_URL."/blank.gif");
				}
			}
			$front_cover = $this->roTemplate->ParseRow("img.tpl", $paramsA);
			$back_cover = $this->roTemplate->ParseRow("img.tpl", $paramsB);


			// producers list option
			$query = "SELECT id, name FROM ".TBL_PRODUCERS." ORDER BY name ASC";
			$data = $this->roDB->GetArray($query);
			if (!is_array($data) || $this->roDB->GetLastErrorMsg())
			{
				$this->sError = $this->aLng['error_loading_producer_db'];
				return false;
			}
			$producers = "";
			foreach($data as $row){
				list($id, $name) = $row;
				$params = array(
				'id'=>$id,
				'name'=>$name,
				'selected'=> ($this->iProducerId==$id) ? "selected=\"selected\"" : ""
				);
				$producers .= $this->roTemplate->ParseRow("product_producer_option.tpl", $params)."\n";
			}


			// categories list checkboxes
			$query = "SELECT id FROM ".TBL_CATEGORIES." ORDER BY id ASC";
			$data = $this->roDB->GetColumn($query);
			if (!is_array($data) || $this->roDB->GetLastErrorMsg())
			{
				$this->sError = $this->aLng['error_loading_category_db'];
				return false;
			}

			$cat_ids = null;
			if($this->aCategories){
				$cat_ids = $this->aCategories;
			} else {
				if($this->iId){
					$query = "SELECT categories_id FROM ".TBL_CATEGORIES_HAS_PRODUCTS." WHERE products_id=$this->iId";
					$cat_ids = $this->roDB->GetColumn($query);
					if (!is_array($cat_ids) || $this->roDB->GetLastErrorMsg())
					{
						$this->sError = $this->aLng['error_loading_category_db'];
						return false;
					}
				}
			}


			$counter=1;
			$sVideoCategory = "";
			$categories = "";
			foreach($data as $id){
				$params = array(
				'id'=>$id,
				'name'=>$this->aLng['category_'.$id],
				'checked'=>""
				);

				if($cat_ids){
					if( in_array($id, $cat_ids)){
						$params['checked']="checked";
					}
				}
				$sVideoCategory .= $this->roTemplate->ParseRow("product_category_checkbox.tpl", $params);
				if(($counter % 3 == 0)||(count($data)==$counter)){
					$categories .= "<tr>".$sVideoCategory."</tr>\n";
					$sVideoCategory = "";
				}
				$counter++;
			}


			$descriptions = "";
			foreach ($this->aDescription as $index=>$value){
				$params = array(
				'lang'=>$index,
				'description'=>$value
				);
				$descriptions .= $this->roTemplate->ParseRow("product_form_description.tpl", $params);
			}


			$time = $this->iReleasedDate ? $this->iReleasedDate : time();
			$sDayHTMLcode = CreateOption(date("d", $time),1,31);
			$sMonthHTMLcode = CreateOption(date("m", $time),1,12);
			$sYearHTMLcode = CreateOption(date("Y", $time),2006,MAX_RELEASED_YEAR);


			if ($this->sErrorMsg){
				$params = array("msg"=>$this->sErrorMsg);
				$status_error = $this->roTemplate->ParseRow("status_error.tpl", $params);
			} else {
				$status_error = "";
			}

			if ($this->sMsg){
				$params = array("msg"=>$this->sMsg);
				$status_ok = $this->roTemplate->ParseRow("status_ok.tpl", $params);
			} else {
				$status_ok = "";
			}


			$params = array(
			"status_error"=>$status_error,
			"status_ok"=>$status_ok,
			'id'=>$this->iId,
			'name'=>$this->sName,
			'selected_0'=>($this->iActive==0)?"selected=\"selected\"":"",
			'selected_1'=>($this->iActive==1)?"selected=\"selected\"":"",
			'categories'=>"<table>".$categories."</table>",
			'descriptions'=>$descriptions,
			'producers'=>$producers,
			'price'=>$this->iPrice,
			'selected_normal'=>($this->iAvailability==0)?"selected=\"selected\"":"",
			'selected_premium'=>($this->iAvailability==1)?"selected=\"selected\"":"",
			'stock_count'=>$this->iStockCount,
			'discount'=>$this->iDiscount,
			'front_cover'=>$front_cover,
			'back_cover'=>$back_cover,
			'day'=>$sDayHTMLcode,
			'month'=>$sMonthHTMLcode,
			'year'=>$sYearHTMLcode,
			'file_tmp_name_front'=>$this->sFileTmpPathFront,
			'file_name_front'=>$this->sFileNameFront,
			'file_tmp_name_back'=>$this->sFileTmpPathBack,
			'file_name_back'=>$this->sFileNameBack,
			);

			$this->roTemplate->AddContent("product_form.tpl", $params);

		} else {

			$this->LoadData();

			if($this->iDiscount){
				$this->sName = $this->sName." (-".($this->iDiscount/100)."%)";
				$this->iPrice = $this->iPrice * ((100-($this->iDiscount/100))/100);
			}

			$query = "SELECT name FROM ".TBL_PRODUCERS." WHERE id=$this->iProducerId";
			$producer_name = $this->roDB->GetOne($query);
			if ($this->roDB->GetLastErrorMsg()){
				return false;
			}

			// products's categories
			$categories = $this->LoadCategories();
			$CategoriesHTMLcode = "";
			$counter = 1;
			if(!is_array($categories)){
				$CategoriesHTMLcode = "";
			} else {
				foreach($categories as $id)
				{
					$separator = ($counter==count($categories)) ? "" : ", ";

					$params = array(
					'path'=>"category.php?id=".$id,
					'category_name'=>$this->aLng['category_'.$id],
					'separator'=>$separator,
					);

					$CategoriesHTMLcode .= $this->roTemplate->ParseRow("product_list_row_category.tpl", $params);
					$counter++;
				}
			}

			$img_path = is_file(IMG_PRODUCTS_DIR."/".$this->iId."_preview.jpg") ? IMG_PRODUCTS_URL."/".$this->iId."_preview.jpg" : IMG_PRODUCTS_URL."/blank.gif";

			$path_front = is_file(IMG_PRODUCTS_DIR."/".$this->iId."_front_main.jpg") ? IMG_PRODUCTS_URL."/".$this->iId."_front_main.jpg" : "";
			$path_back =  is_file(IMG_PRODUCTS_DIR."/".$this->iId."_back_main.jpg") ? IMG_PRODUCTS_URL."/".$this->iId."_back_main.jpg" : "";

			$front = "";
			$back = "";

			if($path_front || $path_back){

				if($path_front){
					$params = array(
					'path'=>"javascript: openPopup('img_popup.php?img_path=$path_front');",
					'name'=>$this->aLng['front'],
					);
					$front = $this->roTemplate->ParseRow("product_cover_link.tpl", $params);
				}

				if($path_back){
					$params = array(
					'path'=>"javascript: openPopup('img_popup.php?img_path=$path_back');",
					'name'=>$this->aLng['back'],
					);
					$back = $this->roTemplate->ParseRow("product_cover_link.tpl", $params);
				}

				$params = array(
				'path_front'=>$front,
				'path_back'=>$back,
				'separator'=>($path_front && $path_back) ? "|" : "",
				);

				$CoverHTMLcode = $this->roTemplate->ParseRow("product_cover.tpl", $params);

			} else {
				$CoverHTMLcode = "";
			}

			if(($this->bIsPrivate)&&($this->iStockCount>0)){
				$params = array('product_id'=>$this->iId);
				$order = $this->roTemplate->parseRow("order_form.tpl",$params);
			} else {
				$order = "";
			}

			if($_SESSION['currency'] != DEFAULT_CURRENCY){
				$this->iPrice = round($this->iPrice / kurzNBS($_SESSION['currency']), 2);
			}

			$params = array(
			'name'=>$this->sName,
			'img_path'=>$img_path,
			'producer'=>"<a href=\"producer.php?id=$this->iProducerId\">".$producer_name."</a>",
			'categories'=>$CategoriesHTMLcode,
			'availability'=>($this->iAvailability==0) ? $this->aLng['standard'] : $this->aLng['premium'],
			'stock'=>$this->iStockCount>0 ? $this->iStockCount : 0,
			'price'=>$this->iPrice,
			'description'=>$this->aLng['product_'.$this->iId],
			'cover'=>$CoverHTMLcode,
			'date'=>date("d.m.Y", $this->iReleasedDate),
			'order'=>$order,
			);

			$this->roTemplate->AddContent("product.tpl", $params);
		}

		return true;
	}




	public function LoadDB()
	{
		$query = "SELECT name,producers_id,added_date,released_date,price,availability,stock_count,active,is_editors_pick,has_img,discount FROM ".TBL_PRODUCTS." WHERE id=$this->iId";
		$row = $this->roDB->GetRow($query);
		if($this->roDB->GetLastErrorMsg()){
			return false;
		}

		list(
		$this->sName,
		$this->iProducerId,
		$this->iAddedDate,
		$this->iReleasedDate,
		$this->iPrice,
		$this->iAvailability,
		$this->iStockCount,
		$this->iActive,
		$this->iIsEditorsPick,
		$this->iHasImg,
		$this->iDiscount,
		) = $row;

		return true;
	}


	public function ProcessForm($post,$files)
	{
		$form_errors = 0;

		$this->iId = $post['id'];

		if(isset($post['del_front'])){
			if(!$this->iId){
				$this->LoadData();
				return false;
			}
			$this->DeletePicture();
			$this->LoadData();
			return true;
		}

		if(isset($post['del_back'])){
			if(!$this->iId){
				$this->LoadData();
				return false;
			}
			$this->DeletePicture(false);
			$this->LoadData();
			return true;
		}

		$this->sName = $post['name'];
		$this->iProducerId = $post['producer_id'];
		$this->aDescription = $post['description'];
		$this->iActive = $post['active'];
		$this->iPrice = $post['price'];
		$this->iAvailability = $post['availability'];
		$this->iStockCount = $post['stock_count'];
		$this->iDiscount = $post['discount'];

		$this->sFileNameFront = $post['file_name_front'];
		$this->sFileTmpPathFront = $post['file_tmp_name_front'];
		$this->sFileNameBack = $post['file_name_back'];
		$this->sFileTmpPathBack = $post['file_tmp_name_back'];

		if(isset($post['category'])){
			$this->aCategories = $post['category'];
		}

		$day = $post['day'];
		$month = $post['month'];
		$year = $post['year'];

		$this->iReleasedDate = mktime(0,0,0,$month,$day,$year);

		if (!$this->sName)
		{
			$this->sErrorMsg .= "<li>" . $this->aLng['error_missing_product_name'] . "</li>";
			$form_errors++;
		}

		if (!$this->aCategories)
		{
			$this->sErrorMsg .= "<li>" . $this->aLng['error_missing_product_category'] . "</li>";
			$form_errors++;
		}


		if (!$this->iPrice)
		{
			$this->sErrorMsg .= "<li>" . $this->aLng['error_missing_product_price'] . "</li>";
			$form_errors++;
		}


		if((!is_numeric($this->iDiscount)) || (strlen($this->iDiscount)>4)){
			$this->sErrorMsg .= "<li>" . $this->aLng['error_incorrect_discount'] . "</li>";
			$form_errors++;
		}

		if((!is_numeric($this->iStockCount)) || (strlen($this->iStockCount)>4)){
			$this->sErrorMsg .= "<li>" . $this->aLng['error_incorrect_stock_count'] . "</li>";
			$form_errors++;
		}


		if(!checkdate($month, $day, $year)){
			$this->sErrorMsg .= "<li>" . $this->aLng['error_invalid_date'] . "</li>";
			$form_errors++;
		}

		if ($form_errors > 0){
			$this->sErrorMsg = "<ul>" . $this->sErrorMsg . "</ul>";
			$this->InputFile($files,true);
			$this->InputFile($files,false);
			return false;
		}


		if(!$this->SaveData()){
			return false;
		} else {
			$this->bFormSaved = true;
		}

		if ($files["front"]["error"] == UPLOAD_ERR_OK)
		{
			$mime = $files["front"]["type"];
			if( !(($mime=="image/jpeg") || ($mime=="image/pjpeg")) ) {
				$this->sErrorMsg= $this->aLng['incorrect_image_type'];
				return false;
			}
			$tmp_file = $files["front"]["tmp_name"];
			$this->AddPicture($tmp_file, true);
		}

		if ($files["back"]["error"] == UPLOAD_ERR_OK)
		{
			$mime = $files["back"]["type"];
			if( !(($mime=="image/jpeg") || ($mime=="image/pjpeg")) ) {
				$this->sErrorMsg= $this->aLng['incorrect_image_type'];
				return false;
			}
			$tmp_file = $files["back"]["tmp_name"];
			$this->AddPicture($tmp_file, false);
		}

		return true;
	}

	private function SaveData()
	{
		if ($this->iId){
			if(!$this->UpdateDB()){
				$this->sErrorMsg = $this->aLng['error_updating_category_db'];
				return false;
			}
		} else {
			if(!$this->InsertDB()){
				$this->sErrorMsg = $this->aLng['error_inserting_category_db'];
				return false;
			}
		}

		return $this->UpdateLNGFiles();
	}

	private function DeletePicture($is_front=true){

		if($is_front){
			$suffixes = array("_thumb", "_preview", "_main", "_front_main", "_front_orig");
		} else {
			$suffixes = array("_back_thumb", "_back_main", "_back_orig");
		}


		foreach ($suffixes as $suffix){
			$file = IMG_PRODUCTS_DIR . "/". $this->iId . $suffix . ".jpg";
			if (is_file($file) && !@unlink($file)){
				return false;
			}
		}

		if($is_front){
			$this->UpdateHasImgDB(0);
		}

		return true;

	}

	private function InputFile($files, $is_front)
	{
		$name = $is_front==true ? "front" : "back";

		if ($files[$name]["error"] == UPLOAD_ERR_OK)
		{
			$mime = $files[$name]["type"];
			if( (($mime=="image/jpeg") || ($mime=="image/pjpeg")) ) {
				if($is_front==true){
					$this->sFileTmpPathFront = $files[$name]['tmp_name'];
					$this->sFileNameFront = $files[$name]['name'];
				} else {
					$this->sFileTmpPathBack = $files[$name]['tmp_name'];
					$this->sFileNameBack = $files[$name]['name'];
				}
				return true;
			}
		}
	}

	private function AddPicture($file,$is_front)
	{
		$upload_dir = IMG_PRODUCTS_DIR;

		if(!makeDir($upload_dir))
		{
			$this->sErrorMsg= $this->aLng['no_rights_to_upload_dir'];
			return false;
		}

		$suffix = ($is_front==true) ? "_front_orig" : "_back_orig";

		$upload_file = $upload_dir ."/".$this->iId.$suffix.".jpg";

		if (!move_uploaded_file($file, $upload_file))
		{
			return false;
		}

		chmod($upload_file, IMAGE_CHMOD);

		if($is_front==true){
			$this->ImageHandle($upload_dir, $upload_file);
			if($this->iHasImg!=1){
				$this->UpdateHasImgDB(1);
			}
		} else {
			$this->ImageHandle($upload_dir, $upload_file, false);
		}


		return true;
	}

	private function UpdateHasImgDB($value)
	{
		$query = "UPDATE ".TBL_PRODUCTS." SET has_img=$value WHERE id=$this->iId";
		$this->roDB->Update($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}


	public function ImageHandle($upload_dir, $upload_file, $is_front=true)
	{
		$image = new MmImagick();
		$image->SetDebug(true);
		if (false == $image->OpenImage($upload_file)){
			return false;
		}

		if($is_front==false){
			// generate thumbnail
			$new_back_thumb = $upload_dir . '/' . $this->iId. '_back_thumb.jpg';
			if (!$image->GenerateThumbnail(MAX_PRODUCTS_THUMB_WIDTH, MAX_PRODUCTS_THUMB_HEIGHT, $new_back_thumb)){
				return false;
			}
			chmod($new_back_thumb, IMAGE_CHMOD);

			// generate back main
			$new_back_main = $upload_dir . '/' . $this->iId. '_back_main.jpg';
			if (!$image->GenerateThumbnail(MAX_PRODUCTS_SCREENSHOT_WIDTH, MAX_PRODUCTS_SCREENSHOT_HEIGHT, $new_back_main)){
				return false;
			}
			chmod($new_back_main, IMAGE_CHMOD);

			return true;
		}

		// generate thumbnail
		$new_thumb = $upload_dir . '/' . $this->iId. '_thumb.jpg';
		if (!$image->GenerateThumbnail(MAX_PRODUCTS_THUMB_WIDTH, MAX_PRODUCTS_THUMB_HEIGHT, $new_thumb)){
			return false;
		}
		chmod($new_thumb, IMAGE_CHMOD);

		// generate preview
		$new_preview = $upload_dir . '/' . $this->iId. '_preview.jpg';
		if (!$image->GenerateThumbnail(MAX_PRODUCTS_PREVIEW_WIDTH, MAX_PRODUCTS_PREVIEW_HEIGHT, $new_preview)){
			return false;
		}
		chmod($new_preview, IMAGE_CHMOD);

		// generate home
		$new_home = $upload_dir . '/' . $this->iId. '_main.jpg';
		if (!$image->GenerateThumbnail(MAX_PRODUCTS_MAIN_WIDTH, MAX_PRODUCTS_MAIN_HEIGHT, $new_home)){
			return false;
		}
		chmod($new_preview, IMAGE_CHMOD);

		
		// generate front main
		$new_front_main = $upload_dir . '/' . $this->iId. '_front_main.jpg';
		if (!$image->GenerateThumbnail(MAX_PRODUCTS_SCREENSHOT_WIDTH, MAX_PRODUCTS_SCREENSHOT_HEIGHT, $new_front_main)){
			return false;
		}
		chmod($new_front_main, IMAGE_CHMOD);

		return true;
	}

	private function LoadCategories(){
		$query = "SELECT c.id FROM ".TBL_CATEGORIES." c,".TBL_CATEGORIES_HAS_PRODUCTS." x WHERE c.id=x.categories_id AND x.products_id=$this->iId";
		return $this->roDB->GetColumn($query);
	}



	public function DeleteData()
	{
		if (!$this->iId){
			return false;
		}

		$this->LoadDB();
		$this->UpdateLNGFiles(true);
		$this->DeleteHasTablesDB();
		$this->DeletePicture();
		$this->DeletePicture(false);
		if(!$this->DeleteDB()){
			$this->sErrorMsg = $this->aLng['error_deleting_product_db'];
			return false;
		}

		return true;
	}

	public function UpdateIsEditorsPickDB($value)
	{
		if (!$this->iId){
			return false;
		}
		$query = "UPDATE ".TBL_PRODUCTS." SET is_editors_pick=$value WHERE id=$this->iId";
		$this->roDB->Update($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}


	private function DeleteDB()
	{
		$query = "DELETE FROM ".TBL_PRODUCTS." WHERE id=$this->iId";
		$this->roDB->Delete($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		} else {
			return true;
		}
	}


	private function InsertDB()
	{

		$query = "INSERT INTO ".TBL_PRODUCTS." (name,producers_id,added_date,released_date,price,availability,stock_count,active,discount) VALUES
		(
		'".$this->roDB->MakeSecureString($this->sName)."',
		'".$this->iProducerId."',
		'".time()."',
		'".$this->iReleasedDate."',
		'".$this->iPrice."',
		'".$this->iAvailability."',
		'".$this->iStockCount."',
		'".$this->iActive."',
		'".$this->iDiscount."'
		)";
		$this->roDB->Insert($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}

		$query = "SELECT id FROM ".TBL_PRODUCTS." ORDER BY id DESC LIMIT 1";
		$this->iId = $this->roDB->GetOne($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}

		$this->UpdateHasTablesDB();

		return true;

	}


	private function UpdateDB()
	{
		$query = "UPDATE ".TBL_PRODUCTS." SET
		name='".$this->roDB->MakeSecureString($this->sName)."',
		producers_id='".$this->iProducerId."',
		released_date='".$this->iReleasedDate."',
		price='".$this->iPrice."',
		availability='".$this->iAvailability."',
		stock_count='".$this->iStockCount."',
		active='".$this->iActive."',
		discount='".$this->iDiscount."'
		WHERE id=$this->iId";
		$this->roDB->Update($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}

		$this->DeleteHasTablesDB();

		$this->UpdateHasTablesDB();

		return true;
	}


	private function DeleteHasTablesDB()
	{
		$query = "DELETE FROM ".TBL_CATEGORIES_HAS_PRODUCTS." WHERE products_id=$this->iId";
		$this->roDB->Delete($query);
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}

	}

	private function UpdateHasTablesDB()
	{
		foreach ($this->aCategories as $id){
			$query = "INSERT INTO ".TBL_CATEGORIES_HAS_PRODUCTS." VALUES ($id, $this->iId)";
			$this->roDB->Insert($query);
		}
		if ($this->roDB->GetLastErrorMsg()){
			return false;
		}
	}


	private function LoadLNGFiles($empty=false)
	{
		$result = array();
		foreach ($this->aUsedLng as $lng)
		{
			if($empty==true){
				$result[$lng] = "";
			} else {
				include(LNG_DIR."/$lng/products.php");
				$index = "product_".$this->iId;
				$result[$lng] = $_LNG[$index];
			}
		}
		return $result;
	}


	private function UpdateLNGFiles($delete=false)
	{
		$index = "product_".$this->iId;

		foreach ($this->aUsedLng as $lng)
		{
			$content = "";
			include(LNG_DIR."/$lng/products.php");
			if($delete==true){
				unset($_LNG[$index]);
			} else {
				$_LNG[$index] = $this->aDescription[$lng];
			}
			$content .="<?php \n";

			foreach ($_LNG as $key=>$value){
				$content .='$_LNG[\''.$key.'\'] = "'.$value.'";'."\n";
			}
			$content .= "?>";

			file_put_contents(LNG_DIR."/$lng/products.php", $content);
		}

		return true;
	}
}
?>
