<?php

abstract class DB_Base
{
    protected   $bIsPersistent = false;
    protected   $hLink = null;
    protected   $bDebug = false;
    public      $iNumRows = null;
    public      $iNumColumns = null;
    public      $iAffectedRows = null;
    public      $sErrorMsg = null;
    protected   $sDbHost = null;
    protected   $sDbName = null;
    protected   $sDbUser = null;
    protected   $sDbPasswd = null;
    protected   $sConnString = null;
    protected   $sQuery = null;
    public      $sLogFile = null;
    private     $bAllowCache = false;
    private     $oCacheObject = null;
    protected   $bIsConnected = false;
    protected   $sEncoding = "utf8";
    protected   $bLogQueries = false;
    protected   $sQueryLog = "";
    protected 	$sSocket	= "";
    protected 	$iPort	= null;
           
    public function __construct($params)
    {
        $this->sDbHost          = isset($params['HOST']) ? $params['HOST'] : null;
        $this->sDbUser          = isset($params['LOGIN']) ? $params['LOGIN'] : null;
        $this->sDbPasswd        = isset($params['PASSWORD']) ? $params['PASSWORD'] : null;
        $this->sConnString      = isset($params['CONN_STRING']) ? $params['CONN_STRING'] : null;
        $this->bIsPersistent    = isset($params['PERSISTENT']) ? $params['PERSISTENT'] : null;
        $this->sEncoding        = isset($params['ENCODING']) ? $params['ENCODING'] : null;
        $this->sSocket			= isset($params['SOCKET']) ? $params['SOCKET'] : null;
        $this->iPort			= isset($params['PORT']) ? $params['PORT'] : null;
    }
    
   
    public function SetCache($cache, $cache_object = null)
    {
        $this->bAllowCache = $cache;
        if (true == $this->bAllowCache)
        {
            if (!is_object($cache_object))
                throw new Exception("Cache object not initialized in DB_Base::SetCache on line ".__LINE__);
            $this->oCacheObject =& $cache_object;
        }
    }

    public function SetDebug($debug)
    {
        $this->bDebug = $debug;
    }
    
    public function SetQueryLog($status=false, $filename)
    {
        $this->bLogQueries  = $status;
        $this->sQueryLog    = $filename;
    }

	public function SetLogFile($file)
	{
        $this->sLogFile = $file;
        return true;
	}

	public function GetLastErrorMsg()
	{
		return $this->sErrorMsg;
	}

	public function ClearError()
	{
	    $this->sErrorMsg = null;
	}

    protected function HandleError($error_text)
    {
        $this->sErrorMsg = $error_text;
        $log_line = date("d M Y H:i:s") . "\nQUERY: " . $this->sQuery . "\nERRMSG: " . $error_text . "\nFILE: " . $_SERVER['PHP_SELF'] . "\n". $_SERVER['REMOTE_ADDR'] . "\n\n";
        if ($this->bDebug)
        {
            echo $log_line;
        }
        if ($this->sLogFile)
        {
            $log_file = $this->sLogFile;
            if (("Error code -1:" == substr($error_text, 0, 14)) ||
                ("Error code 2013:" == substr($error_text, 0, 16))
                )
            {
                $log_file = $this->sLogFile.".tmp";
            }

            if (false == @error_log($log_line, 3, $log_file) && true == $this->bDebug)
            {
                echo "Error writing to log " . $log_file . ".";
            }
        }
        return true;
    }
    
	public function IsConnected()
	{
		return $this->bIsConnected;
	}
	
	public static function MakeSecureString($string, $remove_html=true)
	{
	    if ($remove_html)
	    {
            $string = str_replace("<", "&lt;", $string);
            $string = str_replace(">", "&gt;", $string);
	    }

        return $string;
	}
    
    abstract public function Connect();
    abstract public function SelectScheme($db_scheme);
    abstract public function Close();
    abstract public function GetNumRows();
    abstract public function GetNumAffected();
    
    private function ReturnResult($query, $cache_key, $cache_time, $function, $group = "default")
    {
        if (true == $this->bAllowCache && null != $cache_key)
        {
            if (false === $result = $this->oCacheObject->Get($cache_key, $cache_time, $group))
            {
                $result = $this->$function($query);
                $this->oCacheObject->Put($cache_key, $result, $cache_time, $group);
            }
            $this->iNumRows = count($result);
        }
        else
        {
            $result = $this->$function($query);
        }
        return $result;
    }
    
    public function ClearCache($cache_key)
    {
        if ($this->bAllowCache)
            $this->oCacheObject->Delete($cache_key);
        return true;
    }
    
    public function ClearCacheGroup($group="default")
    {
        if ($this->bAllowCache)
            $this->oCacheObject->Clean($group);
        return true;
    }
    
    public function GetArray($query, $cacheKey = null, $cacheTime = 300, $group="default")
    {
        return $this->ReturnResult($query, $cacheKey, $cacheTime, "GetArrayLive", $group);
    }
    
    abstract protected function GetArrayLive($query);

    public function GetRow($query, $cacheKey = null, $cacheTime = 300, $group="default")
    {
        return $this->ReturnResult($query, $cacheKey, $cacheTime, "GetRowLive", $group);
    }

    abstract protected function GetRowLive($query);
    
    public function GetColumn($query, $cacheKey = null, $cacheTime = 300, $group="default")
    {
        return $this->ReturnResult($query, $cacheKey, $cacheTime, "GetColumnLive", $group);
    }
    
    abstract protected function GetColumnLive($query);
    
    public function GetOne($query, $cacheKey = null, $cacheTime = 300, $group="default")
    {
        return $this->ReturnResult($query, $cacheKey, $cacheTime, "GetOneLive", $group);
    }

    abstract protected function GetOneLive($query);
    abstract public  function Insert($query);
    abstract public  function Update($query);
    abstract public  function Delete($query);
    abstract public  function Execute($query);
    
    protected function MakeQuery($query)
    {
        if ($this->bLogQueries && $this->sQueryLog)
        {
            $log_query = str_replace("\n", " ", $query);
            $log_line = time()."###".serialize($log_query)."\n";
            @error_log($log_line, 3, $this->sQueryLog);
        }
    }
}

?>
