function LinesClass(links, config,canvas) {
    this.links = links;
    var straightLinks = Array();
    var sideLinks = Array();

    this.createLinks = function () {
        createLinksFromLinks();
    }

    function createLinksFromLinks() {
        // rozdelenie linike a nacitanie ich do poli
        separateLinksByDirection();
        createStraightLines(editStraightLinks(straightLinks));
        createSideLines(editSideLinks(sideLinks));
    }

    function createStraightLines(straightLinks) {
        var diagonal = d3.svg.diagonal();

        // sipky na konci ciary
        canvas.append("svg:defs").selectAll("marker")
        .data(["suit", "licensing", "resolved"])
        .enter().append("svg:marker")
        .attr("id", String)
        .attr("viewBox", "0 -5 10 10")
        .attr("markerWidth", config.marker.width)
        .attr("markerHeight", config.marker.height)
        .attr("orient", "auto")
        .append("svg:path")
        .attr("d", "M0,-5L10,0L0,5");

        canvas.selectAll(".link")
        .data(straightLinks)
        .enter()
        .append("path")
        .attr("class", "link")
        .attr("stroke", "blue")
        .attr("stroke-width", 2)
        .attr("fill", "none")
        .attr("d", diagonal)
            .attr("marker-end", function (d) { //pridanie sipok
                return "url(#licensing)";
            });
        }

    // zmenenie lajny y aby sedela sipka
    function editStraightLinks(straightLinks){
        var editedLinks = new Array();
        editedLinks = deepCopyLinks(straightLinks);
        editedLinks.forEach(function(link){
            if(link.target.class == "if ifis" || link.target.class == "if ifgoto"){
                link.target.y = link.target.y - config.shapes.height - config.marker.height*2;
            } else {
                link.target.y = link.target.y - config.shapes.height/2 - config.marker.height*2;
            }
        });
        return editedLinks;
    }

    function createSideLines(sideLinks) {
        var gap = 0;
        var leftLines = [];
        var rightLines = [];
        var res = divideSideLinesToRightLeft(sideLinks);
        leftLines = res[0];
        rightLines = res[1];

        rightLines.sort(function(a,b){ return b.target.x - a.target.x});
        for (var index in rightLines) {
            var link = rightLines[index];
            var righterNode;
            if(link.source.x > link.target.x)  righterNode = link.source; else righterNode = link.target;
            if(gap == 0) gap = righterNode.x + config.shapes.width/8; //vypocet bocnej medzeri hlavnej
            var lineData = [
            { "x": link.source.x, "y": link.source.y},
            { "x": gap + config.lines.nextLineGap*(parseInt(index)), "y": link.source.y},
            { "x": gap + config.lines.nextLineGap*(parseInt(index)), "y": link.target.y},
            { "x": link.target.x, "y": link.target.y}
            ];
            canvas.append("path")
            .attr("class", "link")
            .attr("stroke", "blue")
            .attr("stroke-width", 2)
            .attr("fill", "none")
            .attr("d", lineFunction(lineData))
            //pridanie sipok
            .attr("marker-end", function (d) { 
                return "url(#licensing)";
            });
        }

        leftLines.sort(function(a,b){ return b.target.x - a.target.x});
        var gap = 0;
        for (var index in leftLines) {
            var link = leftLines[index];
            var lefterNode;
            if(link.source.x < link.target.x)  lefterNode = link.source; else lefterNode = link.target;
            if(gap == 0) gap = lefterNode.x - config.shapes.width/2 - config.shapes.width/8; //vypocet bocnej medzeri hlavnej
            var lineData2 = [
            { "x": link.source.x, "y": link.source.y},
            { "x": gap - config.lines.nextLineGap*(parseInt(index)), "y": link.source.y},
            { "x": gap - config.lines.nextLineGap*(parseInt(index)), "y": link.target.y},
            { "x": link.target.x - config.shapes.width - 22, "y": link.target.y}
            ];

            canvas.append("path")
            .attr("class", "link")
            .attr("stroke", "blue")
            .attr("stroke-width", 2)
            .attr("fill", "none")
            .attr("d", lineFunction(lineData2))
                .attr("marker-end", function (d) { //pridanie sipok
                    return "url(#licensing)";
                });
            }
        }



    //rozdelenie bocnych ciar na prave a lave
    function divideSideLinesToRightLeft(sideLinks){
        var leftLines = [];
        var rightLines = [];
        var dividedLines = [];

        for (var i = 0; i < sideLinks.length; i++) {
            if(sideLinks[i].source.class.indexOf("ifis") > -1){
                rightLines.push(sideLinks[i]);
                dividedLines.push(i);
            }
            if(sideLinks[i].source.parent.class.indexOf("ifis") > -1){
                leftLines.push(sideLinks[i]);
                dividedLines.push(i);
            }
        };
         //rozdelenie hran ifis a jeho dietata
         for (var i = 0; i < sideLinks.length; i++) {
            if(dividedLines.indexOf(i) < 0){
               if(getActualCountOfSideLinkInVertex(leftLines, rightLines, sideLinks[i]) > 0 ){
                rightLines.push(sideLinks[i]);
                dividedLines.push(i);              
            } else if(getActualCountOfSideLinkInVertex(leftLines, rightLines, sideLinks[i]) == 0){
                if(rightLines.length > leftLines.length){
                    leftLines.push(sideLinks[i]);
                    dividedLines.push(i);
                } else {
                    rightLines.push(sideLinks[i]);
                    dividedLines.push(i);
                }
            } else {
                leftLines.push(sideLinks[i]);
                dividedLines.push(i);
            }
        }
    };
    return [leftLines, rightLines];
}

    //vypocita kolko hran uz ide do daneho bodu
    function getActualCountOfSideLinkInVertex(leftLines, rightLines, link){
        var leftLinesCount = 0;
        var rightLinesCount = 0;
        for (var i = 0; i < leftLines.length; i++) {
            if(leftLines[i].source.id == link.source.id || 
                leftLines[i].source.id == link.target.id ||
                leftLines[i].target.id == link.source.id ||
                leftLines[i].target.id == link.target.id){
                leftLinesCount++;
        }
    }
    for (var i = 0; i < rightLines.length; i++) {
        if(rightLines[i].source.id == link.source.id || 
            rightLines[i].source.id == link.target.id ||
            rightLines[i].target.id == link.source.id ||
            rightLines[i].target.id == link.target.id){
            rightLinesCount++;
    }
}
return leftLinesCount - rightLinesCount;
}

    // zmenenie lajny y aby sedela sipka
    function editSideLinks(sideLinks){
        var editedLinks = new Array();
        editedLinks = deepCopyLinks(sideLinks);
        editedLinks.forEach(function(link){
            link.target.x = link.target.x + config.shapes.width/2 + config.marker.width*2;
        });
        return editedLinks;
    }

    var lineFunction = d3.svg.line()
    .x(function (d) {
        return d.x;
    })
    .y(function (d) {
        return d.y;
    })
    .interpolate("Linear");

    function separateLinksByDirection() {
        for (index in links) {
            if (links[index].source.depth < links[index].target.depth &&
                links[index].target.depth - links[index].source.depth == 1) {
                straightLinks.push(links[index]);
        } else {
            sideLinks.push(links[index]);
        }
    }
}

function deepCopyLinks(links){
    var newLinks = new Array();
    links.forEach(function(link){
        var obj = new Object();
        obj.source = $.extend({}, link.source);
        obj.target = $.extend({}, link.target);
        newLinks.push(obj);
    });
    return newLinks;
}
}