function NodesClass(nodes, canvas, config) {
    var nodes = nodes;
    var canvas = canvas;
    var config = config;

    this.createNodes = function () {
        config.shapes.width = 7*this.getWidthOfLabels(nodes);
        var nodeGroup = addNodesToCanvas();
        appendShapesToNodes(nodeGroup);
        appendTextToNodes(nodeGroup);
        return [nodeGroup,config];
    }

    function addNodesToCanvas(){
        var nodeGroup = canvas.selectAll("g.node")
            .data(nodes)
            .enter()
            .append("svg:g")
            .attr("class", function(d){ return "node "+ d.class; })
            .attr("transform", function (d) {
                if(d.class != "if ifgoto" && d.class != "if ifis") {
                    return "translate(" + (d.x - config.shapes.width/2).toString() + "," + (d.y - config.shapes.height/2).toString() + ")";
                } else {
                    return "translate(" + (d.x).toString() + "," + (d.y - Math.sqrt(2*Math.pow(config.shapes.height,2))/2).toString() + ")";
                }
            });
        return nodeGroup;
    }

    function appendShapesToNodes(nodeGroup) {
        d3.selectAll(".begin").append("svg:rect")
            .attr("rx", config.rect.rx)
            .attr("ry", config.rect.ry)
            .attr("data-id", function(d){
                return d.id;
            })
            .attr("width", config.shapes.width)
            .attr("height", config.shapes.height);
        d3.selectAll(".end").append("svg:rect")
            .attr("rx", config.rect.rx)
            .attr("ry", config.rect.ry)
            .attr("data-id", function(d){
                return d.id;
            })
            .attr("width", config.shapes.width)
            .attr("height", config.shapes.height);
        d3.selectAll(".is").append("svg:rect")
            .attr("width", config.shapes.width)
            .attr("data-id", function(d){
                return d.id;
            })
            .attr("height", config.shapes.height);
        d3.selectAll(".if").append("svg:polygon")
            .attr("points", function(d){
                return config.shapes.width/2 + "," + config.shapes.height + " "
                    + "0," + config.shapes.height*2
                    + -config.shapes.width/2 + "," + config.shapes.height + " "
                    + "0,0";
            })
            .attr("data-id", function(d){
                return d.id;
            })
            .attr("transform", "translate(0,-10)");
    }

    function appendTextToNodes(nodeGroup) {
        var textSize = "1em";
        d3.selectAll(".begin").append("svg:text")
            .attr("text-anchor","middle")
            .attr("color", "black")
            .attr("font-size", textSize)
            .text(function(d){ return "(" + d.id + ") " + d.text; })
            .attr("transform", function (d) {
                return "translate(" + (config.shapes.width/2).toString() + "," + (config.shapes.height/2 + this.getBBox().height/3).toString() + ")";
            });
        d3.selectAll(".end").append("svg:text")
            .attr("text-anchor","middle")
            .attr("color", "black")
            .attr("font-size", textSize)
            .text(function(d){ return "(" + d.id + ") " + d.text; })
            .attr("transform", function (d) {
                return "translate(" + (config.shapes.width/2).toString() + "," + (config.shapes.height/2 + this.getBBox().height/3).toString() + ")";
            });
        d3.selectAll(".is").append("svg:text")
            .attr("text-anchor","middle")
            .attr("color", "black")
            .attr("font-size", textSize)
            .text(function(d){ return "(" + d.id + ") " + d.text; })
            .attr("transform", function (d) {
                return "translate(" + (config.shapes.width/2).toString() + "," + (config.shapes.height/2 + this.getBBox().height/3).toString() + ")";
            });
        d3.selectAll(".if").append("svg:text")
            .attr("text-anchor","middle")
            .attr("color", "black")
            .attr("font-size", textSize)
            .text(function(d){ return "(" + d.id + ") " + d.text; })
            .attr("transform", function (d) {
                return "translate(" + 0 + "," + (Math.sqrt(2*Math.pow(config.shapes.height,2))/2 + this.getBBox().height/3).toString() + ")";
            });
        //pridanie + - pri if
        d3.selectAll(".ifgoto").append("svg:text")
            .attr("text-anchor","middle")
            .attr("color", "black")
            .attr("font-size", textSize)
            .text(function(d){ return "+" })
            .attr("transform", function (d) {
                return "translate(" + (config.shapes.width/2 - 20) + "," + (Math.sqrt(2*Math.pow(config.shapes.height,2))/2 + this.getBBox().height/3).toString() + ")";
            });
        d3.selectAll(".ifgoto").append("svg:text")
            .attr("text-anchor","middle")
            .attr("color", "black")
            .attr("font-size", textSize)
            .text(function(d){ return "-" })
            .attr("transform", function (d) {
                return "translate(" + 0 + "," + (Math.sqrt(2*Math.pow(config.shapes.height,2))/2 + this.getBBox().height/3 + (config.shapes.height - 10)).toString() + ")";
            });
        d3.selectAll(".ifis").append("svg:text")
            .attr("text-anchor","middle")
            .attr("color", "black")
            .attr("font-size", textSize)
            .text(function(d){ return "-" })
            .attr("transform", function (d) {
                return "translate(" + (config.shapes.width/2 - 20) + "," + (Math.sqrt(2*Math.pow(config.shapes.height,2))/2 + this.getBBox().height/3).toString() + ")";
            });
        d3.selectAll(".ifis").append("svg:text")
            .attr("text-anchor","middle")
            .attr("color", "black")
            .attr("font-size", textSize)
            .text(function(d){ return "+" })
            .attr("transform", function (d) {
                return "translate(" + (-20).toString() + "," + (Math.sqrt(2*Math.pow(config.shapes.height,2))/2 + this.getBBox().height/3 + (config.shapes.height - 15)).toString() + ")";
            });
    }

    this.getWidthOfLabels = function(nodes){
        var maxWidth = 0;
        nodes.forEach(function(node){
            if(maxWidth < node.text.length){
                maxWidth = node.text.length;
            }
        });
        return maxWidth;
    }
}




