function TreeLayoutClass(config){
    var config = config;

    function init(){
        var tree = d3.layout.tree()
            .nodeSize([30,40])
            .size([config.middleColumn.width - config.treeMargin, config.middleColumn.height - config.treeMargin])
            .separation(function(a, b) { return (a.parent == b.parent ? 1 : 2); })
            .children(function(d)
            {
                return (!d.contents || d.contents.length === 0) ? null : d.contents;
            });
        return tree;
    }

    this.getNodes = function(treeData){
        var tree = init();
        return tree.nodes(treeData);
    }

    this.getLines = function(nodes){
        var tree = init();
        return tree.links(nodes);
    }
}