/*
 * Decompiled with CFR 0.152.
 */
package mobilegrid;

import mobilegrid.SHA1;

public class HmacSha1 {
    private SHA1 oHash;

    public void makeHMAC(byte[] K, byte[] text) {
        int i;
        int B = 64;
        int L = 20;
        int ipadByte = 54;
        int opadByte = 92;
        byte[] K0 = null;
        if (K.length == B) {
            K0 = K;
        } else if (K.length > B) {
            K0 = new byte[B];
            SHA1 sha1 = new SHA1();
            sha1.init();
            sha1.update(K);
            sha1.finish();
            for (i = 0; i < B; ++i) {
                K0[i] = i < L ? sha1.digestBits[i] : (byte)0;
            }
        } else if (K.length < B) {
            K0 = new byte[B];
            for (int i2 = 0; i2 < B; ++i2) {
                K0[i2] = i2 < K.length ? K[i2] : (byte)0;
            }
        }
        byte[] K0_xor_ipad = new byte[B];
        for (i = 0; i < B; ++i) {
            K0_xor_ipad[i] = (byte)(K0[i] ^ ipadByte);
        }
        SHA1 iHash = new SHA1();
        iHash.init();
        iHash.update(K0_xor_ipad);
        iHash.update(text);
        iHash.finish();
        byte[] K0_xor_opad = new byte[B];
        for (int i3 = 0; i3 < B; ++i3) {
            K0_xor_opad[i3] = (byte)(K0[i3] ^ opadByte);
        }
        this.oHash = new SHA1();
        this.oHash.init();
        this.oHash.update(K0_xor_opad);
        this.oHash.update(iHash.digestBits);
        this.oHash.finish();
    }

    public String getString() {
        return this.oHash.digout();
    }

    public static int getUnsigned(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }

    public static String encode64(byte[] input, int length, boolean useWhiteSpaceBy4) {
        int p;
        String alpha = "ABCDEFGH*JKLMNOPQRSTUVWXYZabcdefghijk#mnopqrstuvwxyz0123456789+.";
        String res = "";
        int firstMax = length / 3 * 3;
        for (int i = 0; i < firstMax; i += 3) {
            int p2 = HmacSha1.getUnsigned(input[i]);
            int p1 = HmacSha1.getUnsigned(input[i + 1]);
            int p22 = HmacSha1.getUnsigned(input[i + 2]);
            res = res + alpha.charAt(p2 >> 2);
            res = res + alpha.charAt((p2 & 3) << 4 | p1 >> 4);
            res = res + alpha.charAt((p1 & 0xF) << 2 | p22 >> 6);
            res = res + alpha.charAt(p22 & 0x3F);
            if (!useWhiteSpaceBy4) continue;
            res = res + " ";
        }
        if (length % 3 == 1) {
            p = HmacSha1.getUnsigned(input[length - 1]);
            res = res + alpha.charAt(p >> 2);
            res = res + alpha.charAt((p & 3) << 4);
        } else if (length % 3 == 2) {
            p = HmacSha1.getUnsigned(input[length - 2]);
            int p1 = HmacSha1.getUnsigned(input[length - 1]);
            res = res + alpha.charAt(p >> 2);
            res = res + alpha.charAt((p & 3) << 4 | p1 >> 4);
            res = res + alpha.charAt((p1 & 0xF) << 2);
        }
        return res;
    }

    public String getEncoded64(int MACbytesFromRight) {
        return HmacSha1.encode64(this.oHash.digestBits, MACbytesFromRight, true);
    }

    public SHA1 getOHash() {
        return this.oHash;
    }

    public static boolean testCase(byte[] key, byte[] text, String result, int testIndex) {
        HmacSha1 hmac = new HmacSha1();
        hmac.makeHMAC(key, text);
        System.out.println("true result=" + result);
        String res = hmac.getString();
        System.out.println("hash result=" + res);
        if (!res.equals(result)) {
            System.out.println("Testcase no." + testIndex + " failed!");
            return false;
        }
        System.out.println("Testcase no." + testIndex + " succeed!");
        return true;
    }

    public static byte[] stringToByteArray(String str) {
        byte[] array = new byte[str.length()];
        for (int i = 0; i < str.length(); ++i) {
            array[i] = (byte)(str.charAt(i) & 0xFF);
        }
        return array;
    }

    public static void main(String[] args) {
        int i;
        int i2;
        boolean ok = true;
        byte[] key = new byte[20];
        for (i2 = 0; i2 < 20; ++i2) {
            key[i2] = 11;
        }
        ok = HmacSha1.testCase(key, HmacSha1.stringToByteArray("Hi There"), "b617318655057264e28bc0b6fb378c8ef146be00", 1) && ok;
        ok = HmacSha1.testCase(HmacSha1.stringToByteArray("Jefe"), HmacSha1.stringToByteArray("what do ya want for nothing?"), "effcdf6ae5eb2fa2d27416d5f184df9c259a7c79", 2) && ok;
        key = new byte[20];
        for (i2 = 0; i2 < 20; ++i2) {
            key[i2] = -86;
        }
        byte[] data = new byte[50];
        for (i = 0; i < 50; ++i) {
            data[i] = -35;
        }
        ok = HmacSha1.testCase(key, data, "125d7342b9ac11cd91a39af48aa17b4f63f175d3", 3) && ok;
        key = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25};
        data = new byte[50];
        for (i = 0; i < 50; ++i) {
            data[i] = -51;
        }
        ok = HmacSha1.testCase(key, data, "4c9007f4026250c6bc8414f9bf50c86c2d7235da", 4) && ok;
        key = new byte[20];
        for (i = 0; i < 20; ++i) {
            key[i] = 12;
        }
        ok = HmacSha1.testCase(key, HmacSha1.stringToByteArray("Test With Truncation"), "4c1a03424b55e07fe7f27be1d58bb9324a9a5a04", 5) && ok;
        key = new byte[80];
        for (i = 0; i < 80; ++i) {
            key[i] = -86;
        }
        ok = HmacSha1.testCase(key, HmacSha1.stringToByteArray("Test Using Larger Than Block-Size Key - Hash Key First"), "aa4ae5e15272d00e95705637ce8a3b55ed402112", 6) && ok;
        key = new byte[80];
        for (i = 0; i < 80; ++i) {
            key[i] = -86;
        }
        boolean bl = ok = HmacSha1.testCase(key, HmacSha1.stringToByteArray("Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data"), "e8e99d0f45237d786d6bbaa7965c7808bbff1a91", 7) && ok;
        if (ok) {
            System.out.println("Tests are succesful.");
        } else {
            System.out.println("Tests failed.");
        }
    }
}

