/*
 * Decompiled with CFR 0.152.
 */
package mobilegrid;

public final class SHA1 {
    private int[] state = new int[5];
    private long count = 0L;
    public byte[] digestBits;
    public boolean digestValid;
    private int[] block = new int[16];
    private int blockIndex;
    int[] dd = new int[5];

    public SHA1() {
        this.state = new int[5];
        if (this.block == null) {
            this.block = new int[16];
        }
        this.digestBits = new byte[20];
        this.digestValid = false;
    }

    public synchronized void update(byte[] input, int offset, int len) {
        for (int i = 0; i < len; ++i) {
            this.update(input[i + offset]);
        }
    }

    public synchronized void update(byte[] input) {
        this.update(input, 0, input.length);
    }

    public void updateASCII(String input) {
        int len = input.length();
        for (int i = 0; i < len; ++i) {
            byte x = (byte)(input.charAt(i) & 0xFF);
            this.update(x);
        }
    }

    final int rol(int value, int bits) {
        int q = value << bits | value >>> 32 - bits;
        return q;
    }

    final int blk0(int i) {
        this.block[i] = this.rol(this.block[i], 24) & 0xFF00FF00 | this.rol(this.block[i], 8) & 0xFF00FF;
        return this.block[i];
    }

    final int blk(int i) {
        this.block[i & 0xF] = this.rol(this.block[i + 13 & 0xF] ^ this.block[i + 8 & 0xF] ^ this.block[i + 2 & 0xF] ^ this.block[i & 0xF], 1);
        return this.block[i & 0xF];
    }

    final void R0(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + ((data[w] & (data[x] ^ data[y]) ^ data[y]) + this.blk0(i) + 1518500249 + this.rol(data[v], 5));
        data[w] = this.rol(data[w], 30);
    }

    final void R1(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + ((data[w] & (data[x] ^ data[y]) ^ data[y]) + this.blk(i) + 1518500249 + this.rol(data[v], 5));
        data[w] = this.rol(data[w], 30);
    }

    final void R2(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + ((data[w] ^ data[x] ^ data[y]) + this.blk(i) + 1859775393 + this.rol(data[v], 5));
        data[w] = this.rol(data[w], 30);
    }

    final void R3(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + (((data[w] | data[x]) & data[y] | data[w] & data[x]) + this.blk(i) + -1894007588 + this.rol(data[v], 5));
        data[w] = this.rol(data[w], 30);
    }

    final void R4(int[] data, int v, int w, int x, int y, int z, int i) {
        int n = z;
        data[n] = data[n] + ((data[w] ^ data[x] ^ data[y]) + this.blk(i) + -899497514 + this.rol(data[v], 5));
        data[w] = this.rol(data[w], 30);
    }

    void transform() {
        this.dd[0] = this.state[0];
        this.dd[1] = this.state[1];
        this.dd[2] = this.state[2];
        this.dd[3] = this.state[3];
        this.dd[4] = this.state[4];
        this.R0(this.dd, 0, 1, 2, 3, 4, 0);
        this.R0(this.dd, 4, 0, 1, 2, 3, 1);
        this.R0(this.dd, 3, 4, 0, 1, 2, 2);
        this.R0(this.dd, 2, 3, 4, 0, 1, 3);
        this.R0(this.dd, 1, 2, 3, 4, 0, 4);
        this.R0(this.dd, 0, 1, 2, 3, 4, 5);
        this.R0(this.dd, 4, 0, 1, 2, 3, 6);
        this.R0(this.dd, 3, 4, 0, 1, 2, 7);
        this.R0(this.dd, 2, 3, 4, 0, 1, 8);
        this.R0(this.dd, 1, 2, 3, 4, 0, 9);
        this.R0(this.dd, 0, 1, 2, 3, 4, 10);
        this.R0(this.dd, 4, 0, 1, 2, 3, 11);
        this.R0(this.dd, 3, 4, 0, 1, 2, 12);
        this.R0(this.dd, 2, 3, 4, 0, 1, 13);
        this.R0(this.dd, 1, 2, 3, 4, 0, 14);
        this.R0(this.dd, 0, 1, 2, 3, 4, 15);
        this.R1(this.dd, 4, 0, 1, 2, 3, 16);
        this.R1(this.dd, 3, 4, 0, 1, 2, 17);
        this.R1(this.dd, 2, 3, 4, 0, 1, 18);
        this.R1(this.dd, 1, 2, 3, 4, 0, 19);
        this.R2(this.dd, 0, 1, 2, 3, 4, 20);
        this.R2(this.dd, 4, 0, 1, 2, 3, 21);
        this.R2(this.dd, 3, 4, 0, 1, 2, 22);
        this.R2(this.dd, 2, 3, 4, 0, 1, 23);
        this.R2(this.dd, 1, 2, 3, 4, 0, 24);
        this.R2(this.dd, 0, 1, 2, 3, 4, 25);
        this.R2(this.dd, 4, 0, 1, 2, 3, 26);
        this.R2(this.dd, 3, 4, 0, 1, 2, 27);
        this.R2(this.dd, 2, 3, 4, 0, 1, 28);
        this.R2(this.dd, 1, 2, 3, 4, 0, 29);
        this.R2(this.dd, 0, 1, 2, 3, 4, 30);
        this.R2(this.dd, 4, 0, 1, 2, 3, 31);
        this.R2(this.dd, 3, 4, 0, 1, 2, 32);
        this.R2(this.dd, 2, 3, 4, 0, 1, 33);
        this.R2(this.dd, 1, 2, 3, 4, 0, 34);
        this.R2(this.dd, 0, 1, 2, 3, 4, 35);
        this.R2(this.dd, 4, 0, 1, 2, 3, 36);
        this.R2(this.dd, 3, 4, 0, 1, 2, 37);
        this.R2(this.dd, 2, 3, 4, 0, 1, 38);
        this.R2(this.dd, 1, 2, 3, 4, 0, 39);
        this.R3(this.dd, 0, 1, 2, 3, 4, 40);
        this.R3(this.dd, 4, 0, 1, 2, 3, 41);
        this.R3(this.dd, 3, 4, 0, 1, 2, 42);
        this.R3(this.dd, 2, 3, 4, 0, 1, 43);
        this.R3(this.dd, 1, 2, 3, 4, 0, 44);
        this.R3(this.dd, 0, 1, 2, 3, 4, 45);
        this.R3(this.dd, 4, 0, 1, 2, 3, 46);
        this.R3(this.dd, 3, 4, 0, 1, 2, 47);
        this.R3(this.dd, 2, 3, 4, 0, 1, 48);
        this.R3(this.dd, 1, 2, 3, 4, 0, 49);
        this.R3(this.dd, 0, 1, 2, 3, 4, 50);
        this.R3(this.dd, 4, 0, 1, 2, 3, 51);
        this.R3(this.dd, 3, 4, 0, 1, 2, 52);
        this.R3(this.dd, 2, 3, 4, 0, 1, 53);
        this.R3(this.dd, 1, 2, 3, 4, 0, 54);
        this.R3(this.dd, 0, 1, 2, 3, 4, 55);
        this.R3(this.dd, 4, 0, 1, 2, 3, 56);
        this.R3(this.dd, 3, 4, 0, 1, 2, 57);
        this.R3(this.dd, 2, 3, 4, 0, 1, 58);
        this.R3(this.dd, 1, 2, 3, 4, 0, 59);
        this.R4(this.dd, 0, 1, 2, 3, 4, 60);
        this.R4(this.dd, 4, 0, 1, 2, 3, 61);
        this.R4(this.dd, 3, 4, 0, 1, 2, 62);
        this.R4(this.dd, 2, 3, 4, 0, 1, 63);
        this.R4(this.dd, 1, 2, 3, 4, 0, 64);
        this.R4(this.dd, 0, 1, 2, 3, 4, 65);
        this.R4(this.dd, 4, 0, 1, 2, 3, 66);
        this.R4(this.dd, 3, 4, 0, 1, 2, 67);
        this.R4(this.dd, 2, 3, 4, 0, 1, 68);
        this.R4(this.dd, 1, 2, 3, 4, 0, 69);
        this.R4(this.dd, 0, 1, 2, 3, 4, 70);
        this.R4(this.dd, 4, 0, 1, 2, 3, 71);
        this.R4(this.dd, 3, 4, 0, 1, 2, 72);
        this.R4(this.dd, 2, 3, 4, 0, 1, 73);
        this.R4(this.dd, 1, 2, 3, 4, 0, 74);
        this.R4(this.dd, 0, 1, 2, 3, 4, 75);
        this.R4(this.dd, 4, 0, 1, 2, 3, 76);
        this.R4(this.dd, 3, 4, 0, 1, 2, 77);
        this.R4(this.dd, 2, 3, 4, 0, 1, 78);
        this.R4(this.dd, 1, 2, 3, 4, 0, 79);
        this.state[0] = this.state[0] + this.dd[0];
        this.state[1] = this.state[1] + this.dd[1];
        this.state[2] = this.state[2] + this.dd[2];
        this.state[3] = this.state[3] + this.dd[3];
        this.state[4] = this.state[4] + this.dd[4];
    }

    public void init() {
        this.state[0] = 1732584193;
        this.state[1] = -271733879;
        this.state[2] = -1732584194;
        this.state[3] = 271733878;
        this.state[4] = -1009589776;
        this.count = 0L;
        this.digestBits = new byte[20];
        this.digestValid = false;
        this.blockIndex = 0;
    }

    public synchronized void update(byte b) {
        int mask = 8 * (this.blockIndex & 3);
        this.count += 8L;
        int n = this.blockIndex >> 2;
        this.block[n] = this.block[n] & ~(255 << mask);
        int n2 = this.blockIndex >> 2;
        this.block[n2] = this.block[n2] | (b & 0xFF) << mask;
        ++this.blockIndex;
        if (this.blockIndex == 64) {
            this.transform();
            this.blockIndex = 0;
        }
    }

    public void finish() {
        int i;
        byte[] bits = new byte[8];
        for (i = 0; i < 8; ++i) {
            bits[i] = (byte)(this.count >>> (7 - i) * 8 & 0xFFL);
        }
        this.update((byte)-128);
        while (this.blockIndex != 56) {
            this.update((byte)0);
        }
        this.update(bits);
        for (i = 0; i < 20; ++i) {
            this.digestBits[i] = (byte)(this.state[i >> 2] >> (3 - (i & 3)) * 8 & 0xFF);
        }
        this.digestValid = true;
    }

    public String getAlg() {
        return "SHA1";
    }

    public String digout() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 20; ++i) {
            char c1 = (char)(this.digestBits[i] >>> 4 & 0xF);
            char c2 = (char)(this.digestBits[i] & 0xF);
            c1 = (char)(c1 > '\t' ? 97 + (c1 - 10) : 48 + c1);
            c2 = (char)(c2 > '\t' ? 97 + (c2 - 10) : 48 + c2);
            sb.append(c1);
            sb.append(c2);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        SHA1 s = new SHA1();
        System.out.println("SHA-1 Test PROGRAM.");
        System.out.println("This code runs the test vectors through the code.");
        System.out.println("First test is 'abc'");
        String z = "abc";
        s.init();
        s.update((byte)97);
        s.update((byte)98);
        s.update((byte)99);
        s.finish();
        System.out.println(s.digout());
        System.out.println("A9993E36 4706816A BA3E2571 7850C26C 9CD0D89D");
        System.out.println("Next Test is 'abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq'");
        z = "abcdbcdecdefdefgefghfghighijhijkijkljklmklmnlmnomnopnopq";
        s.init();
        s.updateASCII(z);
        s.finish();
        System.out.println(s.digout());
        System.out.println("84983E44 1C3BD26E BAAE4AA1 F95129E5 E54670F1");
        System.out.println("Last test is 1 million 'a' characters.");
        s.init();
        for (int i = 0; i < 1000000; ++i) {
            s.update((byte)97);
        }
        s.finish();
        System.out.println(s.digout());
        System.out.println("34AA973C D4C4DAA4 F61EEB2B DBAD2731 6534016F");
    }
}

