#include "ChallengeValidator.h"
#include "ValServerSocket.h"
#include "logger.h"
#include <sstream>
#include <ctime>
#include <fstream>
#include <mhash.h>
#include <iomanip>
#include <algorithm>
#include <cstdlib>
using namespace std;

const unsigned int ADDITIONAL_CHALLENGE_LENGTH=4;

UserInfo::UserInfo(string mobilePassword,string mailPassword,string userName){
	this->mobilePassword=mobilePassword;
	this->mailPassword=mailPassword;
	this->userName=userName;
}

ChallengeRecord::ChallengeRecord(){
}

ChallengeRecord::ChallengeRecord(unsigned int id,long generatedTime,string challenge){
	this->generatedTime=generatedTime;
	this->challenge=challenge;	
	this->id=id;
}

long ChallengeRecord::getTime(){
	return generatedTime;
}

string ChallengeRecord::getChallenge(){
	return challenge;
}

unsigned int ChallengeRecord::getID(){
	return id;
}




string ChallengeValidator::generateChallenge(){
	unsigned char chal[ADDITIONAL_CHALLENGE_LENGTH + 4];
	long t = time(0);
	
	chal[0]=t&0xf000;
	chal[1]=t&0x0f00;
	chal[2]=t&0x00f0;
	chal[3]=t&0x000f;
	
	for(int i=0;i<ADDITIONAL_CHALLENGE_LENGTH;i++){
		chal[4+i]=rand()%256;	
	}
	
	return 	encode64(chal,ADDITIONAL_CHALLENGE_LENGTH + 4);
}

/*
	ak je 0, doslo ke preteceniu!
*/
unsigned int ChallengeValidator::generateNextID(){
	lastID++;
	return lastID;
}

ChallengeValidator::ChallengeValidator(){
	lastID=0;
	maxTimeout=60*40;
	//inicializujeme generator nah. cisel:
	srand(time(0));

}

ChallengeValidator::~ChallengeValidator(){
					
}

void ChallengeValidator::clearBuf(){
	for(int i=0;i<CHALPROT_BASIC_BUF_SIZE;i++){
		basicBuf[i]=0;
	}
}

void ChallengeValidator::start(){
	try{	
		server.startListening(port);
		while(true){
			int socket;
			server.acceptClient(socket);		
			bool closedConnection;
			try{
				clearBuf();
				log("waitData",D_GRAN_TESTING);
				server.waitData(socket,basicBuf,CHALPROT_BASIC_BUF_SIZE,closedConnection);
				if(closedConnection)continue;
				log(basicBuf,D_GRAN_TESTING);
				switch(basicBuf[0]){
					case CHALPROT_TEST:
						processTest(socket);
					break;
					case CHALPROT_REQ_CHAL_ID:
						processChallenge(socket);
					break;
					case CHALPROT_REQ_VALID_ID:
						processValidation(socket);
					break;
					default:
					break;
				}
			}catch(ValServerException &exc){
				server.closeSocket(socket);			
				continue;
			}			
			server.closeSocket(socket);			
		}
	}catch(ValServerException &exc){
		log(exc.getMsg(),D_GRAN_PRODUCTION);
	}	
}

void  ChallengeValidator::processTest(int socket){
	clearBuf();	
	stringstream s;
	s<<CHALPROT_TEST<<"ok";
	strcpy(basicBuf,s.str().c_str());
	log("processTest",D_GRAN_TESTING);
	server.sendData(socket,basicBuf,CHALPROT_BASIC_BUF_SIZE);
}

void  ChallengeValidator::processChallenge(int socket){
	clearBuf();	
	stringstream s;
	unsigned int id=generateNextID();
	ChallengeRecord rec(id,time(0),generateChallenge());
	challenges[id]=rec;
	
	s<<CHALPROT_REQ_CHAL_ID<<rec.getID()<<" "<<rec.getChallenge()<<" ";
	strcpy(basicBuf,s.str().c_str());
	log("processChallenge",D_GRAN_TESTING);
	server.sendData(socket,basicBuf,CHALPROT_BASIC_BUF_SIZE);
}

bool ChallengeValidator::loadConfig(string filename){
	ifstream inFile(filename.c_str(),ifstream::in);
    if(inFile.good()){
        string line;
        int strongerInt;
        if(!(inFile>>strongerInt))return false;
        if(strongerInt==0){
        	stronger=false;
        }else {
        	stronger=true;
        }
        if(!(inFile>>port))return false;
        if(!(inFile>>maxTimeout))return false;
        getline(inFile,line);
        while(getline(inFile,line)){
            istringstream s;
			s.str(line);
			string user;
			string pass;
			string mailPass;
			s>>user>>pass>>mailPass;
			users[user]=UserInfo(pass,mailPass,user);
			log("loaded user=",user.c_str(),D_GRAN_TESTING);
        }
        log("loaded config",D_GRAN_TESTING);
        log("timeout=",maxTimeout,D_GRAN_TESTING);
		log("#users=",users.size(),D_GRAN_PRODUCTION);
		return true;
	}else return false;
}
/*
	vrati true ak bolo timeoutovane id
*/
bool ChallengeValidator::eraseOld(unsigned int id){
	map<unsigned int,ChallengeRecord>::iterator it;	
	long t=time(0);
	bool res=false;
	for(it=challenges.begin();it!=challenges.end();it++){
		if( t  - it->second.getTime() > maxTimeout){
			if(it->second.getID()==id){
				log("timeout",D_GRAN_TESTING,D_GRAN_TESTING);
				res=true;
			}
			challenges.erase(it);	
		}
	}
	return res;
}

std::string ChallengeValidator::encode64(const unsigned char * input,int length){
	static char *alpha="ABCDEFGH*JKLMNOPQRSTUVWXYZabcdefghijk#mnopqrstuvwxyz0123456789+."; 
	string res="";
	int firstMax=length/3;
	for(int i=0;i<firstMax*3;i=i+3){
		unsigned char p=input[i];
		unsigned char p1=input[i+1];
		unsigned char p2=input[i+2];

		res+=alpha[(p>>2)];
		res+=alpha[((p&0x03)<<4)|(p1>>4)];
		res+=alpha[((p1&0x0f)<<2)|(p2>>6)];
		res+=alpha[p2&63];
	}
	if(length%3==1){
		unsigned char p=input[length-1];

		res+=alpha[p>>2];
		res+=alpha[((p&0x03)<<4)];
	}else if (length%3==2){
		unsigned char p=input[length-2];
		unsigned char p1=input[length-1];

		res+=alpha[p>>2];
		res+=alpha[((p&0x03)<<4)|(p1>>4)];
		res+=alpha[(p1&0x0f)<<2];
	}
	return res;
}

/*
	vrati false, ak user nieje!
*/
UserInfo ChallengeValidator::getUser(string user,bool &has){
	map<string,UserInfo>::iterator it;
	it=users.find(user);
	has=true;
	if(it!=users.end()){
		return it->second;	
	}
	log("user not found!,user=",user.c_str(),D_GRAN_TESTING);
	has=false;
	return UserInfo();
}

string byteToHex(int p){
	
}

bool ChallengeValidator::getHmacSha1(string challenge,string password,
	string &result,unsigned int maxLength){
	MHASH td;
    td = mhash_hmac_init(MHASH_SHA1, (void *)(password.c_str()), password.size(),
                                   mhash_get_hash_pblock(MHASH_SHA1));
	unsigned char mac[20];
    if(td==MHASH_FAILED){
    	return false;
    }
    mhash(td, (void *)(challenge.c_str()), challenge.size());
    mhash_hmac_deinit(td, mac);
    stringstream s;
	int resultLength=min(maxLength,mhash_get_block_size(MHASH_SHA1));
/*    for (int i = 0; i < resultLength; i++) {
		if(mac[i]<16){
			s<<"0";
		}
		s<<hex<<(int)mac[i];
    }*/
    if(stronger){
    	result=encode64(mac,20);
    }else{
    	result=encode64(mac,12);
    }
    return true;
}


bool ChallengeValidator::validate(unsigned int id,string &username,string &answer,string &pass,bool &wasTimeout){
	wasTimeout=false;
	if(eraseOld(id)){
		wasTimeout=true;
		return false;
	}
	
	//overenie - zistenie id		
	map<unsigned int,ChallengeRecord>::iterator it;	
	it=challenges.find(id);
	if(it==challenges.end()){
		log("ID not found!,ID=",id,D_GRAN_TESTING);	
		return false;
	}
	ChallengeRecord rec=it->second;
	challenges.erase(it);
	
	//vytiahneme heslo podla username		
	bool has;
	UserInfo info= getUser(username,has);
	if(!has)return false;
	
	//id je v poriadku, overime hmac-sha1
	string trueAns;
	if(getHmacSha1(rec.getChallenge(),info.getMobilePassword(),trueAns)){
		if(answer==trueAns){
			pass=info.getMailPassword();
			return true;
		}else{
			log("bad answer",D_GRAN_TESTING);
			log("user answer=",answer.c_str(),D_GRAN_TESTING);
			log("true answer=",trueAns.c_str(),D_GRAN_TESTING);
			return false;
		}
	}else{
		return false;	
	}
}


void ChallengeValidator::processValidation(int socket){
	log("processValidation",D_GRAN_TESTING);
	//zistenie vsetkych potrebnych parametrov:
	bool wasTimeout=false;
	try{
		//nacitanie parametrov:
		istringstream ins;
		ins.str(basicBuf);
		char p;
		unsigned int id;
		string username;
		string answer;
		if(!(ins>>p>>id>>username>>answer))throw ReadException();
/*		if(!(ins>>id))throw ReadException();
		if(!(ins>>username))throw ReadException();
		if(!(ins>>answer))throw ReadException();*/
		log("id=",id,D_GRAN_TESTING);
		log("username=",username.c_str(),D_GRAN_TESTING);
		log("answer=",answer.c_str(),D_GRAN_TESTING);
						
		string pass;
		if(!validate(id,username,answer,pass,wasTimeout))throw ReadException();
		log("authentification ok.",D_GRAN_TESTING);
		clearBuf();	
		stringstream s;
		s<<CHALPROT_REQ_CHAL_ID<<pass<<" ";
		strcpy(basicBuf,s.str().c_str());
		server.sendData(socket,basicBuf,CHALPROT_BASIC_BUF_SIZE);
	}catch(ReadException &exc){
		if(wasTimeout){
			stringstream s;
			s<<CHALPROT_REQ_VALID_ID_TIMEOUT;
			strcpy(basicBuf,s.str().c_str());
			server.sendData(socket,basicBuf,CHALPROT_BASIC_BUF_SIZE);
		}else{
			stringstream s;
			s<<CHALPROT_REQ_FAILED;
			strcpy(basicBuf,s.str().c_str());
			server.sendData(socket,basicBuf,CHALPROT_BASIC_BUF_SIZE);
		}
	}
}

