#ifndef CHALLENGE_VALIDATOR_H
#define CHALLENGE_VALIDATOR_H

#include "ValServerSocket.h"
#include "logger.h"
#include <iostream>
#include "ChallengeProtocol.h"
#include <string>
#include <map>

class ReadException{
	public:
		ReadException(){};
};

class ChallengeRecord{
	private:
		long generatedTime;	
		std::string challenge;
		unsigned int id;
	public:
		ChallengeRecord();
		ChallengeRecord(unsigned int id,long generatedTime,std::string challenge);
		long getTime();
		std::string getChallenge();
		unsigned int getID();
};

class UserInfo{
private:
	std::string mobilePassword;
	std::string mailPassword;
	std::string userName;
public:	
	UserInfo(){}
	UserInfo(std::string mobilePassword,std::string mailPassword,std::string userName);
	std::string getMobilePassword(){return mobilePassword;}
	std::string getMailPassword(){return mailPassword;}
	std::string getUserName(){return userName;}
};

class ChallengeValidator{
	
private:
	unsigned int port;
	unsigned int lastID;
	bool stronger;
	
	char basicBuf[CHALPROT_BASIC_BUF_SIZE];
	void clearBuf();
	ValServerSocket server;
	int maxTimeout;
	std::map<unsigned int,ChallengeRecord> challenges;
	std::map<std::string,UserInfo> users;
	
	
	std::string encode64(const unsigned char * input,int length);
	UserInfo getUser(std::string user,bool &has);
	bool getHmacSha1(std::string challenge,std::string password,
		std::string &result,unsigned int maxLength=20);
	bool eraseOld(unsigned int id);
	bool validate(unsigned int id,std::string &username,std::string &answer,std::string &pass,bool &wasTimeout);
	void processChallenge(int socket);
	void processValidation(int socket);
	void processTest(int socket);
	std::string generateChallenge();
	unsigned int generateNextID();
public:
	bool loadConfig(std::string filename);
	ChallengeValidator();
	~ChallengeValidator();
	void start();
};

#endif
