/*
 * HmacSha1.java
 *
 * Created on Sobota, 2007, oktber 27, 20:33
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package mobilegrid;

/**
 *
 * Vytvorene na zaklade specifikacie FIPS PUB 198
 * @author Kamil Kubon
 */
public class HmacSha1 {
    private SHA1 oHash;
    /** Creates a new instance of HmacSha1 */
    public HmacSha1() {
    }
    /*
     * K - tajny kluc medzi odosielatelom a prijimatelom
     * text - vstupny retazec
     */
    public void makeHMAC(byte[] K,byte [] text){
        /*
         *jednotlive kroky aj s popisom zodpovedaju  FIPS PUB 198 strana 4
         */
        
        int B=64;//vstupna velkost bloku do sha1
        int L=20;// velkost vystupu z sha1
        int ipadByte=0x36;
        int opadByte=0x5c;
        
        byte[] K0=null; //v krokoch 1-3 naplnime K0 
        if(K.length==B){
            //krok 1
            K0=K;
        }else if(K.length>B){
            //krok 2 
            K0=new byte[B];
            
            //zahashujeme K a ziskame prvych L bytov
            SHA1 sha1=new SHA1();
            sha1.init();
            sha1.update(K);
            sha1.finish();
            //do K0 doplnime prvych L bytov z 
            //vystupu sha1 a (B-L) bytov 0x00 
            for(int i=0;i<B;i++){
                if(i<L){
                    K0[i]=sha1.digestBits[i];
                }else{
                    K0[i]=0x00;
                }
            }
        }else if(K.length<B){
            //krok 3 
            K0=new byte[B];
            //pripojime  (B-K.length) bytov 0x00 k vstupu K
            
            for(int i=0;i<B;i++){
                if(i<K.length){
                    K0[i]=K[i];
                }else {
                    K0[i]=0x00;
                }
            }
        }
        //krok 4 
        //ziskame K0 xor ipad
        byte[] K0_xor_ipad= new byte[B];
        for(int i=0;i<B;i++){
            K0_xor_ipad[i]=(byte)(K0[i] ^ ipadByte);
        }
        //krok 5
        SHA1 iHash = new SHA1();
        iHash.init();
        iHash.update(K0_xor_ipad);
        //pripojime vstup text k K0_xor_ipad
        iHash.update(text);
        
        //krok 6 spocitame hash
        iHash.finish();
        
        //krok 7 spocitame K0 xor opad
        byte[] K0_xor_opad= new byte[B];
        for(int i=0;i<B;i++){
            K0_xor_opad[i]=(byte)(K0[i] ^ opadByte);
        }
        
        //krok 8
        oHash = new SHA1();
        oHash.init();
        //pripojenie vysledku z kroku 7
        oHash.update(K0_xor_opad);
        //pripojenie vysledku z kroku 6
        oHash.update(iHash.digestBits);
        //krok 9:
        
        oHash.finish();
        //krok 10 - ako velkost MACU ponechame L
    }
   
    public String getString(){
        return oHash.digout();
    }

    public static int getUnsigned(byte b) {
        if (b >= 0) {
            return b;
        }
        return 256 + b;
    }
    /*
     * -prehodenie do base64 s mierne upravenou abecedou(namiesto / je .)
     * -sucastou vystupu nie su znaky =
     */
    public static String encode64(byte input[], int length, boolean useWhiteSpaceBy4) {
        String alpha = "ABCDEFGH*JKLMNOPQRSTUVWXYZabcdefghijk#mnopqrstuvwxyz0123456789+.";
        String res = "";
        int firstMax = (length / 3) * 3;
        for (int i = 0; i < firstMax; i = i + 3) {
            int p = getUnsigned(input[i]);
            int p1 = getUnsigned(input[i + 1]);
            int p2 = getUnsigned(input[i + 2]);

            res += alpha.charAt(p >> 2);
            res += alpha.charAt(((p & 0x03) << 4) | (p1 >> 4));
            res += alpha.charAt(((p1 & 0x0f) << 2) | (p2 >> 6));
            res += alpha.charAt(p2 & 63);
            if (useWhiteSpaceBy4) {
                res += " ";
            }
        }
        if ((length) % 3 == 1) {
            int p = getUnsigned(input[length - 1]);

            res += alpha.charAt(p >> 2);
            res += alpha.charAt(((p & 0x03) << 4));
        } else if ((length) % 3 == 2) {
            int p = getUnsigned(input[length - 2]);
            int p1 = getUnsigned(input[length - 1]);

            res += alpha.charAt(p >> 2);
            res += alpha.charAt(((p & 0x03) << 4) | (p1 >> 4));
            res += alpha.charAt((p1 & 0x0f) << 2);
        }
        return res;
    }
    
    public String getEncoded64(int MACbytesFromRight){
       return encode64(oHash.digestBits,MACbytesFromRight,true); 
    }
    
    public SHA1 getOHash() {
        return oHash;
    }
    
    public static boolean testCase(byte[] key,byte[] text,String result,
            int testIndex){
        HmacSha1 hmac= new HmacSha1();
        hmac.makeHMAC(key, text);
        System.out.println("true result="+result);
        String res=hmac.getString();
        System.out.println("hash result="+res);
        
        if(!res.equals(result)){
            System.out.println("Testcase no."+testIndex+" failed!");  
            return false;
        }else{
            System.out.println("Testcase no."+testIndex+" succeed!");
            return true;
        }
    }
    
    public static byte[] stringToByteArray(String str){
        byte []array=new byte[str.length()];
        for(int i=0;i<str.length();i++){
            array[i]=(byte)( str.charAt(i) & 0xff);
        }
        return array;
    }
    
    public static void main(String args[]){
        //TESTOVANIE PODLA RFC 2202
        boolean ok = true;

        byte []key=new byte[20];
        for(int i=0;i<20;i++){key[i]=(byte)0x0b;}
        ok= testCase(key,stringToByteArray("Hi There"),
                "b617318655057264e28bc0b6fb378c8ef146be00",1)&&ok;
        
        ok= testCase(stringToByteArray("Jefe"),
                stringToByteArray("what do ya want for nothing?"),
                "effcdf6ae5eb2fa2d27416d5f184df9c259a7c79",2)&&ok;

        key=new byte[20];
        for(int i=0;i<20;i++){key[i]=(byte)0xaa;}
        byte []data=new byte[50];
        for(int i=0;i<50;i++){data[i]=(byte)0xdd;}
        ok=testCase(key,data,
                "125d7342b9ac11cd91a39af48aa17b4f63f175d3",3)&&ok;
        
        key=new byte[]{0x01,0x02,0x03,0x04,0x05,0x06,0x07,0x08,0x09,0x0a,0x0b,0x0c,
                0x0d,0x0e,0x0f,0x10,0x11,0x12,0x13,0x14,0x15,
                0x16,0x17,0x18,0x19};
        data=new byte[50];
        for(int i=0;i<50;i++){data[i]=(byte)0xcd;}
        ok= testCase(key,data,
                "4c9007f4026250c6bc8414f9bf50c86c2d7235da",4)&&ok;
       
        key=new byte[20];
        for(int i=0;i<20;i++){key[i]=0x0c;}
        ok= testCase(key,stringToByteArray("Test With Truncation"),
                "4c1a03424b55e07fe7f27be1d58bb9324a9a5a04",5)&&ok;
        
        key=new byte[80];
        for(int i=0;i<80;i++){key[i]=(byte)0xaa;}
        ok= testCase(key,stringToByteArray("Test Using Larger Than Block-Size Key - Hash Key First"),
                "aa4ae5e15272d00e95705637ce8a3b55ed402112",6)&&ok;

        key=new byte[80];
        for(int i=0;i<80;i++){key[i]=(byte)0xaa;}
        ok= testCase(key,stringToByteArray("Test Using Larger Than Block-Size Key and Larger Than One Block-Size Data"),
                "e8e99d0f45237d786d6bbaa7965c7808bbff1a91",7)&&ok;
        
        
       
        if (ok) {
            System.out.println("Tests are succesful.");
        } else {
            System.out.println("Tests failed.");
        }
    }
}
