<?php
define('SM_PATH','../');





/* SquirrelMail required files. */
require_once(SM_PATH . 'functions/global.php');

/*
 konstanty z protokolu:
*/

define('CHALPROT_TEST','T');
define('CHALPROT_REQ_CHAL_ID','A');
define('CHALPROT_REQ_VALID_ID','B');
define('CHALPROT_REQ_VALID_ID_OK','D');
define('CHALPROT_REQ_VALID_ID_TIMEOUT','T');
define('CHALPROT_REQ_FAILED','F');
define('CHALPROT_BASIC_BUF_SIZE',200);

function getCharEndedString(&$str,&$beginIndex,$chr){
	$res="";		
	while($str[$beginIndex]!=$chr){
		$res=$res.$str[$beginIndex];
		$beginIndex++;
	}
	return $res;
}

/*
	vytvori a ulozi challenge aj s ID-ckom
*/
function generateChallenge(){
	if(validatorSocketRequestResponse(CHALPROT_REQ_CHAL_ID,"",$response)){
		$i=1;
		
		//zistenie $challenge_id - zakoncene medzerou
		$challenge_id=getCharEndedString($response,$i,' ');
		$i++;
		//zistenie challengu - zakoncene medzerou
		$challenge=getCharEndedString($response,$i,' ');
		$i++;
		
		sqsession_register($challenge,"mb_challenge");
		sqsession_register($challenge_id,"mb_challenge_id");
		return $challenge;

	}else{
		return "";	
	}
}
function isStrongerChallenge(){
	return false;
}

/*
	vrati true, ak sa podari, inak false
*/
function authenticateUser($username,$user_answer,&$passwordForMail,&$timeout){
	sqGetGlobalVar('mb_challenge_id', $challenge_id);
	$timeout=false;
	$request=$challenge_id." ".$username." ".$user_answer;
	if(validatorSocketRequestResponse(CHALPROT_REQ_VALID_ID,$request,$response)){
		if($response[0]==CHALPROT_REQ_FAILED)return false;
		if($response[0]==CHALPROT_REQ_VALID_ID_TIMEOUT){
			$timeout=true;
			return false;
		}
		
		//navratova hodnota:
		$i=1;
		$passwordForMail=getCharEndedString($response,$i,' ');
		return true;
	}
	return false;	
}

function testChallengeValidator(){
	if(validatorSocketRequestResponse(CHALPROT_TEST,"",$res)){
		echo "challengeValidator test ok, response=".$res."<br>";
	}else{
		echo "challengeValidator test failed!";
	}
}

/*
	zrealizuje dopyt na validator
	-vracia : true/false, podla toho, ci sa operacia podarila.
	-code - parameter
*/
function validatorSocketRequestResponse($code,$str,&$response){
	$res = socket_create(AF_INET,SOCK_STREAM,SOL_TCP);
	if($res!=false){
		if(socket_connect($res,"localhost",5550)){
			$max=CHALPROT_BASIC_BUF_SIZE;
			$buf=$code.$str;
			if(strlen($buf)>$max)return false;
			$msg = str_repeat(chr(0),$max-strlen($buf));
			$buf=$buf.$msg;
			$len=socket_send  ( $res  ,  $buf  , CHALPROT_BASIC_BUF_SIZE  , 0  );
			if($len!=CHALPROT_BASIC_BUF_SIZE)return false;
			$len=socket_recv  ( $res  , $response  , CHALPROT_BASIC_BUF_SIZE  , 0);
			if($len!=CHALPROT_BASIC_BUF_SIZE)return false;
			return true;					
		}
	}
	return false;
}
?>
