function [error] = getError(esn, plotGraphs)
%UNTITLED1 Summary of this function goes here
%  Detailed explanation goes here

%plotGraphs = false;
plotGraphs = true;

nTestSeqLength = 2400;
nSeqLength = 1500;
%output = sin((1:nSeqLength) / 4) / 2;
%output = output ;

output = melodyGenerator(1:nSeqLength);
%output = sineGenerator(1:nSeqLength, 500, 20) / 2;
%output = modulatedSineGenerator(1:nSeqLength, 500, 13, 21) / 2;


%output = output - 0.3;

teacher = melodyGenerator(1:nTestSeqLength);

esn = create_esn(400, 1, 1.25, 0.908);

esn = scaling(esn, 2.0);

%figure(1);
%plot(1:50, ir(1:5, 1:50));

if (plotGraphs)
    figure(1);
    plot(teacher);
end

% train network
[nos ir esn] = train(teacher, esn);
if (plotGraphs)
    figure(2);
    plot(1:length(teacher), ir(1:10, 1:length(teacher)));
end

% test run
[nos2 ir error esn] = runNetworkWF(nTestSeqLength, teacher, 500, esn);
if (plotGraphs)
    figure(4);
    plot([nos2' teacher']);
end

[nos ir error_train esn] = getMSEtrain(nTestSeqLength, teacher, 500, esn);
[nos ir error_test esn] = getMSEtest(nTestSeqLength, teacher, 500, esn);

error_train
error_test
%error_test

