function [outputSequence internalResponse esn] = train(desiredOutput, esn)
%train postupnost inputSequence sa spracuje ako vstup siete esn.
%Vysledkom je vystupna sekvencia outputSequence, ktora zodpoveda vystupu
%siete

desiredLength = length(desiredOutput);

internalResponse = zeros(length(esn.x), desiredLength);

M = zeros(desiredLength, esn.nResUnits);
T = zeros(desiredLength, esn.nOutputs);

% collecting state and output matrices during teacher forcing
for i = 1:desiredLength
    %M(i, :) = esn.x';
    
    internalResponse(:,i) = esn.x;
    outputSequence(i) = esn.y; 
    % collect reservoir state in time x(n)
   %M(i, :) = esn.x';
    % collect desiredOutput(n)       unitFunction_inv()
   
    T(i, :) = unitFunction_inv(desiredOutput(i)); % );
    M(i, :) = esn.x';
   
    % compute reservoir state x(n + 1) and output(n + 1)
    esn.x = unitFunction(esn.resWeights * esn.x + esn.feedbackWeights * (desiredOutput(i) + whiteNoise(0.0005)));
    esn.y = unitFunction(esn.outWeights * esn.x); %);
    
    %T(i, :) = unitFunction_inv(desired(i));
    %save the i-th output to outputSequence
    
end

% compute output weights using pseudoinverse

M = M([501:(desiredLength / 2) ((desiredLength / 2) + 501):desiredLength], :);
T = T([501:(desiredLength / 2) ((desiredLength / 2) + 501):desiredLength], :);

%esn.outWeights = (pinv(M) * T)';
esn.outWeights = (T' * pinv(M'));



