function [outputSequence internalResponse error esn] = getMSEtrain(steps, input, desired, forceLength, esn)
%getMSEtrain - vypocita testovaciu chybu
%steps- pocet krokov ktore spravi siet (musi byt mensie ako dlzka postupnosti input a desired)
%input- vstupna postupnost
%desired- vystupna postupnost (pouzita na teacher-forcing a vypocet chyby)
%forceLength- kolko pociatocnych krokov siet bezi s teacher-forcingom
%esn- siet
%

internalResponse = zeros(length(esn.x), steps);
error = 0;

for i = 1:steps
     %save the n - th output to outputSequence
    internalResponse(:,i) = esn.x;
    outputSequence(i) = esn.y; 
    
    if (i <= forceLength)
        NetOut = desired(i);
    else
        NetOut = desired(i);
        error = error + (unitFunction(desired(i)) - unitFunction(esn.y))^2;
    end
    % calculate x(n + 1)
    esn.x = unitFunction(esn.inWeights * input(i, :)' +  esn.resWeights * esn.x + esn.feedbackWeights * NetOut);
    % calculate y(n + 1)
    esn.y = unitFunction(esn.outWeights * [input(i, :)'; esn.x]);
end

error = error / (steps - forceLength) ;