function [outputSequence internalResponse esn] = runNetwork(input, esn)
%runNetwork vypocita steps krokov siete
%Vysledkom je vystupna sekvencia outputSequence, ktora zodpoveda vystupu
%siete a internalResponse je odozva jednotlivych neuronov v case

inputLength = length(input);
internalResponse = zeros(length(esn.x), inputLength);

for i = 1:inputLength
     %save the n - th output to outputSequence
    internalResponse(:,i) = esn.x;
    outputSequence(i) = esn.y; 
    
    % calculate x(n + 1)
    esn.x = unitFunction(esn.inWeights * input(i, :)' +  esn.resWeights * esn.x + esn.feedbackWeights * esn.y);
    % calculate y(n + 1)
    esn.y = unitFunction(esn.outWeights * [input(i, :)'; esn.x]);
end