/*
 * Decompiled with CFR 0.152.
 */
package s3games.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import s3games.engine.Element;
import s3games.engine.ElementType;
import s3games.engine.GameRule;
import s3games.engine.GameScoring;
import s3games.engine.Location;
import s3games.engine.LocationType;
import s3games.engine.expr.Expr;
import s3games.engine.expr.Expression;
import s3games.io.Config;
import s3games.io.GameLogger;
import s3games.io.GameSpecificationParser;
import s3games.robot.CameraObjectType;

public class GameSpecification {
    public String gameName;
    public String boardBackgroundFileName;
    public Map<String, LocationType> locationTypes = new HashMap<String, LocationType>();
    public Map<String, ElementType> elementTypes = new HashMap<String, ElementType>();
    public Map<String, Element> elements = new HashMap<String, Element>();
    public Map<String, Location> locations = new HashMap<String, Location>();
    public Map<String, Expression> expressions = new HashMap<String, Expression>();
    public Map<Expr, Expr> terminationConditions = new HashMap<Expr, Expr>();
    public ArrayList<GameScoring> scorings = new ArrayList();
    public Map<String, GameRule> rules = new HashMap<String, GameRule>();
    public ArrayList<CameraObjectType> cameraObjectTypes = new ArrayList();
    public String[] playerNames;
    public int initialPlayerScore;
    private Config config;
    private GameLogger logger;

    public GameSpecification(Config config, GameLogger logger) {
        this.config = config;
        this.initialPlayerScore = 0;
    }

    public boolean load(String gameName) throws Exception {
        GameSpecificationParser parser = new GameSpecificationParser(this.config, this.logger);
        return parser.load(gameName, this);
    }

    public Location findClosestCameraLocation(int x, int y) {
        double minDist = Double.POSITIVE_INFINITY;
        Location minLoc = null;
        for (Location loc : this.locations.values()) {
            double d1;
            if (loc.camera == null || !((d1 = loc.camera.distanceSq(x, y)) < minDist)) continue;
            minDist = d1;
            minLoc = loc;
        }
        return minLoc;
    }
}

