/*
 * Decompiled with CFR 0.152.
 */
package s3games.engine.expr;

import s3games.engine.expr.Context;
import s3games.engine.expr.Expr;
import s3games.engine.expr.Expression;

class Expr_EXPRESSION_CALL
extends Expr {
    String exprName;
    Expr[] args;

    public Expr_EXPRESSION_CALL(String exprName, Expr[] args) {
        this.exprName = exprName;
        this.args = args;
    }

    void evalArgs(Context context, String[] argNames) throws Exception {
        if (this.args.length != argNames.length) {
            throw new Exception("function expects " + argNames.length + " arguments, but " + this.args.length + " provided");
        }
        for (int i = 0; i < this.args.length; ++i) {
            Expr evaluatedArg = this.args[i].eval(context);
            context.setVar(argNames[i], evaluatedArg);
        }
    }

    @Override
    public Expr eval(Context context) throws Exception {
        Expression expr = context.getExpr(this.exprName);
        if (expr == null) {
            throw new Exception("Attempt to call a non-existing function " + this.exprName);
        }
        this.evalArgs(context, expr.argNames);
        return expr.expr.eval(context);
    }
}

