/*
 * Decompiled with CFR 0.152.
 */
package s3games.engine.expr;

import java.util.Map;
import java.util.TreeMap;
import s3games.engine.expr.Context;
import s3games.engine.expr.Expr;
import s3games.engine.expr.Expr_NUM_CONSTANT;
import s3games.engine.expr.Expr_STR_CONSTANT;

class Expr_STRING_WITH_VAR_REF
extends Expr {
    String str;
    TreeMap<Integer, String> varRefs;

    public Expr_STRING_WITH_VAR_REF(String str, TreeMap<Integer, String> varRefs) {
        this.str = str;
        this.varRefs = varRefs;
    }

    @Override
    public Expr eval(Context context) throws Exception {
        StringBuilder s = new StringBuilder("");
        int pos = 0;
        for (Map.Entry<Integer, String> var : this.varRefs.entrySet()) {
            s.append(this.str.substring(pos, var.getKey()));
            s.append(context.getVar(var.getValue()).getInt());
            pos = var.getKey();
        }
        s.append(this.str.substring(pos));
        return new Expr_STR_CONSTANT(s.toString());
    }

    @Override
    public boolean matches(String s, Context context) {
        int i;
        String[] base = s.split("[0-9]+");
        String[] numbers = s.split("[^0-9]+");
        StringBuilder glued = new StringBuilder();
        if (numbers.length - 1 != this.varRefs.size()) {
            return false;
        }
        for (String b : base) {
            glued.append(b);
        }
        if (!glued.toString().equals(this.str)) {
            return false;
        }
        int pos = 0;
        int[] positions = new int[numbers.length - 1];
        for (i = 0; i < numbers.length - 1; ++i) {
            positions[i] = pos += base[i].length();
        }
        i = 0;
        for (Integer p : this.varRefs.keySet()) {
            if (p == positions[i++]) continue;
            return false;
        }
        i = 0;
        for (String v : this.varRefs.values()) {
            context.setVar(v, new Expr_NUM_CONSTANT(Integer.parseInt(numbers[++i])));
        }
        return true;
    }
}

