/*
 * Decompiled with CFR 0.152.
 */
package s3games.io;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import s3games.io.GameLogger;

public class Config
implements Serializable {
    public static final String configFileName = ".s3games.cfg";
    public static final String defaultGamesFolder = "games";
    public String gamesFolder;
    public static final String defaultImagePath = "images";
    public String imagePath;
    transient GameLogger logger;

    public Config(GameLogger logger) {
        this.logger = logger;
    }

    public void save() {
        try {
            ObjectOutputStream f = new ObjectOutputStream(new FileOutputStream(configFileName));
            f.writeObject(this);
            f.close();
        }
        catch (Exception e) {
            this.logger.warning("could not save config file to .s3games.cfg");
        }
    }

    public void load() {
        try {
            ObjectInputStream f = new ObjectInputStream(new FileInputStream(configFileName));
            Config cfg = (Config)f.readObject();
            f.close();
            this.gamesFolder = cfg.gamesFolder;
            this.imagePath = cfg.imagePath;
        }
        catch (Exception e) {
            this.logger.warning("could not load config file from '.s3games.cfg'");
            this.gamesFolder = defaultGamesFolder;
            this.imagePath = defaultImagePath;
            this.save();
        }
    }
}

