/*
 * Decompiled with CFR 0.152.
 */
package s3games.player;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import s3games.engine.GameState;
import s3games.engine.Move;
import s3games.player.AbstractMonteCarloPlayer;

public class MonteCarloRatioPlayer
extends AbstractMonteCarloPlayer {
    private double q;
    private Map<Integer, Double> winning = new HashMap<Integer, Double>();
    private Map<Integer, Double> losing = new HashMap<Integer, Double>();
    private Map<Integer, Double> other = new HashMap<Integer, Double>();

    @Override
    protected void initializeRatio() {
        this.q = 1.0;
    }

    @Override
    protected void updateRatio(GameState gs, Set<Move> moves) {
        if (gs.currentPlayer != this.number) {
            this.q *= 1.0 / (double)moves.size();
        }
    }

    @Override
    protected void initializeScore(int i) {
        this.winning.put(i, 0.0);
        this.losing.put(i, 0.0);
        this.other.put(i, 0.0);
    }

    @Override
    protected void addScore(GameState gs, int i) {
        if (gs.winner == this.number) {
            this.winning.put(i, this.winning.get(i) + this.q);
        } else if (gs.winner > 0) {
            this.losing.put(i, this.losing.get(i) + this.q);
        } else {
            this.other.put(i, this.other.get(i) + this.q);
        }
    }

    @Override
    protected double calculateScore(int i) {
        double wn = this.winning.get(i);
        double lo = this.losing.get(i);
        double ot = this.other.get(i);
        if (ot + lo + wn == 0.0) {
            return 0.0;
        }
        return (wn - lo) / (wn + lo + ot);
    }
}

