/*
 * Decompiled with CFR 0.152.
 */
package s3games.robot;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import s3games.engine.GameSpecification;
import s3games.engine.Location;
import s3games.gui.CameraWindow;
import s3games.robot.CameraObjectType;

public class Camera
implements Runnable {
    GameSpecification specs;
    CameraWindow win;
    Thread commThread;
    boolean showDebuggingMessages = false;
    ArrayList<DetectedObject> objects;
    BufferedReader in;
    PrintWriter out;
    boolean terminating = false;
    final Object notificator = new Object();
    private static final String CAMERA_PROGRAM = "/home/krtek/bakalarka/source/s3games/s3games/cameraBoard.exe";

    public Camera(GameSpecification specs) {
        this.objects = new ArrayList();
        this.specs = specs;
        this.win = new CameraWindow(this);
        this.commThread = new Thread(this);
        this.init();
    }

    private void sendObjectParametersToCamera() {
        ArrayList<CameraObjectType> params = this.specs.cameraObjectTypes;
        this.out.println("2");
        this.out.println(params.size());
        for (CameraObjectType o : params) {
            o.printTo(this.out);
        }
        this.out.flush();
    }

    private void sendLocationsToCamera() {
        this.out.println("3");
        int count = 0;
        for (Location loc : this.specs.locations.values()) {
            if (loc.camera == null) continue;
            ++count;
        }
        this.out.println(count);
        for (Location loc : this.specs.locations.values()) {
            if (loc.camera == null) continue;
            this.out.println(loc.camera.x + " " + loc.camera.y);
        }
        this.out.flush();
    }

    private void init() {
        try {
            this.win.addMessage("Connecting to camera...");
            ProcessBuilder pb = new ProcessBuilder(CAMERA_PROGRAM);
            Process p = pb.start();
            this.in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            this.out = new PrintWriter(p.getOutputStream());
            int terminated = 0;
            boolean hasTerminated = true;
            try {
                terminated = p.exitValue();
            }
            catch (IllegalThreadStateException e) {
                hasTerminated = false;
            }
            if (hasTerminated) {
                throw new Exception("The camera program has terminated with exit code " + terminated);
            }
            String header = this.in.readLine();
            if (header == null) {
                throw new Exception("Could not start talking with the camera program");
            }
            if (!header.equals("S:S3 Games Camera")) {
                throw new Exception("Camera program did not respond properly");
            }
            this.win.addMessage("Camera there. Sending object types...");
            this.sendObjectParametersToCamera();
            this.sendLocationsToCamera();
            this.commThread.start();
            Thread.sleep(700L);
        }
        catch (Exception e) {
            this.win.addMessage(e.getMessage());
        }
    }

    @Override
    public void run() {
        try {
            do {
                String ln;
                if ((ln = this.in.readLine()) == null) {
                    throw new Exception("Camera disconnected");
                }
                if (ln.charAt(0) == 'F') {
                    throw new Exception("Camera program stoped with error " + ln.substring(2));
                }
                if (ln.charAt(0) == 'D') {
                    if (!this.showDebuggingMessages) continue;
                    this.win.addMessage(ln.substring(2));
                    continue;
                }
                if (ln.charAt(0) == 'I') {
                    this.win.addMessage(ln.substring(2));
                    continue;
                }
                if (ln.charAt(0) == 'O') {
                    this.addObject(ln.substring(2));
                    continue;
                }
                if (ln.charAt(0) != '=') continue;
                this.objectsTransmitted();
            } while (!this.terminating);
            this.win.close();
        }
        catch (Exception e) {
            if (!this.terminating) {
                this.win.addMessage(e.getMessage());
            }
            e.printStackTrace();
        }
        this.win = null;
    }

    private void addObject(String objDesc) throws Exception {
        String[] obj = objDesc.split("\t");
        if (obj.length != 4) {
            throw new Exception("Camera program output error");
        }
        this.objects.add(new DetectedObject(obj[0], Integer.parseInt(obj[1]), Integer.parseInt(obj[2]), Integer.parseInt(obj[3])));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void objectsTransmitted() {
        this.win.addMessage("Received " + this.objects.size() + " objects from camera.");
        Object object = this.notificator;
        synchronized (object) {
            this.notificator.notify();
        }
    }

    public void requestObjectsFromCamera() {
        this.objects.clear();
        this.out.println("1");
        this.out.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<DetectedObject> waitForUserMove() {
        this.win.addMessage("It is your turn: move one stone and click the button below.");
        try {
            Object object = this.notificator;
            synchronized (object) {
                this.notificator.wait();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.objects;
    }

    public void msgToUser(String msg) {
        this.win.addMessage(msg);
    }

    public void close() {
        this.terminating = true;
        if (this.out != null) {
            this.out.println("0");
            this.out.flush();
        }
        this.out.close();
        try {
            Thread.sleep(2000L);
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public class DetectedObject {
        public String type;
        public int state;
        public int x;
        public int y;

        public DetectedObject(String type, int state, int x, int y) {
            this.type = type;
            this.state = state;
            this.x = x;
            this.y = y;
        }

        public String toString() {
            return this.type + "(" + this.state + ") " + this.x + " " + this.y;
        }
    }
}

