/*
 * Decompiled with CFR 0.152.
 */
package s3games.robot;

public class RobotCmd {
    private String cmdString;

    public RobotCmd(Command type, double[] angles) {
        switch (type) {
            case position: {
                this.buildPositionCommand(angles);
            }
        }
    }

    public RobotCmd(Command type) {
        switch (type) {
            case version: {
                this.cmdString = "VER";
                break;
            }
            case grab: {
                this.cmdString = "#5 P2000 T2000";
                break;
            }
            case put: {
                this.cmdString = "#5 P1000 T2000";
                break;
            }
            case query: {
                this.cmdString = "Q";
                break;
            }
            case init: {
                this.buildPositionCommand(new double[]{0.0, 0.0, 0.0, 0.0, 0.0});
                break;
            }
            case home: {
                this.buildPositionCommand(new double[]{0.0, 53.0, -76.0, -101.0, 13.0});
            }
        }
    }

    public static char responseIdle() {
        return '.';
    }

    public static char responseBusy() {
        return '+';
    }

    public String getCommand() {
        return this.cmdString;
    }

    private void buildPositionCommand(double[] angles) {
        StringBuilder result = new StringBuilder();
        result.append("#0 P");
        result.append(this.angleToPulseBase(angles[0]));
        result.append(" #1 P");
        result.append(this.angleToPulseWrist(angles[1]));
        result.append(" #2 P");
        result.append(this.angleToPulseElbow(angles[2]));
        result.append(" #3 P");
        result.append(this.angleToPulseShoulder(angles[3]));
        result.append(" #4 P");
        result.append(this.angleToPulseHand(angles[4]));
        result.append(" T3000");
        this.cmdString = result.toString();
    }

    private int angleToPulseBase(double deg) {
        int r = (int)(1500.0 + 10.0 * deg);
        if (r > 2400) {
            System.out.println("Pulse too long");
            r = 2400;
        }
        if (r < 600) {
            System.out.println("Pulse too long");
            r = 600;
        }
        return r;
    }

    private int angleToPulseWrist(double deg) {
        int r = (int)(1500.0 + 10.0 * deg);
        if (r > 2400) {
            System.out.println("Pulse too long");
            r = 2400;
        }
        if (r < 600) {
            System.out.println("Pulse too long");
            r = 600;
        }
        return r;
    }

    private int angleToPulseElbow(double deg) {
        int r = (int)(1800.0 - 10.0 * deg);
        if (r > 2400) {
            System.out.println("Pulse too long");
            r = 2400;
        }
        if (r < 900) {
            System.out.println("Pulse too long");
            r = 900;
        }
        return r;
    }

    private int angleToPulseShoulder(double deg) {
        int r = (int)(1500.0 + 10.0 * deg);
        if (r > 2400) {
            System.out.println("Pulse too long");
            r = 2400;
        }
        if (r < 600) {
            System.out.println("Pulse too long");
            r = 600;
        }
        return r;
    }

    private int angleToPulseHand(double deg) {
        int r = (int)(1500.0 + 10.0 * deg);
        if (r > 2400) {
            System.out.println("Pulse too long");
            r = 2400;
        }
        if (r < 600) {
            System.out.println("Pulse too long");
            r = 600;
        }
        return r;
    }

    public static enum Command {
        init,
        version,
        position,
        home,
        grab,
        put,
        query;

    }
}

