import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BruteForce {

	ArrayList<int[]> quadratic1_Boolean = new ArrayList<int[]>();
	ArrayList<int[]> quadratic2_Boolean = new ArrayList<int[]>();
	ArrayList<ArrayList<Pair>> quadratic1 = new ArrayList<ArrayList<Pair>>();
	ArrayList<ArrayList<Pair>> quadratic2 = new ArrayList<ArrayList<Pair>>();

	void quadratic_Init() {

		for (int i = 0; i < 12; i++) {
			for (int j = 0; j < 12; j++) {
				ArrayList<Pair> tmp_Pair = new ArrayList<Pair>();
				int[] boolean_q1 = new int[144];

				for (int k = 0; k < 12; k++) {
					boolean_q1[12 * k + i] = 1;
					boolean_q1[12 * k + j] = 1;
					Pair pair = new Pair();
					pair.pos1 = 12 * k + i;
					pair.pos2 = 12 * k + j;
					tmp_Pair.add(pair);
				}

				quadratic1_Boolean.add(boolean_q1);
				quadratic1.add(tmp_Pair);
			}
		}

		for (int i = 0; i < 12; i++) {
			for (int j = 0; j < 12; j++) {

				ArrayList<Pair> tmp_Pair = new ArrayList<Pair>();
				int[] boolean_q2 = new int[144];

				for (int k = 0; k < 12; k++) {
					boolean_q2[12 * i + k] = 1;
					boolean_q2[12 * j + k] = 1;
					Pair pair = new Pair();
					pair.pos1 = 12 * i + k;
					pair.pos2 = 12 * j + k;
					tmp_Pair.add(pair);
				}

				quadratic2_Boolean.add(boolean_q2);
				quadratic2.add(tmp_Pair);
			}
		}
	}

	boolean test_linearResolve(byte[] solution, int[][] linear_Equation, int[] vector) {

		boolean ok = true;
		for (int j = 0; j < linear_Equation.length; j++) {

			ArrayList<Integer> indexes = new ArrayList<Integer>();
			for (int k = 0; k < 144; k++) {
				if (linear_Equation[j][k] != 0) {
					indexes.add(k);
				}
			}

			boolean test = true;
			for (int k = 0; k < indexes.size(); k++) {
				if (solution[indexes.get(k)] == 2) {
					test = false;
				}
			}

			if (test) {
				int sucet = 0;
				for (int k = 0; k < indexes.size(); k++) {
					sucet += solution[indexes.get(k)] * linear_Equation[j][indexes.get(k)];
				}
				if (sucet != vector[j]) {
					ok = false;
					return false;
				}
			}
		}

		return true;
	}

	ArrayList<byte[]> linearResolve(ArrayList<byte[]> solution, int[][] linear_Equation,
			int[] vector) {

		ArrayList<byte[]> newSolution = new ArrayList<byte[]>();
		for (int i = 0; i < solution.size(); i++) {

			boolean ok = true;
			for (int j = 0; j < linear_Equation.length; j++) {

				ArrayList<Integer> indexes = new ArrayList<Integer>();
				for (int k = 0; k < 144; k++) {
					if (linear_Equation[j][k] != 0) {
						indexes.add(k);
					}
				}

				boolean test = true;
				for (int k = 0; k < indexes.size(); k++) {
					if (solution.get(i)[indexes.get(k)] == 2) {
						test = false;
					}
				}

				if (test) {
					int sucet = 0;
					for (int k = 0; k < indexes.size(); k++) {
						sucet += solution.get(i)[indexes.get(k)]
								* linear_Equation[j][indexes.get(k)];
					}
					if (sucet != vector[j]) {
						ok = false;
						break;
					}
				}
			}

			if (ok) {
				newSolution.add(solution.get(i));
			}
		}

		return newSolution;
	}

	boolean test_quadraticResolve(byte[] solution, int[][] matrixQ1, int[][] matrixQ2) {
		boolean result = true;
		boolean ok = true;
		for (int j = 0; j < quadratic1_Boolean.size(); j++) {
			ArrayList<Integer> indexes = new ArrayList<Integer>();
			for (int k = 0; k < 144; k++) {
				if (quadratic1_Boolean.get(j)[k] == 1) {
					indexes.add(k);
				}
			}

			boolean test = true;
			for (int k = 0; k < indexes.size(); k++) {
				if (solution[indexes.get(k)] == 2) {
					test = false;
				}
			}

			if (test) {
				int sucet = 0;
				for (int k = 0; k < quadratic1.get(j).size(); k++) {
					sucet += solution[quadratic1.get(j).get(k).pos1]
							* solution[quadratic1.get(j).get(k).pos2];
				}
				if (sucet != matrixQ1[j / 12][j % 12]) {
					return false;
				}
			}
		}

		boolean ok2 = true;
		for (int j = 0; j < quadratic2_Boolean.size(); j++) {

			ArrayList<Integer> indexes = new ArrayList<Integer>();
			for (int k = 0; k < 144; k++) {
				if (quadratic2_Boolean.get(j)[k] == 1) {
					indexes.add(k);
				}
			}

			boolean test = true;
			for (int k = 0; k < indexes.size(); k++) {
				if (solution[indexes.get(k)] == 2) {
					test = false;
				}
			}

			if (test) {
				int sucet = 0;
				for (int k = 0; k < quadratic2.get(j).size(); k++) {
					sucet += solution[quadratic2.get(j).get(k).pos1]
							* solution[quadratic2.get(j).get(k).pos2];
				}
				if (sucet != matrixQ2[j / 12][j % 12]) {
					return false;
				}
			}
		}

		if (ok && ok2) {
			result = true;
		}

		return true;
	}

	ArrayList<byte[]> quadraticResolve(ArrayList<byte[]> solution, int[][] matrixQ1,
			int[][] matrixQ2) {
		ArrayList<byte[]> newSolution = new ArrayList<byte[]>();

		for (int i = 0; i < solution.size(); i++) {

			boolean ok = true;
			for (int j = 0; j < quadratic1_Boolean.size(); j++) {

				ArrayList<Integer> indexes = new ArrayList<Integer>();
				for (int k = 0; k < 144; k++) {
					if (quadratic1_Boolean.get(j)[k] == 1) {
						indexes.add(k);
					}
				}

				boolean test = true;
				for (int k = 0; k < indexes.size(); k++) {
					if (solution.get(i)[indexes.get(k)] == 2) {
						test = false;
					}
				}

				if (test) {
					int sucet = 0;
					for (int k = 0; k < quadratic1.get(j).size(); k++) {
						sucet += solution.get(i)[quadratic1.get(j).get(k).pos1]
								* solution.get(i)[quadratic1.get(j).get(k).pos2];
					}
					if (sucet != matrixQ1[j / 12][j % 12]) {
						ok = false;
						break;
					}
				}
			}

			boolean ok2 = true;
			for (int j = 0; j < quadratic2_Boolean.size(); j++) {

				ArrayList<Integer> indexes = new ArrayList<Integer>();
				for (int k = 0; k < 144; k++) {
					if (quadratic2_Boolean.get(j)[k] == 1) {
						indexes.add(k);
					}
				}

				boolean test = true;
				for (int k = 0; k < indexes.size(); k++) {
					if (solution.get(i)[indexes.get(k)] == 2) {
						test = false;
					}
				}

				if (test) {
					int sucet = 0;
					for (int k = 0; k < quadratic2.get(j).size(); k++) {
						sucet += solution.get(i)[quadratic2.get(j).get(k).pos1]
								* solution.get(i)[quadratic2.get(j).get(k).pos2];
					}
					if (sucet != matrixQ2[j / 12][j % 12]) {
						ok2 = false;
						break;
					}
				}
			}

			if (ok && ok2) {
				newSolution.add(solution.get(i));
			}
		}

		return newSolution;
	}

	static ArrayList<byte[]> generuj() {
		ArrayList<byte[]> line_solution = new ArrayList<byte[]>();
		for (int i = 0; i < (1 << 12); i++) {

			byte[] tmp_solution = new byte[12];
			int pocet_jednotiek = 0;
			for (int j = 0; j < 12; j++) {
				if (((i >> j) & 1) == 1) {
					pocet_jednotiek++;
					tmp_solution[j] = 1;
				}
			}

			if (pocet_jednotiek == 6)
				line_solution.add(tmp_solution);
		}
		return line_solution;
	}

	public static void main(String[] args) throws Exception {
		long start = System.currentTimeMillis();

		Multiplication multiplication = new Multiplication();
		multiplication.getSolution();
		Graphs graphs = new Graphs();
		graphs.read();
		System.out.println("Size of matrices Q1 : " + graphs.matrices_Q1.size());
		System.out.println("Size of matrices Q2 : " + graphs.matrices_Q2.size());
		System.out.println("Size of matrices Linear Equations : " + graphs.linear_equation.size());

		System.out.println("ALL READY!");

		final BruteForce bruteForce = new BruteForce();
		ArrayList<byte[]> solution = new ArrayList<byte[]>();
		byte[] tmp_solution = new byte[144];
		bruteForce.quadratic_Init();
		final ArrayList<byte[]> tmp = generuj();
		System.out.println("Pocet generuj je: " + tmp.size());

		ArrayList<Integer> interval = new ArrayList<Integer>();

		interval.add(Integer.parseInt(args[0]));
		
		for (int it = 0; it < interval.size(); it++) {

			int sucet = 0;
			final int[][] linear = graphs.linear_equation.get(interval.get(it));
			final int[] vector = graphs.vector.get(interval.get(it));
			final int[][] matrix_Q1 = graphs.matrices_Q1.get(interval.get(it));
			final int[][] matrix_Q2 = graphs.matrices_Q2.get(interval.get(it));

			for (int i = 0; i < tmp.size(); i++) {
				tmp_solution = new byte[144];
				for (int k = 0; k < 132; k++)
					tmp_solution[k] = 2;
				for (int k = 132; k < 144; k++)
					tmp_solution[k] = tmp.get(i)[k - 132];
				//solution.add(tmp_solution);
				if ((bruteForce.test_linearResolve(tmp_solution, linear, vector))
						&& (bruteForce.test_quadraticResolve(tmp_solution, matrix_Q1, matrix_Q2))) {
					solution.add(tmp_solution);
				}
			}

			//			solution = bruteForce.linearResolve(solution, linear, vector);
			//			solution = bruteForce.quadraticResolve(solution, matrix_Q1, matrix_Q2);

			// System.out.println("predbezny pocet: " + solution.size());

			for (int miesto = 2; miesto < 13; miesto++) {
				System.out.println("BRUTEFORCE: pocet rieseni: " + solution.size()
						+ ", pocet uhadnutych premennych: " + (miesto - 1) * 12);
				final List<byte[]> newSolution = Collections
						.synchronizedList(new ArrayList<byte[]>());
				int c = 0;

				int zac = 0;
				final int threadsCount = Integer.parseInt(args[1]);
				final int inc = solution.size() / threadsCount;
				final int solutionSize = solution.size();
				Thread[] threads = new Thread[threadsCount];
				
				for (int i = 0; i < threadsCount; i++) {
					final ArrayList<byte[]> finalSolution = solution;
					final int finalMiesto = miesto;
					final int finalZac = zac;
					final int finalI = i;
					threads[i] = new Thread(new Runnable() {
						@Override
						public void run() {
							funkcia(finalZac, finalI < threadsCount - 1 ? finalZac + inc : solutionSize, tmp,
									finalSolution, finalMiesto, bruteForce, linear, vector,
									matrix_Q1, matrix_Q2, newSolution, finalI + 1);
						}
					});
					threads[i].start();
					zac += inc;
				}
				for (int i = 0; i < threadsCount; i++) {
					threads[i].join();
				}

				solution = new ArrayList<byte[]>(newSolution);
				//				System.out.println("BRUTEFORCE: overujem linearne: " + solution.size());
				//				solution = bruteForce.linearResolve(solution, linear, vector);
				//				System.out.println("BRUTEFORCE: overujem kvadraticke: " + solution.size());
				//				solution = bruteForce.quadraticResolve(solution, matrix_Q1, matrix_Q2);

			}

			sucet += solution.size();
			System.out.println("Pocet rieseni: " + sucet + " iteracia: " + interval.get(it));

			for (int l = 0; l < solution.size(); l++) {
				int[][] matica = new int[25][25];

				for (int j = 1; j < 13; j++)
					matica[0][j] = 1;
				for (int j = 1; j < 13; j++)
					matica[j][0] = 1;

				for (int j = 1; j < 13; j++) {
					for (int k = 1; k < 13; k++) {

						matica[j][k] = multiplication.a1_matrices_fixed.get(interval.get(it))[j - 1][k - 1];
					}
				}

				for (int j = 13; j < 25; j++) {
					for (int k = 13; k < 25; k++) {
						matica[j][k] = multiplication.a2_matrices.get(interval.get(it))[j - 13][k - 13];
					}
				}

				for (int j = 13; j < 25; j++) {
					for (int k = 1; k < 13; k++) {
						matica[j][k] = solution.get(l)[(j - 13) * 12 + (k - 1)];
					}
				}

				for (int j = 1; j < 13; j++) {
					for (int k = 13; k < 25; k++) {
						matica[j][k] = solution.get(l)[(k - 13) * 12 + (j - 1)];
					}
				}

				// VYPIS MATICE:
				for (int j = 0; j < 25; j++) {
					for (int k = 0; k < 25; k++) {
						System.out.print(matica[j][k]);
					}
					System.out.println();
				}

				System.out.println("------------------------------------------");

			}

		}

		long end = System.currentTimeMillis();

		System.out.println("Execution time was " + (end - start) + " ms.");

	}

	private static void funkcia(int start, int end, ArrayList<byte[]> tmp,
			ArrayList<byte[]> solution, int miesto, BruteForce bruteForce, int[][] linear,
			int[] vector, int[][] matrix_Q1, int[][] matrix_Q2, List<byte[]> newSolution, int id) {
		byte[] tmp_solution;
		for (int i = start; i < end; i++) {
			for (int j = 0; j < tmp.size(); j++) {
				tmp_solution = solution.get(i).clone();
				for (int k = 144 - miesto * 12; k < 144 - ((miesto - 1) * 12); k++)
					tmp_solution[k] = tmp.get(j)[k - (144 - miesto * 12)];
				if ((bruteForce.test_linearResolve(tmp_solution, linear, vector))
						&& (bruteForce.test_quadraticResolve(tmp_solution, matrix_Q1, matrix_Q2))) {
					newSolution.add(tmp_solution);
				}
			}
			if (i % 1000 == 0) {
				System.out.println(id + ". thread: " + (i - start) + " from " + (end - start));
			}
		}

	}
	/*
	* for (int it = 0; it < interval.size(); it++) {
		
		int sucet=0;
		int[][] linear = graphs.linear_equation.get(interval.get(it));
		int[] vector = graphs.vector.get(interval.get(it));
		int[][] matrix_Q1 = graphs.matrices_Q1.get(interval.get(it));
		int[][] matrix_Q2 = graphs.matrices_Q2.get(interval.get(it));

		for (int i = 0; i < tmp.size(); i++) {
			tmp_solution = new byte[144];
			for (int k = 0; k < 132; k++)
				tmp_solution[k] = 2;
			for (int k = 132; k < 144; k++)
				tmp_solution[k] = tmp.get(i)[k - 132];
			solution.add(tmp_solution);
		}
		
		solution = bruteForce.linearResolve(solution, linear, vector);
		solution = bruteForce.quadraticResolve(solution, matrix_Q1, matrix_Q2);

		// System.out.println("predbezny pocet: " + solution.size());

		for (int miesto = 2; miesto < 13; miesto++) {
			System.out.println("BRUTEFORCE: pocet rieseni: "+solution.size()+", pocet uhadnutych premennych: " + (miesto-1)*12);
			ArrayList<byte[]> newSolution = new ArrayList<byte[]>();

			for (int i = 0; i < solution.size(); i++) {
				for (int j = 0; j < tmp.size(); j++) {
					tmp_solution = solution.get(i).clone();
					for (int k = 144 - miesto * 12; k < 144 - ((miesto - 1) * 12); k++)
						tmp_solution[k] = tmp.get(j)[k - (144 - miesto * 12)];
					newSolution.add(tmp_solution);
				}
			}

			solution = new ArrayList<byte[]>(newSolution);
			System.out.println("BRUTEFORCE: overujem linearne: " + solution.size());
			solution = bruteForce.linearResolve(solution, linear, vector);
			System.out.println("BRUTEFORCE: overujem kvadraticke: " + solution.size());
			solution = bruteForce.quadraticResolve(solution, matrix_Q1, matrix_Q2);

		}
		
		sucet += solution.size();
		System.out.println("Pocet rieseni: " + sucet + " iteracia: " + interval.get(it));
		/*
		for(int l=0; l< solution.size(); l++){
			int[][] matica = new int[25][25];

			for(int j=1;j<13;j++) matica[0][j] = 1;
			for(int j=1;j<13;j++) matica[j][0] = 1;

			for(int j=1; j<13; j++){
				for(int k=1; k<13; k++){
					
					matica[j][k]= multiplication.a1_matrices_fixed.get(it)[j-1][k-1];
				}
			}

			for(int j=13; j<25; j++){
				for(int k=13; k<25; k++){
					matica[j][k]= multiplication.a2_matrices.get(it)[j-13][k-13];
				}
			}

			for(int j=13; j<25; j++){
				for(int k=1; k<13; k++){
					matica[j][k]= solution.get(l)[(j-13)*12 + (k-1)];
				}
			}

			for(int j=1; j<13; j++){
				for(int k=13; k<25; k++){
					matica[j][k]= solution.get(l)[(k-13)*12 + (j-1)];
				}
			}
			
			// VYPIS MATICE:
			for(int j=0;j<25;j++){
				for(int k=0;k<25;k++){
					System.out.print(matica[j][k]);
				}
				System.out.println();
			}
			
			
			System.out.println("------------------------------------------");
			
		}
		*/
}