import java.util.ArrayList;

public class Solver {

	static Multiplication multiplication;
	ArrayList<int[]> quadratic1_Boolean = new ArrayList<int[]>();
	ArrayList<int[]> quadratic2_Boolean = new ArrayList<int[]>();
	ArrayList<ArrayList<Pair>> quadratic1 = new ArrayList<ArrayList<Pair>>();
	ArrayList<ArrayList<Pair>> quadratic2 = new ArrayList<ArrayList<Pair>>();
	
	int minimum(ArrayList<Pair> indexes){
		int result = -1;
		int minimum = 999999;
		
		for(int i=0;i<indexes.size();i++){
			if (indexes.get(i).pos1 < minimum){
				result = indexes.get(i).pos2;
				minimum = indexes.get(i).pos1;
			}
		}
		
		return result;
	}
	
	ArrayList<Pair> vymaz(int index, ArrayList<Pair> indexes){
		ArrayList<Pair> new_Indexes = new ArrayList<Pair>();
		for(int i=0; i< indexes.size(); i++){
			if (indexes.get(i).pos2!=index){
				Pair tmp_Pair = new Pair();
				tmp_Pair.pos1 = indexes.get(i).pos1;
				tmp_Pair.pos2 = indexes.get(i).pos2;
				new_Indexes.add(tmp_Pair);
			}
		}
		return new_Indexes;
	}
	
	void quadratic_Init() {
		
		for (int i = 0; i < 12; i++) {
			for (int j = 0; j < 12; j++) {
				ArrayList<Pair> tmp_Pair = new ArrayList<Pair>();
				int[] boolean_q1 = new int[144];

				for (int k = 0; k < 12; k++) {
					boolean_q1[i + 12 * k] = 1;
					boolean_q1[j + 12 * k] = 1;
					Pair pair = new Pair();
					pair.pos1 = i + 12 * k;
					pair.pos2 = j + 12 * k;
					tmp_Pair.add(pair);
				}

				quadratic1_Boolean.add(boolean_q1);
				quadratic1.add(tmp_Pair);
			}
		}
				
		for (int i = 0; i < 12; i++) {
			for (int j = 0; j < 12; j++) {
				
				ArrayList<Pair> tmp_Pair = new ArrayList<Pair>();
				int[] boolean_q2 = new int[144];

				for (int k = 0; k < 12; k++) {
					boolean_q2[k + 12 * i] = 1;
					boolean_q2[k + 12 * j] = 1;
					Pair pair = new Pair();
					pair.pos1 = k + 12 * i;
					pair.pos2 = k + 12 * j;
					tmp_Pair.add(pair);
				}

				quadratic2_Boolean.add(boolean_q2);
				quadratic2.add(tmp_Pair);
			}
		}
	}	

	ArrayList<int[]> quadraticResolve(ArrayList<int[]> solution, int[][] matrixQ1, int[][] matrixQ2) {
		ArrayList<int[]> newSolution = new ArrayList<int[]>();
		for (int i = 0; i < solution.size(); i++) {

			Boolean ok = true;
			for (int j = 0; j < quadratic1_Boolean.size(); j++) {

				ArrayList<Integer> indexes = new ArrayList<Integer>();
				for (int k = 0; k < 144; k++)
					if (quadratic1_Boolean.get(j)[k] == 1)
						indexes.add(k);

				Boolean test = true;
				for (int k = 0; k < indexes.size(); k++)
					if (solution.get(i)[indexes.get(k)] == 2)
						test = false;
				
				if (test == true) {
					int sucet = 0;
					for (int k = 0; k < quadratic1.get(j).size(); k++) {
						sucet += solution.get(i)[quadratic1.get(j).get(k).pos1] * solution.get(i)[quadratic1.get(j).get(k).pos2];
					}
					
					if (sucet != matrixQ1[j / 12][j % 12]) {
						ok = false;
						break;
					}
				}
			}
			
			Boolean ok2 = true;
			for (int j = 0; j < quadratic2_Boolean.size(); j++) {

				ArrayList<Integer> indexes = new ArrayList<Integer>();
				for (int k = 0; k < 144; k++)
					if (quadratic2_Boolean.get(j)[k] == 1)
						indexes.add(k);

				Boolean test = true;
				for (int k = 0; k < indexes.size(); k++)
					if (solution.get(i)[indexes.get(k)] == 2)
						test = false;
				
				if (test == true) {
					int sucet = 0;
					for (int k = 0; k < quadratic2.get(j).size(); k++) {
						sucet += solution.get(i)[quadratic2.get(j).get(k).pos1] * solution.get(i)[quadratic2.get(j).get(k).pos2];
					}
					if (sucet != matrixQ2[j / 12][j % 12]) {
						ok2 = false;
						break;
					}
				}
			}
			
			if ((ok == true) && (ok2 == true)){
				newSolution.add(solution.get(i));
			}
		}

		return newSolution;
	}

	ArrayList<int[]> solve(int[][] linear_equation, int[] vector, int[][] matrixQ1, int[][] matrixQ2){
		quadratic_Init();
		ArrayList<int[]> solution = new ArrayList<int[]>();
		
		int[] tmp = new int[144];
		for (int i = 0; i < 144; i++){
			tmp[i] = 2;
		}
		solution.add(tmp);
		
		for(int i=0;i<linear_equation.length;i++){
			
			ArrayList<int[]> newSolution = new ArrayList<int[]>();
			ArrayList<Integer> indexes = new ArrayList<Integer>();
			ArrayList<Integer> linear_indexes = new ArrayList<Integer>();

			for (int j = 0; j < linear_equation.length; j++) {
				if ((linear_equation[i][j] != 0) && (solution.get(0)[j] == 2)){
					indexes.add(j);
				}
					
				if ((linear_equation[i][j] != 0) && (solution.get(0)[j] != 2)){
					linear_indexes.add(j);
				}
			}
			System.out.println("SOLVER: Pocet hladanych indexov: " + indexes.size());
			for (int j = 0; j < solution.size(); j++) {
				
				for (int k = 0; k < (1<<indexes.size()); k++) {
					
					int[] tmp_solution = new int[144];
					for(int l=0; l<solution.get(j).length; l++){
						tmp_solution[l] = solution.get(j)[l];
					}
					
					int sucet = 0;

					for (int l = 0; l < indexes.size(); l++) {
						if (((k >> l) & 1) == 1) {
							tmp_solution[indexes.get(l)] = 1;
							sucet += linear_equation[i][indexes.get(l)];
						}
						else {
							tmp_solution[indexes.get(l)] = 0;
						}
					}
					
					for (int l = 0; l < linear_indexes.size(); l++) {
						sucet += linear_equation[i][linear_indexes.get(l)]*solution.get(j)[linear_indexes.get(l)];
					}

					if (sucet == vector[i]) {
						newSolution.add(tmp_solution);
					}
				}
			}

			solution = new ArrayList<int[]>(newSolution);
			solution = quadraticResolve(solution, matrixQ1, matrixQ2);
			
			if (solution.size() == 0) {
				break;
				}
			else {
				System.out.println("SOLVER: Pocet predbeznych rieseni: " + solution.size()); 
			}
			 
		}
		
		solution = quadraticResolve(solution, matrixQ1, matrixQ2);
				
		return solution;
	}
	
	public static void main(String[] args) throws Exception {
		
		long start = System.currentTimeMillis();
		
		Solver solver = new Solver();
		Multiplication multiplication = new Multiplication();
		multiplication.getSolution();
		Graphs graphs = new Graphs();
		graphs.read();
		System.out.println("Size of matrices Q1 : " + graphs.matrices_Q1.size());
		System.out.println("Size of matrices Q2 : " + graphs.matrices_Q2.size());
		System.out.println("Size of matrices Linear Equations : " + graphs.linear_equation.size());

		System.out.println("ALL READY!");
		
		ArrayList<Integer> interval = new ArrayList<Integer>();
		
		interval.add(9691);
		interval.add(9712);
		interval.add(11748);
		interval.add(11753);
		interval.add(11762);
		interval.add(11763);
		interval.add(11764);
		interval.add(11765);
		interval.add(10228);
		interval.add(10327);
		interval.add(280);
		
		for(int it=0; it< interval.size();it++){
		
		ArrayList<int[]> solution = new ArrayList<int[]>();
		
		int[][] linear = graphs.linear_equation.get(interval.get(it));
		int[] vector = graphs.vector.get(interval.get(it));
		int[][] matrix_Q1 = graphs.matrices_Q1.get(interval.get(it));
		int[][] matrix_Q2 = graphs.matrices_Q2.get(interval.get(it));
		
		solution = solver.solve(linear, vector, matrix_Q1, matrix_Q2);
		
		System.out.println("Pocet rieseni je: " + solution.size() + " iteracia: "+ interval.get(it));
		
		for(int l=0; l< solution.size(); l++){
			int[][] matica = new int[25][25];

			for(int j=1;j<13;j++) matica[0][j] = 1;
			for(int j=1;j<13;j++) matica[j][0] = 1;

			for(int j=1; j<13; j++){
				for(int k=1; k<13; k++){
					
					matica[j][k]= multiplication.a1_matrices_fixed.get(it)[j-1][k-1];
				}
			}

			for(int j=13; j<25; j++){
				for(int k=13; k<25; k++){
					matica[j][k]= multiplication.a2_matrices.get(it)[j-13][k-13];
				}
			}

			for(int j=13; j<25; j++){
				for(int k=1; k<13; k++){
					matica[j][k]= solution.get(l)[(j-13)*12 + (k-1)];
				}
			}

			for(int j=1; j<13; j++){
				for(int k=13; k<25; k++){
					matica[j][k]= solution.get(l)[(k-13)*12 + (j-1)];
				}
			}
			
			// VYPIS MATICE:
			for(int j=0;j<25;j++){
				for(int k=0;k<25;k++){
					System.out.print(matica[j][k]);
				}
				System.out.println();
			}
			
			
			System.out.println("------------------------------------------");
		}
		
		}	
		long end = System.currentTimeMillis();
		System.out.println("Execution time was " + (end - start) + " ms.");
		
	}
	
	//special_Main
	/*
	 *		Solver solver = new Solver();
		Multiplication multiplication = new Multiplication();
		Graphs graphs = new Graphs();
		graphs.special_read();
		
//		//DEBUG
//		for(int i=0;i<144;i++){
//			for(int j=0; j<144;j++){
//				System.out.print(graphs.linear_equation.get(0)[i][j]);
//			}
//			System.out.println();
//		}
//		for(int i=0;i<144;i++){
//			System.out.print(graphs.vector.get(0)[i]);
//		}
//		System.out.println();
		
		System.out.println("Ready!");
		
		ArrayList<int[]> solution = solver.solve(graphs.linear_equation.get(0), graphs.vector.get(0), multiplication.getSpecialQ1(), multiplication.getSpecialQ2());
		
//		System.out.println(solution.size());
		for(int i=0; i< solution.size(); i++){
			for(int j=0; j< 12; j++){
				for(int k=0; k<12;k++){
					System.out.print(solution.get(i)[j*12 + k]);
				}
				System.out.println();
			}
			System.out.println("------------------------------");
			
		}
		
		System.out.println("Done!"); 
	*/
	

	
}
