import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.PrintStream;
import java.util.ArrayList;


public class CharacteristicPolynomial {
	
	private ArrayList<String> charPolynom = new ArrayList<String>();
	
	void setUp(String filename) throws Exception{
		BufferedReader in = new BufferedReader(new FileReader(filename));
		String line;
		while((line=in.readLine())!=null) 
			if (!("".equals(line))) charPolynom.add(line);
	}
	
	void calculate(int d, String output) throws Exception{
		PrintStream out = new PrintStream(new FileOutputStream(output));
		out.println("x_1 := Indeterminate( Integers );;");
		for(int i=0;i<charPolynom.size();i++){
			if (d==0)out.println("f := ("+charPolynom.get(i)+")/(x_1);");
			else out.println("f := ("+charPolynom.get(i)+")/(x_1-"+d+");"); 
		}
		out.close();
	}
	
	void ComplementartSubgraph(int v, int k, int lambda, int mi, int r, int s, int f, int g, int d, int t, String input, String output) throws Exception{
		
		charPolynom.clear();
		BufferedReader in = new BufferedReader(new FileReader(input));
		String line;
		while((line=in.readLine())!=null) if (!("".equals(line))) charPolynom.add(line);
		
		PrintStream out = new PrintStream(new FileOutputStream(output));
		String firstPolynomial = "((x_1-"+k+")*(x_1+"+mi+"-"+lambda+"+"+d+") + "+mi+"*"+t+")*((x_1-"+r+")^"+(f-t)+")*((x_1-"+s+")^"+"("+(g-t)+")"+")*";
		out.println("x_1 := Indeterminate( Integers );;");
		for(int j=0;j<charPolynom.size();j++){
			String tmp = charPolynom.get(j);
			String[] splits = tmp.split("\\+|-");
			int dlzka=6; 
			StringBuilder polynomial= new StringBuilder();
			if ((t-1)%2==1){
				polynomial.append("(-1)*");
			}
			polynomial.append("(");
			if ((t-1)%2==1){
				polynomial.append("(-1)*");
			}
			polynomial.append(splits[0]);
			
			for(int i=1;i<splits.length;i++){
				
				String[] spl = splits[i].split("\\^");
				Boolean test = false;
				
				if ((spl.length>1) && (Integer.parseInt(spl[1])%2==1)){
					test=true;
					if (tmp.charAt(dlzka-1)=='+')polynomial.append("-");
					else polynomial.append("+");
				}
				
				else if ((spl.length==1) && (spl[0].contains("x_1"))){
					test=true;
					if (tmp.charAt(dlzka-1)=='+')polynomial.append("-");
					else polynomial.append("+");
				}
					
				if (test==false) polynomial.append(tmp.charAt(dlzka-1));
				polynomial.append(splits[i]);
				dlzka+=splits[i].length()+1;
			}
			polynomial.append(")");
			tmp = polynomial.toString();
			tmp = tmp.replaceAll("x_1","(x_1+"+(mi-lambda)+")");
			out.println("f := "+firstPolynomial+"("+tmp+")"+";");
		}
	
	}
	
}
