#!/bin/sh
echo "APT::Install-Recommends \"false\";" >> /etc/apt/apt.conf
apt-get -y install selinux-policy-default

#setup integrity checks
#beware, aide on debian has lotads of wrapper scripts.
aide --init
cp /var/lib/aide/aide.db.new /var/lib/aide/aide.db

#setup automatic security updates
cp /tmp/postinst/security_sources.list /etc/apt/security_sources.list


#we force it to use only security sources
  echo OPTIONS="-o quiet=1 -o Dir::Etc::SourceList=/etc/apt/security_sources.list -o Dir::Etc::SourceParts=\"/dev/null\"" >> /etc/cron-apt/config

#setup firewall
  cp /tmp/postinst/firewall /etc/init.d/firewall
  chmod 700 /etc/init.d/firewall
  update-rc.d firewall defaults

#setup remote syslog
echo "*.* @@syslog.infrastructure.local" >> /etc/rsyslog.conf

cp /tmp/postinst/ldap.conf /etc/ldap/ldap.conf
cp /tmp/postinst/cpu.conf /etc/cpu/cpu.conf

mkdir -p /opt/ldap-postinst/
cp /tmp/postinst/olc-mod1.ldif /opt/ldap-postinst/
cp /tmp/postinst/olc-mod2.ldif /opt/ldap-postinst/
cp /tmp/postinst/tree.ldif /opt/ldap-postinst/ 
cp /tmp/postinst/ldaps2.ldif /opt/ldap-postinst/ 
cp /tmp/postinst/installscheme.sh /opt/ldap-postinst/ 
chmod +x /opt/ldap-postinst/installscheme.sh  

