unit uFarby;

interface

uses
  Windows, Classes, Graphics, Controls, Forms, Menus, ExtCtrls, StdCtrls,
  Dialogs;

type
  TFarbyForm = class(TForm)
    R1: TRadioButton;
    R2: TRadioButton;
    Shape1: TShape;
    Shape2: TShape;
    Shape3: TShape;
    Shape4: TShape;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    G1: TRadioButton;
    G2: TRadioButton;
    GroupBox3: TGroupBox;
    B1: TRadioButton;
    B2: TRadioButton;
    BS: TScrollBar;
    RS: TScrollBar;
    GS: TScrollBar;
    Label1: TLabel;
    Label2: TLabel;
    GroupBox4: TGroupBox;
    PS: TScrollBar;
    ColorDialog1: TColorDialog;
    NastSpodok: TButton;
    NastVrch: TButton;
    Shape5: TShape;
    Shape6: TShape;
    procedure FormHide(Sender: TObject);
    procedure FarbaChange(Sender: TObject);
    procedure RadioClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure NastVrchClick(Sender: TObject);
    procedure NastSpodokClick(Sender: TObject);
  private
    { Private declarations }
  public
    OnOffMenuItem: TMenuItem;
  end;

var
  FarbyForm: TFarbyForm;
  HornaFarba: TColor = $00008000;
  DolnaFarba: TColor = $00800000;
  LavaFarba,    PravaFarba,
  LavaSFarba,   PravaSFarba,
  LavaNotFarba, PravaNotFarba: TColor;
  {Pri FormCreate sa farby initnu. SFarby su na vypln. NotFarbou sa ORom maze}
  Pozadie: TColor = $00F0F0F0;

implementation

{$R *.dfm}

procedure TFarbyForm.FormHide(Sender: TObject);
begin
  if OnOffMenuItem <> nil then
    OnOffMenuItem.Checked:= false;
end;

procedure TFarbyForm.FormShow(Sender: TObject);
begin
  if OnOffMenuItem <> nil then
    OnOffMenuItem.Checked:= true;
end;

procedure TFarbyForm.FarbaChange(Sender: TObject);
var r, g, b, rr, gg, bb: integer;
begin
  Pozadie:= rgb (255-PS.Position, 255-PS.Position, 255-PS.Position);
  Shape2.Brush.Color:= Pozadie;
  Shape4.Brush.Color:= Pozadie;
  if R1.Checked then begin r:= RS.Position; rr:= r end else begin r:= 0; rr:= 192 end;
  if G1.Checked then begin g:= GS.Position; gg:= g end else begin g:= 0; gg:= 192 end;
  if B1.Checked then begin b:= BS.Position; bb:= b end else begin b:= 0; bb:= 192 end;
  LavaFarba:= rgb (r, g, b);
  LavaSFarba:= rgb (rr, gg, bb);
  Shape1.Brush.Color:= LavaFarba;
  if R2.Checked then begin r:= RS.Position; rr:= r end else begin r:= 0; rr:= 192 end;
  if G2.Checked then begin g:= GS.Position; gg:= g end else begin g:= 0; gg:= 192 end;
  if B2.Checked then begin b:= BS.Position; bb:= b end else begin b:= 0; bb:= 192 end;
  PravaFarba:= rgb (r, g, b);
  PravaSFarba:= rgb (rr, gg, bb);
  Shape3.Brush.Color:= PravaFarba;
end;

procedure TFarbyForm.RadioClick(Sender: TObject);
begin  {pri hocicom, co meni notFarby (aj pozadie scroll bar)}
  LavaNotFarba:= pozadie;
  if R1.Checked then LavaNotFarba:= LavaNotFarba and $FFFFFF00;
  if G1.Checked then LavaNotFarba:= LavaNotFarba and $FFFF00FF;
  if B1.Checked then LavaNotFarba:= LavaNotFarba and $FF00FFFF;
  PravaNotFarba:= pozadie;
  if R2.Checked then PravaNotFarba:= PravaNotFarba and $FFFFFF00;
  if G2.Checked then PravaNotFarba:= PravaNotFarba and $FFFF00FF;
  if B2.Checked then PravaNotFarba:= PravaNotFarba and $FF00FFFF;
  FarbaChange(sender);
end;

procedure TFarbyForm.FormCreate(Sender: TObject);
begin
  DoubleBuffered:= true;
  OnOffMenuItem:= nil;
  RadioClick (Sender);
end;

procedure TFarbyForm.NastVrchClick(Sender: TObject);
begin
  if ColorDialog1.Execute then Shape5.Brush.Color := ColorDialog1.Color;
  HornaFarba:= Shape5.Brush.Color;
end;

procedure TFarbyForm.NastSpodokClick(Sender: TObject);
begin
  if ColorDialog1.Execute then Shape6.Brush.Color := ColorDialog1.Color;
  DolnaFarba:= Shape6.Brush.Color;
end;

end.
