unit uStereo;

interface

uses uDelaunay, ExtCtrls, Graphics, uVrchol, Types, SysUtils;

const
  NVrcholov = MaxVertices;
  BOTTOM_POINT = 0;
  TOP_POINT = 1;

type

  TZnacka = class
    hotx, hoty: integer; {hot spot}
    bmp: TBitmap;
    procedure place(x, y: integer; target: Tcanvas);
    constructor Create(filename: string);
    destructor Destroy; override;
  end;

  TStereogram = class
    private
      n: integer;
      viewX, viewY: double;  {lavy horny roh vyseku z bmpL}
      viewZoom: double;      {bmp(x,y) * viewZoom = img(x,y)}
      selected: integer;
      hlavny: array [BOTTOM_POINT..TOP_POINT] of TVrchol;
      Vrcholy: array of TVrchol;
      TheMesh: TDelaunay;
      imgL, imgR: TImage;
      bmpLr, bmpRr, bmpMapar, bmpAnar, bmpAutor: TBitmap;   {resampled bitmapy do IMGov}
      bmpL, bmpR, bmpMapa, bmpAna, bmpAuto: TBitmap;   {originalne bitmapy}
      TrebaKrmit, TrebaRecalculate: boolean;  {boli zmeny v poli Vrcholy?}
      ZnVrchol, ZnSelected: TZnacka;
      procedure Recalculate;
      procedure NakrmMesh;
      procedure Resample(zdroj, ciel: TBitmap; antialias: boolean);
      function Xbmp2img(x: double): integer;
      function Ybmp2img(y: double): integer;
      function Ximg2bmp(x: double): integer;
      function Yimg2bmp(y: double): integer;
    public
      ofsetX, ofsetY: integer;
      constructor Create(L, R: TImage);
      destructor Destroy; override;
      procedure LoadLeft(name: string);
      procedure LoadRight(name: string);
      procedure SetZoom(zoom: double; DoAntialias: boolean);
      procedure SetZoomMul(mul: double; DoAntialias: boolean);
      procedure VykresliLFotku;
      procedure Vykresli(main, nodes, lines, fotos: boolean);
      function AddPoint(x, y, shift: integer): integer;
      function SelectByLXY(x, y: integer): integer;
      function SelectByRXY(x, y: integer): integer;
      function SelectByID(id: integer): integer;
      procedure DeletePoints;
      procedure DeleteSelected;
      procedure MoveSelected(x, y: integer);
      function MoveShiftByX(x: integer): integer;
      function GetShift: integer;
      procedure MoveMain(pnt, x, y: integer);
      function MoveMainShiftByX(pnt, x: integer): integer;
      function GetMainShift(pnt: integer): integer;
      procedure MoveView(dx, dy: integer);
      procedure VytvorAnaglyf;
      procedure VykresliAnaglyf;
      procedure UlozAnaglyf(name: string);
      procedure VytvorMapu;
      procedure VykresliMapu;
      procedure UlozMapu(name: string);
      procedure VytvorAuto;
      procedure VykresliAuto;
      procedure UlozAuto(name: string);
  end;

implementation

function min (jeden, druhy: integer): integer;
begin
  if jeden < druhy
  then min:= jeden
  else min:= druhy;
end;

function max (jeden, druhy: integer): integer;
begin
  if jeden < druhy
  then max:= druhy
  else max:= jeden;
end;

function TStereogram.Xbmp2img(x: double): integer;
begin
  Xbmp2img:= round((x-viewX)*viewZoom);
end;

function TStereogram.Ybmp2img(y: double): integer;
begin
  Ybmp2img:= round((y-viewY)*viewZoom);
end;

function TStereogram.Ximg2bmp(x: double): integer;
begin
  Ximg2bmp:= round(x/viewZoom + viewX);
end;

function TStereogram.Yimg2bmp(y: double): integer;
begin
  Yimg2bmp:= round(y/viewZoom + viewY);
end;

constructor TZnacka.Create(filename: string);
begin
  bmp:= TBitmap.Create;
  bmp.LoadFromFile(filename);
  bmp.TransparentColor:= clWhite;
  bmp.TransparentMode:= tmFixed;
  bmp.Transparent:= true;
  hotx:= bmp.Height div 2;
  hoty:= bmp.Width  div 2;
end;

destructor TZnacka.Destroy;
begin
  bmp.Free;
end;

procedure TZnacka.place(x, y: integer; target: Tcanvas);
begin
  target.Draw(x-hotx, y-hoty, bmp);
end;

constructor TStereogram.Create(L, R: TImage);
begin
  SetLength(Vrcholy, NVrcholov);
  TheMesh:= TDelaunay.Create;
  n:= 0;
  selected:= -1;
  TrebaKrmit:= false;
  TrebaRecalculate:= false;
  FillChar(hlavny, SizeOf(hlavny), 0);  {Spinavost, ale funguje to} 
  viewX:= 0;
  viewY:= 0;
  viewZoom:= 1;
  imgL:= L;
  imgR:= R;
  bmpL:= TBitmap.Create;
  bmpR:= TBitmap.Create;
  bmpLr:= TBitmap.Create;
  bmpRr:= TBitmap.Create;
  bmpMapa:= TBitmap.Create;
  bmpMapar:= TBitmap.Create;
  bmpAna:= TBitmap.Create;
  bmpAnar:= TBitmap.Create;
  bmpAuto:= TBitmap.Create;
  bmpAutor:= TBitmap.Create;
  ZnVrchol:= TZnacka.Create('data/point.bmp');
  ZnSelected:= TZnacka.Create('data/pointsel.bmp');
end;

destructor TStereogram.Destroy;
begin
  TheMesh.Destroy;
  bmpL.free;
  bmpLr.free;
  bmpR.free;
  bmpRr.free;
  bmpMapa.Free;
  bmpMapar.Free;
  bmpAna.Free;
  bmpAnar.Free;
  bmpAuto.Free;
  bmpAutor.Free;
  SetLength(Vrcholy, 0);
end;

procedure TStereogram.LoadLeft(name: string);
begin
  bmpL.LoadFromFile(name);
  Resample(bmpL, bmpLr, true);
end;

procedure TStereogram.LoadRight(name: string);
begin
  bmpR.LoadFromFile(name);
  Resample(bmpR, bmpRr, true);
end;

procedure TStereogram.SetZoom(zoom: double; DoAntialias: boolean);
begin
  if zoom > 4 then zoom:= 4;
  if zoom < 1/50 then zoom:= 1/50;
  ViewZoom:= zoom;
  Resample(bmpL, bmpLr, DoAntialias);
  Resample(bmpR, bmpRr, DoAntialias);
  Resample(bmpMapa, bmpMapar, DoAntialias);
  Resample(bmpAna, bmpAnar, DoAntialias);
  Resample(bmpAuto, bmpAutor, DoAntialias);
  TrebaRecalculate:= true;
end;

procedure TStereogram.SetZoomMul(mul: double; DoAntialias: boolean);
begin
  SetZoom(mul * ViewZoom, DoAntialias);
end;

procedure TStereogram.Resample(zdroj, ciel: TBitmap; antialias: boolean);
var
  y, x, zx: integer;
  z, c: PByteArray;
  pomerX, pomerY: double;
begin
  ciel.Width:= trunc(zdroj.Width * ViewZoom);
  ciel.Height:= trunc(zdroj.Height * ViewZoom);
  if (ciel.Width = 0) or (ciel.Height = 0) then exit;
  zdroj.PixelFormat:= pf24bit;
  ciel.PixelFormat:=  pf24bit;
  pomerY:= zdroj.Height / ciel.Height;
  pomerX:= zdroj.Width / ciel.Width;
  for y:= 0 to ciel.Height-1 do begin
    z:= zdroj.ScanLine[trunc(y * pomerY)];
    c:= ciel.ScanLine[y];
    for x:= 0 to ciel.Width-1 do begin
      zx:= trunc(x * pomerX)*3;
      c^[x*3+0]:= z^[zx+0];
      c^[x*3+1]:= z^[zx+1];
      c^[x*3+2]:= z^[zx+2];
    end;
  end;
end;

procedure TStereogram.Recalculate;
var i: integer;
begin
  if not TrebaRecalculate then exit;
  for i:= 0 to n-1 do
    with vrcholy[i] do begin
      Lx:= Xbmp2img(x);
      Ly:= Ybmp2img(y);
      Rx:= Xbmp2img(x+shift);
      Ry:= Ybmp2img(y);
    end;
  TrebaRecalculate:= false;
end;

procedure TStereogram.NakrmMesh;
var
  i: integer;
begin
  if not TrebaKrmit then exit;
  TheMesh.DeleteAll;
  for i:= 0 to n-1 do
    with vrcholy[i] do
      TheMesh.AddPoint(x, y, @Vrcholy[i]);
  TrebaKrmit:= false;
end;

procedure TStereogram.Vykresli(main, nodes, lines, fotos: boolean);
var
  i: integer;
  Zn: TZnacka;
begin
  ImgL.Canvas.Pen.Color:= clGray;
  ImgL.Canvas.Brush.Color:= clGray;
  ImgR.Canvas.Pen.Color:= clGray;
  ImgR.Canvas.Brush.Color:= clGray;
  ImgL.Canvas.Rectangle(ImgL.Canvas.ClipRect);
  ImgR.Canvas.Rectangle(ImgR.Canvas.ClipRect);
  if nodes or lines then Recalculate;
  if fotos then begin
    ImgL.Canvas.Draw(Xbmp2img(0), Ybmp2img(0), bmpLr);
    ImgR.Canvas.Draw(Xbmp2img(0+ofsetX), Ybmp2img(0+ofsetY), bmpRr);
  end;    
  if main then begin
    with hlavny[BOTTOM_POINT] do begin
      Lx:= Xbmp2img(x);
      Ly:= Ybmp2img(y);
      Rx:= Xbmp2img(x+shift);
      Ry:= Ybmp2img(y);
      ZnVrchol.place(Lx, Ly, ImgL.Canvas);
      ZnVrchol.place(Rx, Ry, ImgR.Canvas);
    end;
    with hlavny[TOP_POINT] do begin
      Lx:= Xbmp2img(x);
      Ly:= Ybmp2img(y);
      Rx:= Xbmp2img(x+shift);
      Ry:= Ybmp2img(y);
      ZnVrchol.place(Lx, Ly, ImgL.Canvas);
      ZnVrchol.place(Rx, Ry, ImgR.Canvas);
    end;
  end;
  if lines then begin
    NakrmMesh;
    TheMesh.DrawLines(ImgL.Canvas, ImgR.Canvas);
  end;
  if nodes then
    for i:= 0 to n-1 do
      with vrcholy[i] do begin
        if i = selected then Zn:= ZnSelected else Zn:= ZnVrchol;
        Zn.place(Lx, Ly, ImgL.Canvas);
        Zn.place(Rx, Ry, ImgR.Canvas);
      end;
end;

procedure TStereogram.VykresliLFotku;
begin
  ImgL.Canvas.Pen.Color:= clGray;
  ImgL.Canvas.Brush.Color:= clGray;
  ImgL.Canvas.Rectangle(ImgL.Canvas.ClipRect);
  ImgL.Canvas.Draw(Xbmp2img(0), Ybmp2img(0), bmpLr);
end;

function TStereogram.AddPoint(x, y, shift: integer): integer;
begin
  AddPoint:= -1;
  x:= Ximg2bmp(x);
  y:= Yimg2bmp(y);
  shift:= round (shift/viewZoom);
  if n >= NVrcholov then exit;
  if x >= bmpL.Width then exit;
  if x < 0 then exit;
  if y >= bmpL.Height then exit;
  if y < 0 then exit;
  Vrcholy[n].x:= x;
  Vrcholy[n].y:= y;
  Vrcholy[n].shift:= shift;
  TrebaKrmit:= true;
  TrebaRecalculate:= true;
  AddPoint:= n;
  inc(n);
end;

procedure TStereogram.DeletePoints;
begin
  n:= 0; 
  TrebaKrmit:= true;
end;

procedure TStereogram.DeleteSelected;
begin
  if n <= 0 then exit;
  if (selected < 0) or (selected >= n) then exit;
  dec(n);
  Vrcholy[selected]:= Vrcholy[n];
  selected:= -1;
  TrebaKrmit:= true;
end;

procedure TStereogram.MoveSelected(x, y: integer);
begin
  if (selected < 0) or (selected >= n) then exit;
  x:= Ximg2bmp(x);
  y:= Yimg2bmp(y);
  if x >= bmpL.Width then x:= bmpL.Width - 1;
  if x < 0 then x:= 0;
  if y >= bmpL.Height then y:= bmpL.Height - 1;
  if y < 0 then y:= 0;
  Vrcholy[selected].x:= x;
  Vrcholy[selected].y:= y;
  TrebaKrmit:= true;
  TrebaRecalculate:= true;
end;

function TStereogram.MoveShiftByX(x: integer): integer;
begin
  if (selected < 0) or (selected >= n) then begin
    MoveShiftByX:=0;
    exit;
  end;
  x:= Ximg2bmp(x);
  Vrcholy[selected].shift:= x - Vrcholy[selected].x;
  TrebaRecalculate:= true;
  MoveShiftByX:= Vrcholy[selected].shift;
end;

function TStereogram.GetShift: integer;
begin
  if (selected < 0) or (selected >= n) then begin
    GetShift:=0;
    exit;
  end;
  GetShift:= Vrcholy[selected].shift;
end;

procedure TStereogram.MoveMain(pnt, x, y: integer);
begin
  x:= Ximg2bmp(x);
  y:= Yimg2bmp(y);
  if x >= bmpL.Width then x:= bmpL.Width - 1;
  if x < 0 then x:= 0;
  if y >= bmpL.Height then y:= bmpL.Height - 1;
  if y < 0 then y:= 0;
  hlavny[pnt].x:= x;
  hlavny[pnt].y:= y;
end;

function TStereogram.MoveMainShiftByX(pnt, x: integer): integer;
{Vrati rozostup Main bodu v realnych bmp pixeloch}
begin
  x:= Ximg2bmp(x);
  hlavny[pnt].shift:= x - hlavny[pnt].x;
  MoveMainShiftByX:= hlavny[pnt].shift;
end;

function TStereogram.GetMainShift(pnt: integer): integer;
{Vrati rozostup Main bodu v realnych bmp pixeloch}
begin
  GetMainShift:= hlavny[pnt].shift;
end;

function TStereogram.SelectByLXY(x, y: integer): integer;
var i, toler: integer;
begin
  toler:= round(3/viewZoom);
  x:= Ximg2bmp(x);
  y:= Yimg2bmp(y);
  Selected:= -1;
  for i:= 0 to n-1 do
    if (abs (vrcholy[i].x-x) < toler) and (abs (vrcholy[i].y-y) < toler)
    then begin Selected:= i; break; end;
  SelectByLXY:= Selected;
end;

function TStereogram.SelectByRXY(x, y: integer): integer;
var i, toler: integer;
begin
  toler:= round(3/viewZoom);
  x:= Ximg2bmp(x);
  y:= Yimg2bmp(y);
  Selected:= -1;
  for i:= 0 to n-1 do
    if (abs (vrcholy[i].x+vrcholy[i].shift-x) < toler) and (abs (vrcholy[i].y-y) < toler)
    then begin Selected:= i; break; end;
  SelectByRXY:= Selected;
end;

function TStereogram.SelectByID(id: integer): integer;
begin
  if (0<=id) and (id<n) then begin
    SelectByID:= id;
    selected:= id;
  end else begin
    SelectByID:= -1;
    selected:= -1;
  end;
end;

procedure TStereogram.MoveView(dx, dy: integer);
{posunie lavy horny roh img v ramci bmp o (dx,dy) v img jednotkach}
begin
  {nepouzit img2bmp, lebo chceme double}
  viewX:= viewX + dx/viewZoom;
  viewY:= viewY + dy/viewZoom;
  if viewX > bmpL.Width then viewX:= bmpL.Width;
  if viewY > bmpL.Height then viewY:= bmpL.Height;
  if viewX < 0 then viewX:= 0;
  if viewY < 0 then viewY:= 0;
  TrebaRecalculate:= true;
end;

procedure TStereogram.VytvorAnaglyf;
{Prevedie obrazky na odtiene ocnych filtrov a scita ich posunute o
 (OfsetX - hlavny.shift, OfsetY)}
var
  LstartX, LstartY, RstartX, RstartY: integer;
  i, j: integer;
  Lpix, Rpix, pix: PByteArray;
  LpixX, RpixX, pixX, Lavrg, Ravrg: integer;
begin
  if OfsetY >= 0 then begin
    LstartY:= OfsetY;
    RStartY:= 0;
  end else begin
    LstartY:= 0;
    RStartY:= -OfsetY;
  end;
  RStartX:= OfsetX - hlavny[BOTTOM_POINT].shift; //Iba ako temp premenna
  if RStartX >= 0 then begin
    LstartX:= RStartX;
    RStartX:= 0;
  end else begin
    LstartX:= 0;
    RStartX:= -RStartX;
  end;
  bmpAna.Width:= min(bmpL.Width-LstartX, bmpR.Width-RstartX);
  bmpAna.Height:= min(bmpL.Height-LstartY, bmpR.Height-RstartY);
  bmpAna.PixelFormat:= pf24bit;
  bmpL.PixelFormat:= pf24bit;
  bmpR.PixelFormat:= pf24bit;
  for i:= 0 to bmpAna.Height-1 do
  begin
    Lpix:= bmpL.ScanLine[LstartY+i];
    Rpix:= bmpR.ScanLine[RstartY+i];
    pix:= bmpAna.ScanLine[i];
    for j:= 0 to bmpAna.Width-1 do begin
      pixX:= j*3;                   //Tiez iba temp premenne
      LpixX:= (LstartX+j)*3;
      RpixX:= (RstartX+j)*3;
      Lavrg:= (integer(Lpix^[LpixX+0]) + Lpix^[LpixX+1] + Lpix^[LpixX+2]) div 3;
      Ravrg:= (integer(Rpix^[RpixX+0]) + Rpix^[RpixX+1] + Rpix^[RpixX+2]) div 3;
      pix^[pixX+0]:= Ravrg;
      pix^[pixX+1]:= Ravrg;
      pix^[pixX+2]:= Lavrg;
      {pix^[pixX+0]:= (integer(Lpix^[LpixX+0]) + Rpix^[RpixX+0]) div 2;
      pix^[pixX+1]:= (integer(Lpix^[LpixX+1]) + Rpix^[RpixX+1]) div 2;
      pix^[pixX+2]:= (integer(Lpix^[LpixX+2]) + Rpix^[RpixX+2]) div 2; }
    end;
  end;
  Resample(bmpAna, bmpAnar, true);
end;

procedure TStereogram.VykresliAnaglyf;
begin
  ImgR.Canvas.Pen.Color:= clGray;
  ImgR.Canvas.Brush.Color:= clGray;
  ImgR.Canvas.Rectangle(ImgR.Canvas.ClipRect);
  ImgR.Canvas.Draw(Xbmp2img(0), Ybmp2img(0), bmpAnar);
end;

procedure TStereogram.UlozAnaglyf(name: string);
begin
  bmpAna.SaveToFile(name);
end;

procedure TStereogram.VytvorMapu;
var SA: TShiftsArray;
  i, j, pixX: integer;
  pix: PByteArray;
  value: integer;
begin
  bmpMapa.Width:= bmpL.Width;
  bmpMapa.Height:= bmpL.Height;
  bmpMapa.Canvas.Rectangle(0, 0, bmpMapa.Width, bmpMapa.Height);
  NakrmMesh;
  SA:= TheMesh.CreateShiftsArray(0, 0, bmpMapa.Width, bmpMapa.Height, hlavny[BOTTOM_POINT].shift);
  bmpMapa.PixelFormat:= pf24bit;
  for i:= 0 to bmpMapa.Height-1 do
  begin
    pix:= bmpMapa.ScanLine[i];
    for j:= 0 to bmpMapa.Width-1 do begin
      pixX:= j*3;
      value:= round(255 * (SA.valYX[i][j] - hlavny[BOTTOM_POINT].shift) /
        (hlavny[TOP_POINT].shift - hlavny[BOTTOM_POINT].shift));
      if value < 0 then value:= 0;
      if value > 255 then value:= 255;
      pix^[pixX+0]:= value;
      pix^[pixX+1]:= pix^[pixX+0];
      pix^[pixX+2]:= pix^[pixX+0];
    end;
  end;
  SA.Free;
  Resample(bmpMapa, bmpMapar, true);
end;           

procedure TStereogram.UlozMapu(name: string);
begin
  bmpAuto.SaveToFile(name);
end;

procedure TStereogram.VykresliMapu;
begin
  ImgR.Canvas.Pen.Color:= clGray;
  ImgR.Canvas.Brush.Color:= clGray;
  ImgR.Canvas.Rectangle(ImgR.Canvas.ClipRect);
  ImgR.Canvas.Draw(Xbmp2img(0), Ybmp2img(0), bmpMapar);
end;

procedure TStereogram.VytvorAuto;
var SA: TShiftsArray;
  i, j, pixX1, pixX2: integer;
  pix: PByteArray;
begin
  bmpAuto.Width:= bmpL.Width;
  bmpAuto.Height:= bmpL.Height;
  bmpAuto.Canvas.Rectangle(0, 0, bmpAuto.Width, bmpAuto.Height);
  NakrmMesh;
  SA:= TheMesh.CreateShiftsArray(0, 0, bmpAuto.Width, bmpAuto.Height, hlavny[BOTTOM_POINT].shift);
  bmpAuto.PixelFormat:= pf24bit;
  for i:= 0 to bmpAuto.Height-1 do
  begin
    pix:= bmpAuto.ScanLine[i];
    for j:= 0 to bmpAuto.Width*3-1 do
      pix^[j]:= random(256);
    for j:= 0 to bmpAuto.Width-1 do begin
      pixX1:= j*3;
      pixX2:= (j + round(SA.valYX[i][j])) * 3;
      if (pixX2 >= 0) and (pixX2 < bmpAuto.Width*3) then begin
        pix^[pixX1+0]:= pix^[pixX2+0];
        pix^[pixX1+1]:= pix^[pixX2+1];
        pix^[pixX1+2]:= pix^[pixX2+2];
      end;
    end;
  end;
  SA.Free;
  Resample(bmpAuto, bmpAutor, true);
end;

procedure TStereogram.VykresliAuto;
begin
  ImgR.Canvas.Pen.Color:= clGray;
  ImgR.Canvas.Brush.Color:= clGray;
  ImgR.Canvas.Rectangle(ImgR.Canvas.ClipRect);
  ImgR.Canvas.Draw(Xbmp2img(0), Ybmp2img(0), bmpAutor);
end;

procedure TStereogram.UlozAuto(name: string);
begin
  bmpAuto.SaveToFile(name);
end;

end.
