import cgi
import logging

from google.appengine.ext import webapp
from google.appengine.ext.webapp.util import run_wsgi_app
from google.appengine.ext import db
from google.appengine.ext.webapp import template
from google.appengine.api import images

from xml.etree.ElementTree import *
from django.utils import simplejson


class Person(db.Model):
	name = db.StringProperty()
	profile = db.TextProperty()
	id = db.IntegerProperty()
	hasphoto = db.BooleanProperty()

class Trip(db.Model):
	title = db.StringProperty()
	desc = db.TextProperty()
	id = db.IntegerProperty()
	people = db.ListProperty(int)
	
class Point(db.Model):
	lat = db.FloatProperty()
	lng = db.FloatProperty()
	isPlace = db.BooleanProperty()
	trip = db.ReferenceProperty(Trip)
	id = db.IntegerProperty()
	
class Place(db.Model):
	title = db.StringProperty()
	desc = db.TextProperty()
	trip = db.ReferenceProperty(Trip)
	id = db.IntegerProperty()
	point = db.ReferenceProperty(Point)
	
class PersonPhoto(db.Model):
	person = db.ReferenceProperty(Person)
	photo = db.BlobProperty()
	id = db.IntegerProperty()

class PlacePhoto(db.Model):
	place = db.ReferenceProperty(Place)
	photo = db.BlobProperty()
	id = db.IntegerProperty()

def normalizeurl(str):
	if (str[len(str)-1]=='/'):
		return str[:len(str)-1]
	else:
		return str


references = {'Trip':['place','point'], 'Person':['personphoto'], 'Place':['placephoto']}
refsets = {'place':'place_set','point':'point_set', 'personphoto':'personphoto_set', 'placephoto':'placephoto_set'}
colsection = {'person':'people', 'place':'places','point':'points', 'personphoto':'photos','placephoto':'photos'}

forbidden = ['_RESOLVED_trip','_RESOLVED_point','_trip','_photo','_RESOLVED_place']

def getresnamefromurl(url):
	if (url.find(".xml") == -1):
		return url
	return url[:url.find(".xml")]

def getreptypefromurl(url):
	if (url.find(".xml") == -1):
		return "empty"
	return "xml"

def gethref(ob):
	logging.info("href pre "+ob.__class__.__name__) 
	if (ob.__class__.__name__ == 'Person'):
		return "/people/"+str(ob.id)
	if (ob.__class__.__name__ == 'Point'):
		return "/trip/"+str(ob.trip.id)+"/points/"+str(ob.id)
	if (ob.__class__.__name__ == 'Place'):
		return "/trip/"+str(ob.trip.id)+"/places/"+str(ob.id)
	if (ob.__class__.__name__ == 'PlacePhoto'):
		return "/trip/"+str(ob.place.trip.id)+"/places/"+str(ob.place.id)+"/photo/"+str(ob.id)
	if (ob.__class__.__name__ == 'PersonPhoto'):
		return "/people/"+str(ob.person.id)+"/photo/"+str(ob.id)
	if (ob.__class__.__name__ == 'Trip'):
		return "/trip/"+str(ob.id)

def doxml(ob):
	text="<"+ob.__class__.__name__+">"
	logging.info("PARSING: ")
	for a in ob.__dict__:
		if (a in ["_parent_key","_parent","_entity","_app","_people"]) or (a in forbidden):
			continue
		logging.info(a+": ,"+str(ob.__dict__[a])+"; ")
		text+="<"+a+">"
		text+=str(ob.__dict__[a])
		text+="</"+a+">"
	if ('_people' in ob.__dict__):
		text+="<people>"
		for personid in ob.people:
			text+="<href>/people/"+str(personid)+"</href>"
		text+="</people>"
	text+="<href>"
	text+=gethref(ob)
	text+="</href>"
	logging.info("doxml/class name:"+ob.__class__.__name__)
	logging.info("doxml/ref keys:"+references.keys()[0]+references.keys()[1]+references.keys()[2])
	#logging.info("doxml/true?"+str(ob.__class__.__name__] in references.keys()))
	if (ob.__class__.__name__ in references.keys()):
		logging.info("idem refs in doxml ")
		for ref in references[ob.__class__.__name__]:
			col = getattr(ob,refsets[ref])
			col.fetch(20)
			text+="<"+colsection[ref]+">"
			for c in col:
				text+="<href>"
				text+=gethref(c)#str(c.id)
				text+="</href>"
			text+="</"+colsection[ref]+">"
	text+="</"+ob.__class__.__name__+">"
	return text

def getxmlcol(strobj):
	""" tato fcia sluzi na ziskanie kolekcii """
	xmlresp = "<"+colsection[strobj.lower()]+">"
	querytext = "SELECT * FROM "+strobj
	query = db.GqlQuery(querytext)
	results = query.fetch(30)
	for res in results:
		xmlresp+=doxml(res)
	xmlresp+= "</"+colsection[strobj.lower()]+">"
	logging.info("COL XML: "+xmlresp)
	return xmlresp




class TripHandler(webapp.RequestHandler):
	def get(self, * args):
		if (args):
			#chceme /trip/48
			# obsolete. id = normalizeurl(args[0])
			if (args[0].find(".xml") != -1):
				#chceme speci rep
				id=getresnamefromurl(args[0])
				trip = Trip.get_by_id(int(id))
				self.response.headers['Content-Type']="text/xml"
				self.response.out.write(doxml(trip))
			else:
				# chcem html rep
				id = normalizeurl(args[0])
				logging.info("ID DOSLO "+id)
				trip = Trip.get_by_id(int(id))
				placesquery = trip.place_set
				places = placesquery.fetch(10)
				people = []
				for id in trip.people:
					person = db.GqlQuery("SELECT * FROM Person WHERE id="+str(id)).get()
					people.append(person)
				pars = {"trip":trip, "places":places, "people":people}
				self.response.out.write(template.render("tripdetail.html",pars))
				return
		else:
			# chceme /trip
			if (self.request.url.find(".xml") != -1):
				# chceme speci rep xml
				self.response.headers['Content-Type']="text/xml"
				query = db.GqlQuery("SELECT * FROM Trip")
				trips = query.fetch(20)
				resp="<trips>"
				for trip in trips:
					#resp+=one
					resp+=doxml(trip)
				resp+="</trips>"
				logging.info("IDE XML: "+resp)
				self.response.out.write(resp)
				return
			if (self.request.url.find(".json") != -1):
				# chceme speci rep json
				self.response.headers['Content-Type']="text/javascript"
				query = db.GqlQuery("SELECT * FROM Trip")
				trips = query.fetch(20)
				resp = "{'trips':["
				for trip in trips:
					resp+="{'title':"+trip.title+",'href':"+str(trip.id)+"}"
				resp+="]}"
				self.response.out.write(resp)
				return
			else:
				# chceme html rep
				#logging.info(self.request.headers['Content-Type'])
				query = db.GqlQuery("SELECT * FROM Trip")
				msgs = query.fetch(20)
				pars = {"trips":msgs}
				self.response.out.write(template.render("triplist.html",pars))
				return

	def post(self, *args):
			logging.info("TRIP POST:"+self.request.body)
			trip = Trip()
			Jtrip = simplejson.loads(self.request.body)
			trip.title = Jtrip["title"]
			trip.desc = Jtrip["desc"]
			trip.put()
			trip.id = trip.key().id()
			# vytahovat IDcka ludi a pridavat to do listu.
			trip.people = Jtrip["people"]
			trip.put()
			for Jpoint in Jtrip["points"]:
				point = Point()
				point.lat = Jpoint["lat"]
				point.lng = Jpoint["lng"]
				point.isPlace = Jpoint["isPlace"]
				point.trip = trip
				point.put()
				point.id = point.key().id()
				point.put()
			
			self.response.out.write("/trip/"+str(trip.key().id())+"/");

	def put(self,*args):
		logging.info("TRIP UPD: "+self.request.body)
		Jtrip = simplejson.loads(self.request.body)
		trip = Trip.get_by_id(int(normalizeurl(args[0])))
		trip.title = Jtrip['title']
		trip.desc = Jtrip['desc']
		trip.put()
		self.response.out.write("/trip/"+str(trip.id))
		
	def delete(self,* args):
		tripid = normalizeurl(args[0])
		logging.info("del trip"+tripid)
		trip = Trip.get_by_id(int(tripid))
		trip.delete()
		self.response.out.write("/trip/")

class PlaceHandler(webapp.RequestHandler):
	def post(self, * args):
		logging.info("PLACE POST: "+self.request.body)
		place = Place()
		Jplace = simplejson.loads(self.request.body)
		place.title = Jplace['title']
		place.desc = Jplace['desc']
		trip = Trip.get_by_id(int(args[0]))
		place.trip = trip
		if('point' in Jplace.keys()):
			pointid = Jplace['point']
			point = Point.get_by_id(int(pointid))
			place.point = point
		place.put()
		place.id = place.key().id()
		place.put()
		self.response.out.write("/trip/"+args[0]+"/places/"+str(place.id))
		
	def get(self, * args):
		if (len(args) == 1):
			#mame /trip/48/places
			if (self.request.query_string == "xml"):
				self.response.headers['Content-Type']="text/xml"
				self.response.out.write(getxmlcol('Place'))
			else:
				#TODO
				trip = Trip.get_by_id(int(args[0]))
				placesquery = trip.place_set
				col = placesquery.fetch(20)
				resp = "<places>"
				for place in col:
					resp+=doxml(place)
				resp+="<trip><href>/trip/"+args[0]+"</href></trip>"	
				resp+="</places>"
				self.response.headers['Content-Type']="text/xml"
				self.response.out.write(resp)
		if (len(args) == 2):
			#mame /trip/48/places/10
			if (args[1].find(".xml") != -1):
				#chceme reprezentaciu speci
				id = getresnamefromurl(args[1])
				place = Place.get_by_id(int(id))
				self.response.headers['Content-Type']="text/xml"
				self.response.out.write(doxml(place))
			else:
				#chceme html
				place = Place.get_by_id(int(args[1]))
				photos = place.placephoto_set
				pars={"place":place,"tripid":args[0],"photos":photos}
				self.response.out.write(template.render("placedetail.html",pars))
			
	def put(self,*args):
		logging.info("TRIP UPD: "+self.request.body)
		Jplace = simplejson.loads(self.request.body)
		place = Place.get_by_id(int(args[1]))
		place.title = Jplace['title']
		place.desc = Jplace['desc']
		place.put()
		self.response.out.write("/trip/"+args[0]+"/places/"+str(place.id))
	
	def delete(self,* args):
			logging.info("del tr"+args[0]+"pl "+args[1])
			place = Place.get_by_id(int(args[1]))
			place.delete()
			self.response.out.write("/trip/"+args[0])

class PointsHandler(webapp.RequestHandler):
	def get(self, * args):
		trip = Trip.get_by_id(int(args[0]))
		pointsquery = trip.point_set
		points = pointsquery.fetch(20);
		#mame /trip/158/places/48
		if (len(args)==2):
			point = Point.get_by_id(int(args[1]))
			Jpoints="{\"lat\":"+str(point.lat)+",\"lng\":"+str(point.lng)+",\"trip\":"+str(point.trip.id)+"}"
			self.response.out.write(Jpoints)
			return
		#mame /trip/158/places
		else:
			Jpoints = "["
			for point in points:
				isplace = str(point.isPlace).lower()
				if (isplace == "none"):
					isplace = "false";
				Jpoints+="{\"lat\":"+str(point.lat)+",\"lng\":"+str(point.lng)+",\"id\":"+str(point.id)+",\"isPlace\":"+isplace+"}"
				if (point!=points[-1]): 
					Jpoints+=","
			Jpoints += "]"
			self.response.out.write(Jpoints)

class PeopleHandler(webapp.RequestHandler):
	def get(self, * args):
		if (len(args)!=0 and args[0]):
			#mame /trip/(48)/people alebo /people/(48) 
			logging.info("people hndlr url: "+self.request.url)
			if (self.request.url.find("/trip/") != -1):
				#mame /trip/(48)
				trip = Trip.get_by_id(int(args[0]))
				resp = "<people>"
				for id in trip.people:
					person = db.GqlQuery("Select * from Person where id="+str(id)).get()
					resp+=doxml(person)
				resp+="<trip><href>/trip/"+args[0]+"</href></trip>"
				resp+="</people>"
				self.response.headers['Content-Type']="text/xml"
				self.response.out.write(resp)
			else:
				# mame /people/48
				if (args[0].find(".xml") != -1):
					# chceme speci reprezentaciu
					id = getresnamefromurl(args[0])
					rep= getreptypefromurl(args[0])
					if (rep != "xml"):
						#neni to xml(rozsirit na kolekciu)
						self.response.out.write("Zla reprezentacia")
						return
					person = db.GqlQuery("SELECT * FROM Person where id="+id).get()
					self.response.headers['Content-Type']="text/xml"
					self.response.out.write(doxml(person))
				else:
					# chceme html
					query = db.GqlQuery("SELECT * FROM Person where id="+args[0])
					if (query.count() == 0):
						self.response.out.write("osoba neexistuje")
						return
					person = query.get()
					pars = {"person":person}
					self.response.out.write(template.render("persondetails.html",pars))
		else:
			# nemame grupu, mame /people
			if (self.request.query_string.find("page=") != -1):
				# chceme specialnu page do JSONA
				page = int(self.request.query_string[5:])
				people = db.GqlQuery("SELECT * FROM Person").fetch(offset=(page-1)*3,limit=3)
				json="{'people':["
				for person in people:
					json+="{'name':'"+person.name+"', 'id':'"+str(person.id)+"'}"
					if (person!=people[-1]):
						json+=","
				json+="]}"
				self.response.out.write(json)
			elif(self.request.url.find(".xml") != -1):
				# chceme speci rep, zatial XML
				self.response.headers['Content-Type']="text/xml"
				self.response.out.write(getxmlcol('Person'))
			else:
				#chceme html
				logging.info("PEOPLE GET: "+self.request.body)
				query = db.GqlQuery("SELECT * FROM Person")
				#people = query.fetch()
				pars = {"people":query}
				self.response.out.write(template.render("peoplelist.html",pars))
		
	def post(self,* args):
		logging.info("PERSON ADD: "+self.request.body)
		Jpers = simplejson.loads(self.request.body)
		person = Person()
		person.name = Jpers['name']
		person.profile = Jpers['profile']
		person.hasphoto = False
		person.put()
		person.id = person.key().id()
		person.put()
		self.response.out.write("/people/"+str(person.id))
		
	def put(self, *args):
		logging.info("PERSON UPD: "+self.request.body)
		Jperson = simplejson.loads(self.request.body)
		person = Person.get_by_id(int(args[0]))
		person.name = Jperson['name']
		person.profile = Jperson['profile']
		person.put()
		self.response.out.write("/people/"+str(person.id))

	def delete(self,* args):
		logging.info("del pers"+args[0])
		person = Person.get_by_id(int(args[0]))
		person.delete()
		self.response.out.write("/people/")


class PhotoHandler(webapp.RequestHandler):
	def get(self, * args):
		# jedna sa o foto k persone
		if (len(args) ==1 ):
			person = db.GqlQuery("SELECT * FROM Person where id="+args[0]).get()
			photoquery = person.personphoto_set
			photoprop=photoquery.get()
		if (len(args) ==2 ):
			logging.info("place photo col:"+self.request.url)
			if (self.request.url.find("/places") != -1):
				place = db.GqlQuery("SELECT * FROM Place where id="+args[1]).get()
				photos = place.placephoto_set
				resp = "<photos>"
				for photo in photos:
					resp+=doxml(photo)
				resp+="<trip><href>/trip/"+args[0]+"</href></trip>"
				resp+="<place><href>/trip/"+args[1]+"</href></place>"
				resp+="</photos>"
				self.response.headers['Content-Type']="text/xml"
				self.response.out.write(resp)
				return
			else:
				photoprop= db.GqlQuery("SELECT * FROM PersonPhoto where id="+args[1]).get()
		#jedna sa o foto k placeu
		if (len(args) == 3):
			photoprop = db.GqlQuery("SELECT * FROM PlacePhoto where id="+args[2]).get()
		self.response.headers['Content-Type']="image/jpg"
		logging.info("idem poslat fotku cece")
		self.response.out.write(photoprop.photo)

		#add foto
	def post(self,* args):
		#mame fotku k persone
		if (len(args) == 1):
			newphoto = PersonPhoto()
			newphoto.photo = images.resize(self.request.get("image"),250,250)
			person = db.GqlQuery("SELECT * FROM Person where id="+args[0]).get()
			person.hasphoto=True
			newphoto.person = person
			person.put()
			newphoto.put()
			newphoto.id = newphoto.key().id()
			newphoto.put()
			self.redirect("/people/"+args[0])
		# mame fotku k placeu
		if (len(args) == 2):
			newphoto = PlacePhoto()
			newphoto.photo = images.resize(self.request.get("image"),250,250)
			place = db.GqlQuery("SELECT * FROM Place where id="+args[1]).get()
			newphoto.place = place
			newphoto.put()
			newphoto.id = newphoto.key().id()
			newphoto.put()
			self.redirect("/trip/"+args[0]+"/places/"+args[1])

class Static(webapp.RequestHandler):
	def get(self, * args):
		logging.info("INTRO ")
		if (args):
			self.response.out.write("reprezentacia nenajdena")
		else:
			self.response.out.write(template.render("intro.html",{}))


class Api(webapp.RequestHandler):
	def get(self, * args):
		logging.info("API ")
		self.response.out.write(template.render("api.html",{}))

application = webapp.WSGIApplication(
                                     [('/trip/$', TripHandler),
                                      ('/trip$', TripHandler),
                                      ('/trip/(.*)/places/', PlaceHandler),
                                      ('/trip/(.*)/places/(.*)/photo', PhotoHandler),
                                      ('/trip/(.*)/places/(.*)/photo/(.*)', PhotoHandler),
                                      ('/trip/(.*)/places/(.*)', PlaceHandler),
                                      ('/trip/(.*)/people/', PeopleHandler),
                                      ('/trip/(.*)/points/', PointsHandler),
                                      ('/trip/(.*)/points/(.*)', PointsHandler),
                                      ('/trip/(.*)/points', PointsHandler),
                                      ('/trip/(.*)', TripHandler),
                                      ('/people/(.*)/photo', PhotoHandler),
                                      ('/people/(.*)/photo/(.*)', PhotoHandler),
                                      ('/people/(.*)', PeopleHandler),
                                      ('/people.*', PeopleHandler),
                                      ('/trip.*', TripHandler),
                                      ('/api/', Api),
                                      ('/', Static),
                                      ('/(.*)', Static),
                                      ],
                                     debug=True)

def main():
    run_wsgi_app(application)

if __name__ == "__main__":
    main()