/* ************************************************************************** */
/* ************************ communication interface ************************* */
/* ************************************************************************** */

#if !defined(_MPS_CLIENT_LIB_H_INCLUDED_)
#define _MPS_CLIENT_LIB_H_INCLUDED_

#if defined(__MINGW32__)
	#include <winsock2.h>
#else
	#include <sys/types.h>
#endif

u_long getmyid();
int initialize_client(u_long rpid);
int initialize_clients(int num_clients, u_long **clients_ptr, char *argv[]);
void deinitialize_client();

int mps_create(char *mtext, u_long mlength, u_long *message_id_ptr);
int mps_destroy(u_long message_id);
int mps_end();
int mps_recv(char **mtext_ptr, u_long *mlength_ptr, u_long *message_id_ptr, u_long *process_id_ptr, u_long num_process_ids, u_long *process_ids, char *filter);
int mps_send(u_long message_id, u_long num_process_ids, u_long *process_ids);
int mps_send_async(u_long message_id, u_long num_process_ids, u_long *process_ids);
int mps_start(char **mtext_ptr, u_long *mlength_ptr, u_long *message_id_ptr);

#endif
