### Persistent structures

In relationstore an in-memory a data structure that stores relations (from Assignment 1) is 
defined. The structure remembers its previous versions. Ignoring local uses (which could be turned into local variables) there is only one mutable value, a reference to the current version of the data structure. The example shows how atomic reads and writes can be made if you use immutable data.
Besides this one can dettect change fast.

### Asyncio example

The primary source for asyncio contains plenty of examples. 
https://realpython.com/async-io-python/
Hovewer, every I/O they do they use there is a coroutine. This will not always that easy.

If you do cooperative multitasking most/all of the stuff is done in single thread and you do not want to block it. Unfortunately, I/O often includes blocking call. To do this in a non-blocking way you need some operating system support or another thread (which you don't care if it blocks).
Even if you use other tools they boil down to one of these. 

*Example:* If you want to work with files, asyncio event loop contains methods like .add_reader(...) which makes the file descriptor being monitored by the event loop. When reading is done a function is called. This approach would work fine in JavaScript, where asynchronous computations based on callbacks are common. It is not tat nice in Python, its syntax makes callback-based code a byt clumsy(but it is doable). Note that internally, files have to be handled in a way similar to the system call select. The event loop can handle this, but it cannot return a value easily. If you work with sockets instead, you have loop.sock_recv defines a nice coroutine.

If you need to do a blocking operation you have another possibility. For the sake of the call you leave cooperative multitasking and use preemptive multitasking. You do this just to call a function, thus no state is shared thus no memory-related race conditions can occur. On the other hand if you do just this your application can slow down to the level attained by cooperative multitasking.

The example I present is doable in a fully asynchronous manner. However, this would require me to use more external libraries or more low level code. I believe writing it in this slightly sub-optimal way is better for you to get the core concepts.




