# Functional programming

# From Wikipedia
# In computer science, functional programming is a programming paradigm where programs are constructed by applying and composing functions. It is a declarative programming paradigm in which function definitions are trees of expressions that map values to other values, rather than a sequence of imperative statements which update the running state of the program. 

# We have functional programming and declarative paradigm.
# This are two distinct things, but there is a relation. 
# Traditional functional programming languages:
# Haskell
# Lisp
# Clojure
# OCaml

# Although we have purely functional languages, one can do functional 
# programming in general purpose languages like Python, Java



# Wikipedia

# Concepts in FP according to Wikipedia
# Lets discus them considering Haskell and Python.

# First-class and higher-order functions
# We can do this conveniently both in Haskell and in Python. This is somewhat a micro choice.
# A class (e.g. implementing strategy pattern) is often just a function. 
# For me this is just a low level decision on what is easiest to understand and read in each specific case.

# Pure functions
# Very important architecturally significant requirement.
# Pure function is a function that behaves like mathematical function. This makes the results very predictable and helps with testing.
# For me this is very important aspect of functional programming. 
# As a drawback, we need side effects to make a working application. Mowing side effects away from regular code may make things more complicated. 
# There is no problem doing pure functions in python

# Recursion
# For me, this is low level decision. Recursion is more often more declarative.
# In many functional languages you can even define F_{n+2}=F_{n+1}+F_n and the program works in linear time.
# Some languages e.f. Coq only does recursion if one can prove it finishes.
# These are nice to have features, but it also adds significant complexity.
# These features are in my opinion not essential.

# Strict versus non-strict evaluation
# Related to recursion

# Type systems
# Strong type systems are helpful. If we want we can do a lot using Python type annotations. 
# Using too involved type systems adds significant complexity.

# Referential transparency
# Very important architecturally significant requirement.
# We want to work with Values. Values are immutable and place independent.


# Data structures
# Data structures need to change a lot to guarantee referential transparency.

# To sum stuff the high level aspects are
# Pure functions
# Referential transparency

# Immutable data structures
# Repeat quickly PTS2 lecture

# Functional and OOP 
# Functional programming and OOP are not mutually exclusive. 
# You can have referationaly transparent classes storing values with methods that are pure functions. 
# If you use a general purpose language like Python, you do not need to be prudent.
# It is practical to allow some side effect - those that you do not want to test.
# E.g. Logging

# Example - Azul game
# See pts 23/24 project

# Example 1 - UsedTiles
# Make a class immutable by returning values

# Example 2 - DiceThrower class

# Example 3 - Factory - TableCenter interaction 
# You design around data - and data has to be a tree.

# Solutions
# 1. Pass TableCenter to Factory.
# - Not so great information hiding. We cannot hide TableCenter as it is return value.
# 2. TableCenter returns the tiles to add
# - May be complicated if the interaction is complex
# 3. Separate data and behavior 
# - Worse information hiding. Against OOP.


# Information hiding and test doubles

# In 2. Every class has just one client
# In 1. The return type has to be of one type anyway. 
# 1. and 2. more or less force a single interface: implementation and test double behind it.
# 3. We cannot hide the internal state

# Note that we need to pre-initialize mocks for the whole test run (higher order functions are useful here). 

# The drawbacks are compensated b the fact that data is referentialy transparent, which makes tracking stuff easier.

