# Currying - pure functional languages often use curried functions
def sum3a(x):
    def sum2(y):
        def sum1(z):
            return x+y+z
        return sum1
    return sum2

def curry(func):
    def curried(*args):
        if len(args) == func.__code__.co_argcount:
            return func(*args)
        else:
            return lambda x: curried(*(args + (x,)))
    return curried

@curry
def sum3(x, y, z):
    return x + y + z

sum3(2)(4)(5)
sum3(2,4,5)

# Has particular applications

(Just s) `comb` mother

(mother s)

# Definition
# https://en.wikipedia.org/wiki/Monad_(functional_programming)

# Example 1
# https://wiki.haskell.org/All_About_Monads
# + List as a monad

# C++ monadic operators for
# Optional
# https://en.cppreference.com/w/cpp/utility/optional
# https://en.cppreference.com/w/cpp/utility/expected

# How about functions with multiple parameters
# https://wiki.haskell.org/All_About_Monads
# do notation
# https://en.wikipedia.org/wiki/Monad_(functional_programming)
# do notation

# A try to do monads with with functions with multiple arguments in Python

def bind(optional, function):
    if optional is None:
        return None
    else:
        return function(optional)


def calculation(m1, m2, m3):
    return bind(m1, lambda a: bind(m2, lambda b: bind(m3, lambda c: sum3(a, b, c))))



